//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldH3dKusaModel.cpp
 *	@brief  ~VF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2011.12.15
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define BUILD_XY

#if defined BUILD_XY
  #include <field/FieldH3dKusaModel.h>
#else
  #include "FieldH3dKusaModel.h"
#endif


namespace field {
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------  
FieldH3dKusaModel::FieldH3dKusaModel(void) : xy_system::H3dShaderModel()
{
  for( s32 i = 0; i < MaterialMax; ++i )
  {
    m_Materials[ i ] = NULL;
  }
}
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
FieldH3dKusaModel::~FieldH3dKusaModel()
{
  
}


//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldH3dKusaModel::Create(
      gfl::heap::NwAllocator*                   allocator,
      gfl::heap::NwAllocator*                   device_allocator,
      gfl::grp::g3d::H3dResource*               resource,
      s32                                       index_in_resource,
      xy_system::H3dShaderModel::Description*   description
  )
{
  xy_system::H3dShaderModel::Create( allocator, device_allocator, resource, index_in_resource, description );
  readShaderParam(allocator);
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldH3dKusaModel::readShaderParam(gfl::heap::NwAllocator* allocator)
{
  m_MaterialCount = this->GetMaterialCount();
  
  for( int i = 0; i < m_MaterialCount; ++i )
  {
    const char*                     materialName = this->GetMaterialName( i );
    s32                             index = materialName[3] - '0';//SڂCfbNXB̓GNX|[^[ł閼OB
    
    //m_Materials[index] = material;
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldH3dKusaModel::setVertexShaderParam( nw::gfx::Material *material, s32 id, s32 elementNo, f32 param )
{
#if 0  
  nw::gfx::ResMaterial           res_material = material->GetShaderParameterResMaterial();  // GetShadingParameterResMaterial

  for ( int i2 = 0; i2 < res_material.GetShaderParametersCount(); ++i2  )
  {
    nw::gfx::res::ResShaderParameter      res_param = res_material.GetShaderParameters( i2 );

    if( id == res_param.GetSymbolIndex() )
    {
      f32     *pData = res_param.GetParameter().GetValueF32();
      pData[elementNo] = param;
      material->GetShaderParameterResMaterial().SetShaderParametersHash(0);
      break;
    }
  }
#endif
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
f32 FieldH3dKusaModel::getVertexShaderParam( nw::gfx::Material *material, int id, s32 elementNo )
{
#if 0  
  nw::gfx::ResMaterial           res_material = material->GetShaderParameterResMaterial();  // GetShadingParameterResMaterial

  for ( int i2 = 0; i2 < res_material.GetShaderParametersCount(); ++i2  )
  {
    nw::gfx::res::ResShaderParameter      res_param = res_material.GetShaderParameters( i2 );

    if( id == res_param.GetSymbolIndex() )
    {
      const f32     *pData = res_param.GetParameter().GetValueF32();
      return pData[elementNo];
    }
  }
#endif  
  return 0.0f;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void FieldH3dKusaModel::SetShapeDrawFlag( s32 grid_x, s32 grid_y, b32 flag )
{
#if 0  
  s32                 gridID = grid_y * GridXMax + grid_x;
  s32                 materialIndex = gridID / GridIncludeMax;
  s32                 localID = gridID % GridIncludeMax;
  s32                 paramNo = (localID / VectorParameterElementNum) + VectorParameterTopIndex;
  s32                 elementNo = localID % VectorParameterElementNum;
  const char*         pModelName = this->GetNwModel()->GetName();
  
  //ISHIGURO_PRINT("SetShapeDrawFlag : %s\n", pModelName, grid_x, grid_y );
  
  if ( m_Materials[materialIndex] == NULL )
    return;
  
  setVertexShaderParam( m_Materials[materialIndex], paramNo, elementNo, flag ? 1.0f : 0.0f );
#endif
}

}  // namespace xy_system

