//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldH3dKusaModel.h
 *	@brief  ~VF[_[f
 *	@author	Masateru Ishiguro
 *	@date		2011.12.15
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#ifndef __Field_H3d_Kusa_MODEL_H__
#define __Field_H3d_Kusa_MODEL_H__

// CTR_SDK

// NW4C
#include <nw/gfx.h>
#include <nw/gfx/gfx_Model.h>

// gflib
#include <gfl_Macros.h>
#include <gfl_Heap.h>

//  gflib grp
#include <grp/gfl_RenderTarget.h>

// gflib grp g3d
#include <grp/g3d/gfl_G3dModel.h>
#include <grp/g3d/gfl_G3dCamera.h>
#include <grp/g3d/gfl_G3dShadowGroup.h>

#include <math/gfl_Vec.h>
#include <math/gfl_MathAABB.h>

#include <base/gfl_KeyContainer.h>

#define BUILD_XY

#if defined BUILD_XY
  #include <system/H3dShaderModel.h>
#else
  #include "H3dShaderModel.h"
#endif

#define DECLARE_ENUM_BEGIN( CLASSNAME )	\
	class CLASSNAME {											\
	public:																\
		enum Enum {
#define DECLARE_ENUM_END( CLASSNAME )		\
		};                                  \
	};

namespace field {
  
class FieldH3dKusaModel : public xy_system::H3dShaderModel
{
  GFL_FORBID_COPY_AND_ASSIGN(FieldH3dKusaModel);
  
  struct CustomParam{
    enum{
      ShaderSymbol_1 = 0,
      ShaderSymbol_2,
      ShaderSymbol_3,
      ShaderSymbol_4,
      ShaderSymbol_5,
      ShaderSymbol_6,
      ShaderSymbol_7,
      ParamMax
    };
    
    gfl::math::VEC4             m_Value[ParamMax];
  };
  
public:
  
  struct MetaBallParam{
    gfl::math::VEC3       m_OwnPos;           ///! g̈ʒu
    gfl::math::VEC3       m_LeftPos;          ///! Ώۂڂ̈ʒu
    gfl::math::VEC3       m_RightPos;         ///! EΏۂڂ̈ʒu
    
    f32                   m_LeftPipeCurve;    ///! pCv̋Ȃ
    f32                   m_RightPipeCurve;   ///! pCv̋Ȃ
    f32                   m_LeftPipeWidth;    ///! pCv
    f32                   m_RightPipeWidth;   ///! pCv
    
    gfl::math::VEC2       m_LeftCurveWaight;  ///! pCvȂé͈idj
    gfl::math::VEC2       m_RightCurveWaight; ///! pCvȂé͈idj
    
    f32                   m_LeftKusaAlpha;    ///! ȂƂ͈̑
    f32                   m_RightKusaAlpha;   ///! ȂƂ͈̑
    
    f32                   m_LeftAnimTime;     ///! Đ(0.0?1.0f)
    f32                   m_RightAnimTime;    ///! Đ(0.0?1.0f)
    
    f32                   m_MyRadius;         ///! ̔a
    f32                   m_LeftRadius;       ///! Ώ۔a
    f32                   m_RightRadius;      ///! EΏ۔a
    f32                   m_MerikomiScale;    ///! ߂荞݃XP[(ŒlɂȂH)
    
    MetaBallParam():
      m_MerikomiScale(1.0f)
    {
      
    }
  };
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   *                 Create͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  FieldH3dKusaModel(void);
  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   *                 DestroyĂт܂B
   */
  //-----------------------------------------------------------------------------
  virtual ~FieldH3dKusaModel();
  
  //-----------------------------------------------------------------------------
  /*
   *  @brief         
   *
   *  @param[in]     allocator          AP[^
   *  @param[in]     device_allocator   foCX̃AP[^
   *  @param[in]     resource           \[X
   *  @param[in]     index_in_resource  \[XɂCfbNX
   *  @param[in]     description        ݒe
   */
  //-----------------------------------------------------------------------------
  virtual void Create(
      gfl::heap::NwAllocator*                   allocator,
      gfl::heap::NwAllocator*                   device_allocator,
      gfl::grp::g3d::H3dResource*               resource,
      s32                                       index_in_resource,
      xy_system::H3dShaderModel::Description*   description  = NULL
  );
  
  void SetShapeDrawFlag( s32 grid_x, s32 grid_y, b32 flag );
  
private:
  
  static const int              GridXMax = 40;
  static const int              GridYMax = 40;
  static const int              GridMax = GridXMax * GridYMax;
  static const int              GridIncludeMax = 200;
  static const int              MaterialMax = GridMax / GridIncludeMax;
  static const int              VectorParameterElementNum = sizeof( gfl::math::VEC4 ) / sizeof( f32 );
  static const int              VectorParameterTopIndex = 1;
  
  s32                           m_MaterialCount;
  nw::gfx::Material             *m_Materials[ MaterialMax ];
  
  void readShaderParam(gfl::heap::NwAllocator* allocator);
  void setVertexShaderParam( nw::gfx::Material *material, s32 id, s32 elementNo, f32 param );
  f32 getVertexShaderParam( nw::gfx::Material *material, int id, s32 elementNo );

};
  
#undef		DECLARE_ENUM_BEGIN
#undef		DECLARE_ENUM_END

}  // namespace xy_system

#endif
