
//=============================================================================
/**
 * @file   gfl_G3dCameraViewClip.h
 * @brief  Jr[NbvNXwb_
 * @author rc N
 * @date   2012.08.25
 */
//=============================================================================

#ifndef __GFL_G3D_CAMERA_VIEW_CLIP_H__
#define __GFL_G3D_CAMERA_VIEW_CLIP_H__

#include "math/gfl_MathPlane.h"

// #define IS_DEBUG_CAMERA_VIEW_CLIP

namespace gfl { namespace grp { namespace g3d
{
  //-----------------------------------------------------------------------------
  /**
   * @brief J̃r[NbvsNX
   */
  //-----------------------------------------------------------------------------
  class CameraViewClip
  {
  private:
    enum { PLANE_NUM = 6 }; ///< `邽߂ɕKvȕʂ̐
    gfl::math::Plane m_ainPlane[PLANE_NUM]; ///< `镽ʒB

#ifdef IS_DEBUG_CAMERA_VIEW_CLIP
    gfl::math::VEC3 m_ainDebugPosi[PLANE_NUM]; ///< fobOŕʂ`悷ƂɎgpʒu
#endif

  public:
    CameraViewClip(); ///< RXgN^
    void Update(const gfl::grp::g3d::Camera& inCamera); ///< t[

    bool IsClip(const gfl::math::AABB_VEC3& inAABB); ///< AABB̃Nbvs

#ifdef IS_DEBUG_CAMERA_VIEW_CLIP
    int  GetPlaneNumberForDebug() const { return PLANE_NUM; } ///< ʂ̐擾
    void GetPlaneForDebug(gfl::math::VEC3* pNormDir, gfl::math::VEC3* pPosi, const int nIndex) const ///< ʂ擾
    { m_ainPlane[nIndex].GetNormalVector(pNormDir); (*pPosi) = m_ainDebugPosi[nIndex]; }
#endif
  };

} } } // namespace gfl::grp::g3d

#endif // __GFL_G3D_CAMERA_VIEW_CLIP_H__

/*  EOF  */





