
//=============================================================================
/**
 * @file   gfl_MathPlane.h
 * @brief  ʐNXwb_
 * @author rc N
 * @date   2012.08.25
 */
//=============================================================================

#ifndef __GFL_MATH_PLANE_H__
#define __GFL_MATH_PLANE_H__

namespace gfl { namespace math
{
  //-----------------------------------------------------------------------------
  /**
   * @brief ʐNX
   */
  //-----------------------------------------------------------------------------
  class Plane
  {
  public:
    VEC4 abcd; ///< ax + by + cz + d = 0

  public:
    Plane() { return ; } ///< RXgN^P
    Plane(const VEC4& __abcd__) : abcd(__abcd__) { return ; } ///< RXgN^Q
    Plane(const float a, const float b, const float c, const float d) : abcd(a, b, c, d) { return ; } ///< RXgN^R
    Plane(const VEC3& normVec, const VEC3& posi) { Set(normVec, posi); } ///< RXgN^S

    inline void Set(const VEC4& __abcd__) { abcd = __abcd__; }
    inline void Set(const float a, const float b, const float c, const float d) { abcd = VEC4(a, b, c, d); } ///< lݒP
    //-----------------------------------------------------------------------------
    /**
     * @brief lݒQ
     *
     * @param normVec @xN^(KĂKv͂Ȃ)
     * @param posi    ʂɊ܂܂Cӂ̈ʒu
     */
    //-----------------------------------------------------------------------------
    inline void Set(const VEC3& normVec, const VEC3& posi) { abcd = VEC4(normVec.x, normVec.y, normVec.z, -VEC3Dot(&normVec, &posi)); }

    inline void AddD(const float d) { abcd.w += d; } ///< DlZ
    inline void Normalize() ///< K
    {
      const float len = VEC3Len(reinterpret_cast<VEC3* >(&abcd));
      VEC4Scale(&abcd, &abcd, 1.0f/len);
    }

    inline const gfl::math::VEC4& GetPlaneVector() const { return abcd; } ///< ʃxN^擾
    inline void GetNormalVector(VEC3* v) const { v->x = abcd.x, v->y = abcd.y, v->z = abcd.z; } ///< @xN^擾(KĂۏ؂͂Ȃ)

    /// ͈ʒu畽ʂ܂ł̍ŒZ擾
    inline float GetDistance(const VEC3& posi) const { return VEC3Dot(reinterpret_cast<const VEC3* >(&abcd), &posi) + abcd.w; }

    //-----------------------------------------------------------------------------
    /**
     * @brief _Ƃ̏Փ˔s
     *
     * @param posi    _̈ʒu
     * @param epsilon Փ˂ĂƔfĂ悢CvVl
     *
     * @retval true  Փ˂Ă
     * @retval false Փ˂ĂȂ
     */
    //-----------------------------------------------------------------------------
    inline bool IsHitPoint(const VEC3& posi, const float epsilon = 0.001f) const { return (FAbs(GetDistance(posi)) <= epsilon); }

    //-----------------------------------------------------------------------------
    /**
     * @brief Ƃ̏Փ˔s(FdȂĂ鎞falseԂ)
     *
     * @param hitPosi  Փˈʒu
     * @param srcPosi  n_
     * @param destPosi I_
     *
     * @retval true  Փ˂Ă
     * @retval false Փ˂ĂȂ
     */
    //-----------------------------------------------------------------------------
    bool IsHitLine(VEC3* hitPosi, const VEC3& srcPosi, const VEC3& destPosi) const ;
  };

} } // namespace gfl::math

#endif // __GFL_MATH_PLANE_H__

/*  EOF  */





