#if !defined( __APP_HOLOGRAMMAIL_NETWORK_SELECT_MENU_H__ )
#define __APP_HOLOGRAMMAIL_NETWORK_SELECT_MENU_H__
//============================================================================================
/**
 * @file    app_hologrammail_NetworkSelectMenu.h
 * @brief   lbg[NIj[
 * @author  suzuki_hisanao
 */
//============================================================================================
#pragma  once

#include <gflib.h>
#include <app/tool/app_tool_MenuWindow.h>
#include <app/tool/app_tool_MenuWindowSystem.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)


class NetworkSelectMenu {
public:
  // 
  enum Result{
    UPDATE_WIRELESS = 0,  // [JʐM
    UPDATE_WIFI,          // C^[lbgʐM
    UPDATE_CANCEL,        // ߂
    UPDATE_NONE,          // 
  };

  // ftHg\W
  static const s16 DEFAULT_PX = 160;
  static const s16 DEFAULT_PY = -35;

  //--------------------------------------------------------------------------------------------
  /**
   * @brief   RXgN^
   *
   * @param   heap      q[v
   * @param   devheap   foCXq[v
   * @param   devMan    foCX}l[W
   * @param   graSys    OtBbNVXe
   * @param   lytSys    CAEgVXe
   * @param   msgData   bZ[Wf[^
   * @param    setup      CAEgZbgAbvf[^
   * @param    frame      t[[g@ftHg = 60
   * @param    disp      \ʁ@ftHg = 
   * @param    x          XW@ftHg = DEFAULT_PX
   * @param    y          YW@ftHg = DEFAULT_PY
   */
  //--------------------------------------------------------------------------------------------
  NetworkSelectMenu(
    gfl::heap::HeapBase * heap,
    gfl::heap::HeapBase * devHeap,
    const gfl::ui::DeviceManager * devMan,
    gfl::grp::GraphicsSystem * graSys,
    gfl::grp::g2d::LytSys * lytSys,
    gfl::str::MsgData * msgData,
    const gfl::grp::g2d::LytWkSetUp * setup,
    gamesystem::FrameMode frame = gamesystem::FRAMEMODE_60,
    gfl::grp::DisplayType disp = gfl::grp::DISPLAY_LOWER,
    s16 x = DEFAULT_PX, s16 y = DEFAULT_PY,
    app::tool::MenuWindowSystem::Design design = app::tool::MenuWindowSystem::DESIGN_APP );


  //--------------------------------------------------------------------------------------------
  /**
   * @brief    fXgN^
   */
  //--------------------------------------------------------------------------------------------
  ~NetworkSelectMenu(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief    Abvf[g
   *
   * @param    none
   *
   * @retval  "UPDATE_YES = ͂"
   * @retval  "UPDATE_NO = "
   * @retval  "UPDATE_NONE = ȊO"
   */
  //--------------------------------------------------------------------------------------------
  int Update(void);

  //--------------------------------------------------------------------------------------------
  /**
   * @brief    `
   *
   * @param    none
   *
   * @return  none
   */
  //--------------------------------------------------------------------------------------------
  void Draw(void);

  //--------------------------------------------------------------------------------------------
  /**
   *  @brief    `tO𗧂Ă܂
   */
  //--------------------------------------------------------------------------------------------
  void SetAutoDrawFlag(bool flag);

  void SetPriority( u32 priority );

  //--------------------------------------------------------------------------------------------
  /**
   *  @brief    \E\ݒ܂BUpdate񂵂܂Bi`掞͂Ȃɂ܂j
   *
   *  @param flag trueŕ\iftHgj  falseŔ\
   */
  //--------------------------------------------------------------------------------------------
  void SetVisible( bool flag );

  //--------------------------------------------------------------------------------------------
  /**
   *  @brief    \Ԃ𔻒
   *
   *  @return trueŕ\iftHgj  falseŔ\
   */
  //--------------------------------------------------------------------------------------------
  bool IsVisible(void) const;

  //--------------------------------------------------------------------------------------------
  /**
   *  @brief  JniRXgN^StartĂ܂BēxStartƂĂłj
   */
  //--------------------------------------------------------------------------------------------
  void Start( void );
private:
  static const u32  TEMP_STR_LEN = 32;   // TCY
  //
  app::tool::MenuWindow*       pMenuWin;
  app::tool::MenuWindowSystem* pMenuWinSys;
  bool                         isVisible;
};




GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)



#endif // __APP_HOLOGRAMMAIL_NETWORK_SELECT_MENU_H__
