//============================================================================================
/**
 * @file    app_hologrammail_NetworkSelectMenu.cpp
 * @brief   lbg[NIj[
 * @author  suzuki_hisanao
 */
//============================================================================================
#include "app_hologrammail_NetworkSelectMenu.h"
#include <message/msg_hologram_mail.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)

//--------------------------------------------------------------------------------------------
/**
 * @brief   RXgN^
 *
 * @param   heap      q[v
 * @param   devheap   foCXq[v
 * @param   devMan    foCX}l[W
 * @param   graSys    OtBbNVXe
 * @param   lytSys    CAEgVXe
 * @param    setup      CAEgZbgAbvf[^
 * @param    frame      t[[g
 * @param   disp      \
 * @param   x         XW
 * @param   y         YW
 */
//--------------------------------------------------------------------------------------------
NetworkSelectMenu::NetworkSelectMenu(
  gfl::heap::HeapBase * heap,
  gfl::heap::HeapBase * devHeap,
  const gfl::ui::DeviceManager * devMan,
  gfl::grp::GraphicsSystem * graSys,
  gfl::grp::g2d::LytSys * lytSys,
  gfl::str::MsgData * msgData,
  const gfl::grp::g2d::LytWkSetUp * setup,
  gamesystem::FrameMode frame,
  gfl::grp::DisplayType disp,
  s16 x, s16 y,
  app::tool::MenuWindowSystem::Design design ) :
  isVisible( true )
{
  // j[VXe
  pMenuWinSys = GFL_NEW_LOW( heap ) app::tool::MenuWindowSystem(
                                      heap, devHeap, devMan, graSys, lytSys, frame, setup,
                                      app::tool::MenuWindowSystem::INPUT_TYPE_RELEASE,
                                      design,
                                      app::tool::MenuWindowSystem::NOTIFY_AFTER_ANIME );
  // j[
  app::tool::MenuWindow::MenuParameter prm = {
    disp,
    app::tool::MenuWindow::X_POSITION_TYPE_RIGHT,
    app::tool::MenuWindow::Y_POSITION_TYPE_BOTTOM,
    x, y,
    app::tool::MenuWindow::MIN_WINDOW_WIDTH,
    3, 1,
    true
  };
  pMenuWin = GFL_NEW_LOW( heap ) app::tool::MenuWindow( heap, prm );

  // ڒǉ
  static const app::tool::MenuWindow::AlternativeParameter ap[] =
  {
    { 0, 0, UPDATE_WIRELESS, false, false },  // [JʐM
    { 1, 0, UPDATE_WIFI,     true,  false },  // C^[lbgʐM
    { 2, 0, UPDATE_CANCEL,   true,  false },  // ߂
  };
  static  const u32 str[] = {
    msg_boss_menu_05,
    msg_boss_menu_06,
    msg_boss_menu_07,
  };

  gfl::str::StrBuf * buf = GFL_NEW_LOW( heap ) gfl::str::StrBuf( TEMP_STR_LEN, heap );

  for( int i=0; i<GFL_NELEMS(str); i++ ){
    msgData->GetString( str[i], *buf );
    pMenuWin->AddAlternative( ap[i], buf );
  }

  GFL_DELETE buf;

  pMenuWinSys->SetMenuWindow( pMenuWin );
  pMenuWinSys->Start();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//--------------------------------------------------------------------------------------------
NetworkSelectMenu::~NetworkSelectMenu(void)
{
  GFL_DELETE pMenuWinSys;
  GFL_DELETE pMenuWin;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Abvf[g
 *
 * @param   none
 *
 * @retval  "UPDATE_YES = ͂"
 * @retval  "UPDATE_NO = "
 * @retval  "UPDATE_NONE = ȊO"
 */
//--------------------------------------------------------------------------------------------
int NetworkSelectMenu::Update(void)
{
  if( isVisible )
  {
    pMenuWinSys->UpdateControl();
    pMenuWinSys->UpdateView();

    if( pMenuWinSys->IsAlternativeSelected() == true ){
      return pMenuWinSys->GetSelectedAlternativeValue();
    }
  }
  return UPDATE_NONE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   `
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void NetworkSelectMenu::Draw(void)
{
  if( isVisible )
  {
    pMenuWinSys->DrawMenuWindow();
  }
}
//--------------------------------------------------------------------------------------------
void NetworkSelectMenu::SetAutoDrawFlag(bool flag)
{
  pMenuWinSys->SetAutoDrawFlag(flag);
}

void NetworkSelectMenu::SetPriority( u32 priority )
{
  pMenuWinSys->SetLayoutPriority( priority );
}


void NetworkSelectMenu::SetVisible( bool flag )
{
  isVisible = flag;
}

//--------------------------------------------------------------------------------------------
/**
 *  @brief    \Ԃ𔻒
 *
 *  @return trueŕ\iftHgj  falseŔ\
 */
//--------------------------------------------------------------------------------------------
bool NetworkSelectMenu::IsVisible(void) const
{
  return isVisible;
}

//--------------------------------------------------------------------------------------------
/**
 *  @brief  JniRXgN^StartĂ܂BēxStartƂĂłj
 */
//--------------------------------------------------------------------------------------------
void NetworkSelectMenu::Start( void )
{
  pMenuWinSys->Start();
}

GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)
