//============================================================================================
/**
 * @file		GeoUtility.cpp
 *
 * @brief		GeoUtilityNX
 *          static֐ɂċ@\񋟂B
 */
//============================================================================================

#include <netapp/util/GeoUtility.h>
#include <math.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(util)

static const f32 EARTH_R = 6378.137;//n̔aikmj

//--------------------------------------------------------------------------------------------
/**
 * @brief		RXgN^(B)
 */
//--------------------------------------------------------------------------------------------
GeoUtility::GeoUtility( void )
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief		fXgN^(B)
 */
//--------------------------------------------------------------------------------------------
GeoUtility::~GeoUtility(void)
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief   ̌oxܓx玩Ƃ̋(km)Zo
*
* @param   longtitude ̌ox
* @param   latitude ̈ܓx
*
* @return  ƎƂ̋(km)
*/
//--------------------------------------------------------------------------------------------
/*static*/ u32 GeoUtility::GetGeoDistance( u16 longtitude, u16 latitude )
{
	savedata::MyStatus* pMyStatus = GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetGameData()->GetPlayerStatus();
	u16 myLongitude = pMyStatus->GetLongitude();//̌ox
	u16 myLatitude = pMyStatus->GetLatitude();//̈ܓx
	
	f32 myAngleLongtitude = _CalcAngleLongtitude( myLongitude );
	f32 myAngleLatitude = _CalcAngleLatitude( myLatitude );
	f32 angleLongtitude = _CalcAngleLongtitude( longtitude );
	f32 angleLatitude = _CalcAngleLatitude( latitude );
	
	//GFL_PRINT("myTude[0x%x][0x%x]myAngle[%f][%f]distAngle[%f][%f]",myLongitude,myLatitude,myAngleLongtitude,myAngleLatitude,angleLongtitude,angleLatitude);
	
	return abs( EARTH_R * nn::math::AcosRad( nn::math::SinDeg( myAngleLatitude ) * nn::math::SinDeg( angleLatitude ) + nn::math::CosDeg( myAngleLatitude ) * nn::math::CosDeg( angleLatitude ) * nn::math::CosDeg( angleLongtitude - myAngleLongtitude ) ) );
}

//--------------------------------------------------------------------------------------------
/**
* @brief   ij}C[WZo
*
* @param   distance ij
*
* @return  }C[W
*/
//--------------------------------------------------------------------------------------------
/*static*/ u32 GeoUtility::GetMileage( u32 distance )
{
	u32 mileage = distance / DISTANS_DIVISION_NUM;
	if( mileage == 0 )
	{//؂̂āBvZPɂȂꍇ͂PƂ
		mileage = 1;
	}
	else if ( mileage > MILEAGE_MAX )
	{//sȒl
		mileage = 1;
	}
	
	return mileage;
}

//--------------------------------------------------------------------------------------------
/**
* @brief   LongtitudepxvZ
*
* @param   longtitude ox
*
* @return  px
*/
//--------------------------------------------------------------------------------------------
/*static*/ f32 GeoUtility::_CalcAngleLongtitude( u16 longtitude )
{
	if( longtitude >= 0x0000 && longtitude <= 0x7FFF )
	{//0`179.995
		return (longtitude*1.0f) / 0x7FFF * 179.995f;
	}
	else if( longtitude >= 0x8000 && longtitude <= 0xFFFF )
	{//-180`-0.005
		return ((( 0xFFFF - longtitude ) * 1.0f) / (0xFFFF - 0x8000) * -179.995f) - 0.005f;
	}
	
	GFL_PRINT( "GeoUtility::_CalcAngleLongtitude error Invalid longtitude[0x%x]\n" , longtitude );
	
	return 0.0f;
}

//--------------------------------------------------------------------------------------------
/**
* @brief   LatitudepxvZ
*
* @param   latitude ܓx
*
* @return  px
*/
//--------------------------------------------------------------------------------------------
/*static*/ f32 GeoUtility::_CalcAngleLatitude( u16 latitude )
{
	if( latitude >= 0x0000 && latitude <= 0x4000 )
	{//0`90
		return (latitude*1.0f) / 0x4000 * 90.0f;
	}
	else if( latitude >= 0xC000 && latitude <= 0xFFFF )
	{//-90`-0.005
		return ((( 0xFFFF - latitude ) * 1.0f) / (0xFFFF - 0xC000) * -89.995f) - 0.005f;
	}
	
	GFL_PRINT( "GeoUtility::_CalcAngleLatitude error Invalid latitude[0x%x]\n" , latitude );
	
	return 0.0f;
}

GFL_NAMESPACE_END(util)
GFL_NAMESPACE_END(netapp)

