//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   IntroPokemon.cpp
 *  @brief  Cg̃|PǗ
 *  @author Junya Ikuta
 *  @date   2012.08.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "BaseModel.h"
#include "IntroPokemon.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 


namespace app {
namespace intro {

const s32 INTRO_POKEMON_SEQUENCE_MAX(4);
const s32 INTRO_POKEMON_LOCATOR_MAX(1);
const char* const c_IntroLocatorBoneNamePokemonTable[ INTRO_POKEMON_LOCATOR_MAX ] = {
  "loc_pokemon_01"
};
const u32 c_IntroPokemonLocatorTable[ INTRO_POKEMON_SEQUENCE_MAX ] = {
  0,
  0,
  0,
  0
};
const b32 c_IntroPokemonVisibleTable[ INTRO_POKEMON_SEQUENCE_MAX ] = {
  false,
  true,
  false,
  false
};

const f32 INTRO_POKEMON_START_Y( 100.0f );
const f32 INTRO_POKEMON_FALL_SPEED( 5.0f );


//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// wi
//=====================================
IntroPokemon::IntroPokemon(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,   
  poke_tool::PokeModel*     pPokeModel
) :
    m_heap_memory( heap_memory ),
    m_device_memory( device_memory ),
    m_heap_allocator( heap_allocator ),
    m_device_allocator( device_allocator ),
    m_pPokeModel( pPokeModel ),
    m_State( STATE_HIDE ),
    m_Seq( -1 ),                // ݂̃V[PXԍ
    m_SeqMax( 0 ),              // V[PXԍ
    m_pPositonTable( NULL ),    // \W
    m_pRotateTable( NULL ),
    m_PosY( INTRO_POKEMON_START_Y )
{

}

IntroPokemon::~IntroPokemon(void)
{
  GFL_SAFE_DELETE_ARRAY( m_pPositonTable );
  GFL_SAFE_DELETE_ARRAY( m_pRotateTable );
}

void IntroPokemon::Update( void )
{
  switch( m_State )
  {
    case STATE_UPDATE_SHOW:
    {
      if( m_pPokeModel->IsFinishAnime() )
      {
        m_pPokeModel->ChangeAnime(  poke_tool::MODEL_ANIME_LAND_B );
        m_pPokeModel->SetIsLoop( true ); 
        m_State = STATE_UPDATE_FALL;
      }
      gfl::math::VEC3 pos (m_pPokeModel->GetPosition());
      pos.y = m_PosY;
      m_pPokeModel->SetPosition( &pos );
      break;
    }

    case STATE_UPDATE_FALL:
    {
      m_PosY -= INTRO_POKEMON_FALL_SPEED;
      if( m_PosY <= 0.0f )
      {
        m_PosY = 0.0f;
        m_pPokeModel->ChangeAnime( poke_tool::MODEL_ANIME_LAND_C );
        m_pPokeModel->SetIsLoop( false ); 
        m_State = STATE_LANDING;
      }

      gfl::math::VEC3 pos (m_pPokeModel->GetPosition());
      pos.y = m_PosY;
      m_pPokeModel->SetPosition( &pos );

      break;
    }

    case STATE_LANDING:
    {
      gfl::math::VEC3 pos (m_pPokeModel->GetPosition());
      pos.y = m_PosY;
      m_pPokeModel->SetPosition( &pos );

      break;
    }
  }
}

void IntroPokemon::CreateLocatorTable( gfl::grp::g3d::Model* pLocator )
{
  GFL_ASSERT( m_pPositonTable == NULL );
  GFL_ASSERT( m_pRotateTable == NULL );

  m_pPositonTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_POKEMON_LOCATOR_MAX ];
  m_pRotateTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_POKEMON_LOCATOR_MAX ];

  s32 boneIndex;
  gfl::math::MTX34* pBoneMtx;
  for( u32 i = 0; i < INTRO_POKEMON_LOCATOR_MAX; i++)
  {
    // {[ʒu擾
    boneIndex = pLocator->GetBonesIndex( c_IntroLocatorBoneNamePokemonTable[i] );
    pBoneMtx = pLocator->GetBoneMatrixPointerOfWorldMatrixPose( boneIndex );
    m_pPositonTable[i].x = pBoneMtx->m[ 0 ][ 3 ];
    m_pPositonTable[i].y = pBoneMtx->m[ 1 ][ 3 ];
    m_pPositonTable[i].z = pBoneMtx->m[ 2 ][ 3 ];
  }

  m_pRotateTable[0].x = 0.0f;
  m_pRotateTable[0].y = GFL_MATH_DEG_TO_RAD( 42.6959534f );
  m_pRotateTable[0].z = 0.0f; 

  m_pPokeModel->SetPosition( &m_pPositonTable[ 0 ]  );
}

void IntroPokemon::ChangeSequence( s32 seq )
{
  GFL_ASSERT( seq < INTRO_POKEMON_SEQUENCE_MAX );
  GFL_ASSERT( m_pPositonTable );
  GFL_ASSERT( m_pRotateTable );

//  gfl::math::VEC3 test( 60.0f, 60.0f, 0.0f);
 // m_pPokeModel->SetPosition( &test );

  if( seq == m_Seq )
    return;
  
  m_Seq = seq;

  if( m_Seq == 1 )
  {
    m_State = STATE_UPDATE_SHOW;
    m_pPokeModel->ChangeAnime(  poke_tool::MODEL_ANIME_LAND_A );
    m_pPokeModel->SetIsLoop( false ); 
  }

  // \A\
  m_pPokeModel->SetVisible( c_IntroPokemonVisibleTable[ m_Seq ] );
  GFL_PRINT("POKEMON SEQ : %d\n", m_Seq);
  m_pPokeModel->SetRotate( &m_pRotateTable[ c_IntroPokemonLocatorTable[ m_Seq ] ] ); 
//  m_pPokeModel->SetVisible( true );
#if 0
  // fɈʒuZbg
  m_Seq = seq;
  
  gfl::math::VEC3 pos( m_pPositonTable[ c_IntroPokemonLocatorTable[ m_Seq ] ] );
  pos.y = m_PosY;
  m_pPokeModel->SetPosition( &pos );
#endif



}

} // namespace intro
} // namespace app

