//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   IntroMirror.cpp
 *  @brief  Cg̔mǗ
 *  @author Junya Ikuta
 *  @date   2012.08.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "BaseModel.h"
#include "IntroMirror.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 


namespace app {
namespace intro {

const s32 INTRO_MIRROR_SEQUENCE_MAX(3);
const s32 INTRO_MIRROR_LOCATOR_MAX(1);
const char* const c_IntroLocatorBoneNameMirrorTable[ INTRO_MIRROR_LOCATOR_MAX ] = {
  "loc_mirrors"
};
const u32 c_IntroMirrorLocatorTable[ INTRO_MIRROR_SEQUENCE_MAX ] = {
  0,
  0,
  0
};
const b32 c_IntroMirrorVisibleTable[ INTRO_MIRROR_SEQUENCE_MAX ] = { 
  false,
  true,
  false
};
// OBJ̃V[PXԍMIRROR̃V[PXԍɕϊ
const s32 c_IntroMirrorSeqObjToMirrorTable[ INTRO_OBJ_SEQUENCE_MAX ] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  2,
  2,
  2
};

gfl::math::MTX34 g_BoneMtx;
//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// wi
//=====================================
IntroMirror::IntroMirror(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,
  gfl::fs::FileReadManager* file_read_manager,
  gfl::grp::g3d::Scene*     scene,
  s32                       calc_group,
  s32                       draw_group,
  const ArcInfo&            arc_info
)
  : BaseModel(
      heap_memory,
      device_memory,
      heap_allocator,
      device_allocator,
      file_read_manager,
      scene,
      calc_group,
      draw_group,
      arc_info
    ),
    m_Seq( INTRO_MIRROR_SEQUENCE_MAX ),               // ݂̃V[PXԍ
    m_SeqMax( 0 ),            // V[PXԍ
    m_pPositonTable( NULL ),  // \W
    m_IsMale( true )
{
}

IntroMirror::~IntroMirror(void)
{
  GFL_SAFE_DELETE_ARRAY( m_pPositonTable );
}

void IntroMirror::CreateLocatorTable( gfl::grp::g3d::Model* pLocator )
{
  GFL_ASSERT( m_pPositonTable == NULL );

  m_pPositonTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_MIRROR_LOCATOR_MAX ];
  s32 boneIndex;
  static gfl::math::MTX34* pBoneMtx;
  for( u32 i = 0; i < INTRO_MIRROR_LOCATOR_MAX; i++)
  {
    // {[ʒu擾
    boneIndex = pLocator->GetBonesIndex( c_IntroLocatorBoneNameMirrorTable[i] );
    GFL_PRINT("boneid %d\n", boneIndex);
    pBoneMtx = pLocator->GetBoneMatrixPointerOfWorldMatrixPose( boneIndex );
    GFL_PRINT("mtx ptr %d\n", pBoneMtx); 
    m_Mtx = *pBoneMtx;
    m_pPositonTable[i].x = pBoneMtx->m[ 0 ][ 3 ];
    m_pPositonTable[i].y = pBoneMtx->m[ 1 ][ 3 ];
    m_pPositonTable[i].z = pBoneMtx->m[ 2 ][ 3 ];
  }
}

void IntroMirror::ChangeSequence( s32 seq )
{
  GFL_ASSERT( seq > 0 );
  seq--;
  GFL_ASSERT( seq < INTRO_OBJ_SEQUENCE_MAX );
  GFL_ASSERT( m_pPositonTable );
  seq = c_IntroMirrorSeqObjToMirrorTable[ seq ];

  if( seq == m_Seq )
    return;
  
  // fɈʒuZbg
  m_Seq = seq;
  gfl::grp::g3d::Model* pModel = GetModel();
  pModel->SetTranslate( m_pPositonTable[ c_IntroMirrorLocatorTable[ m_Seq ] ] );

  // \E\̐؂ւ
  s32 numMesh = pModel->GetMeshCount();
  for( s32 i = 0; i < numMesh; i++)
    pModel->SetMeshVisible( i, c_IntroMirrorVisibleTable[ m_Seq ] );
}

void IntroMirror::Message( MESSAGE msg )
{
  switch( msg )
  {
    case MESSAGE_SET_HERO:
    {
      // Aj[VύX
      GetConnector()->ChangeAnimNo( 1 );
      m_IsMale = true;
      break;
    }

    case MESSAGE_SET_HEROINE:
    {
      // Aj[VύX
      GetConnector()->ChangeAnimNo( 3 );
      m_IsMale = false;
      break;
    }
    
    case MESSAGE_ENTER:
    {
      if( m_IsMale )
        GetConnector()->ChangeAnimNo( 2 );
      else
        GetConnector()->ChangeAnimNo( 4 );

      break;
    }
  }
}

} // namespace intro
} // namespace app

