//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   IntroHeroine.cpp
 *  @brief  Cg̒j̎qǗ
 *  @author Junya Ikuta
 *  @date   2012.08.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "IntroHeroine.h"
#include "BaseModel.h"

// arc


namespace app {
namespace intro {

const s32 INTRO_HEROINE_SEQUENCE_MAX(2);
const s32 INTRO_HEROINE_LOCATOR_MAX(1);
const char* const c_IntroLocatorBoneNameHeroineTable[ INTRO_HEROINE_LOCATOR_MAX ] = {
  "loc_girl_01"
};
const u32 c_IntroHeroineLocatorTable[ INTRO_HEROINE_SEQUENCE_MAX ] = {
  0,
  0
};
const b32 c_IntroHeroineVisibleTable[ INTRO_HEROINE_SEQUENCE_MAX ] = {
  true,
  false
};
// OBJ̃V[PXԍBG̃V[PXԍɕϊ
const s32 c_IntroHeroineSeqObjToHeroineTable[ INTRO_OBJ_SEQUENCE_MAX ] = {
  1,
  1,
  1,
  1,
  1,
  1,
  1,
  0,
  0,
  0,
  1,
  1,
  1,
};

//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// wi
//=====================================
IntroHeroine::IntroHeroine(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,
  trainer::TrModel*         pTrModel
) :
    m_heap_memory( heap_memory ),
    m_device_memory( device_memory ),
    m_heap_allocator( heap_allocator ),
    m_device_allocator( device_allocator ),
    m_pTrModel( pTrModel ),
    m_Seq( -1 ),                // ݂̃V[PXԍ
    m_SeqMax( 0 ),              // V[PXԍ
    m_pPositonTable( NULL ),    // \W
    m_pRotateTable( NULL )
{

}

IntroHeroine::~IntroHeroine(void)
{
  GFL_SAFE_DELETE_ARRAY( m_pPositonTable );
  GFL_SAFE_DELETE_ARRAY( m_pRotateTable );
}

void IntroHeroine::CreateLocatorTable( gfl::grp::g3d::Model* pLocator )
{
  GFL_ASSERT( m_pPositonTable == NULL );
  GFL_ASSERT( m_pRotateTable == NULL );

  m_pPositonTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_HEROINE_LOCATOR_MAX ];
  m_pRotateTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_HEROINE_LOCATOR_MAX ];

  s32 boneIndex;
  gfl::math::MTX34* pBoneMtx;
  for( u32 i = 0; i < INTRO_HEROINE_LOCATOR_MAX; i++)
  {
    // {[ʒu擾
    boneIndex = pLocator->GetBonesIndex( c_IntroLocatorBoneNameHeroineTable[i] );
    pBoneMtx = pLocator->GetBoneMatrixPointerOfWorldMatrixPose( boneIndex );
    m_pPositonTable[i].x = pBoneMtx->m[ 0 ][ 3 ];
    m_pPositonTable[i].y = pBoneMtx->m[ 1 ][ 3 ];
    m_pPositonTable[i].z = pBoneMtx->m[ 2 ][ 3 ];
  }

  m_pRotateTable[0].x = 0.0f;
  m_pRotateTable[0].y = GFL_MATH_DEG_TO_RAD( -34.9999847f );
  m_pRotateTable[0].z = 0.0f;

}

void IntroHeroine::ChangeSequence( s32 seq )
{
  GFL_ASSERT( seq > 0 );
  seq--;
  GFL_ASSERT( seq < INTRO_OBJ_SEQUENCE_MAX );
  GFL_ASSERT( m_pPositonTable );
  GFL_ASSERT( m_pRotateTable );
  seq = c_IntroHeroineSeqObjToHeroineTable[ seq ];

  if( seq == m_Seq )
    return;
  
  // fɈʒuZbg
  m_Seq = seq;
  m_pTrModel->SetTranslate( m_pPositonTable[ c_IntroHeroineLocatorTable[ m_Seq ] ] );
  m_pTrModel->SetRotateXYZ( m_pRotateTable[ c_IntroHeroineLocatorTable[ m_Seq ] ] );
  m_pTrModel->SetVisible( c_IntroHeroineVisibleTable[m_Seq] );

}

} // namespace intro
} // namespace app

