//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   IntroHakase.cpp
 *  @brief  Cg̔mǗ
 *  @author Junya Ikuta
 *  @date   2012.08.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "BaseModel.h"
#include "IntroHakase.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 


namespace app {
namespace intro {

const s32 INTRO_HAKASE_SEQUENCE_MAX(8);
const s32 INTRO_HAKASE_LOCATOR_MAX(4);
const char* const c_IntroLocatorBoneNameHakaseTable[ INTRO_HAKASE_LOCATOR_MAX ] = {
  "loc_hakase_01",
  "loc_hakase_02",
  "loc_hakase_03",
  "loc_hakase_04"
};
const u32 c_IntroHakaseLocatorTable[ INTRO_HAKASE_SEQUENCE_MAX ] = {
  0,
  0,
  0,
  0,
  1,
  2,
  3,
  3
};
const u32 c_IntroHakaseAnimationTable[ INTRO_HAKASE_SEQUENCE_MAX ] = {
  TRMOT_OTHER_BA90_OPENING01,
  TRMOT_OTHER_BA90_OPENING02,
  TRMOT_OTHER_BA90_OPENING03,
  TRMOT_OTHER_BA90_OPENINGA04,
  TRMOT_OTHER_BA90_OPENINGA04,
  TRMOT_OTHER_BA90_OPENINGA04,
  TRMOT_OTHER_BA90_OPENINGC04,
  TRMOT_OTHER_BA90_OPENING05
};
const b32 c_IntroHakaseAnimationLoopTable[ INTRO_HAKASE_SEQUENCE_MAX ] = {
  true,
  true,
  false,
  false,
  false,
  false,
  false,
  false
};

//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// wi
//=====================================
IntroHakase::IntroHakase(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,
  trainer::TrModel*         pTrModel
) :
    m_heap_memory( heap_memory ),
    m_device_memory( device_memory ),
    m_heap_allocator( heap_allocator ),
    m_device_allocator( device_allocator ),
    m_pTrModel( pTrModel ),
    m_Seq( -1 ),                // ݂̃V[PXԍ
    m_SeqMax( 0 ),              // V[PXԍ
    m_pPositonTable( NULL ),    // \W
    m_pRotateTable( NULL )
{
}

IntroHakase::~IntroHakase(void)
{
  GFL_SAFE_DELETE_ARRAY( m_pPositonTable );
  GFL_SAFE_DELETE_ARRAY( m_pRotateTable );
}

void IntroHakase::Update(void)
{
  // Mb[v
  if( m_pTrModel->IsEndMotion() && m_pTrModel->GetMotionNumber() == TRMOT_OTHER_BA90_OPENINGA04 )
  {
    m_pTrModel->ChangeMotion( TRMOT_OTHER_BA90_OPENINGB04 );
    m_pTrModel->SetMotionLoop( true );
  }

  // MbIҋ@[v
  if( m_pTrModel->IsEndMotion() && m_pTrModel->GetMotionNumber() == TRMOT_OTHER_BA90_OPENINGC04 )
  {
    m_pTrModel->ChangeMotion( TRMOT_OTHER_BA90_OPENING01 );
    m_pTrModel->SetMotionLoop( true );
  }
}



void IntroHakase::CreateLocatorTable( gfl::grp::g3d::Model* pLocator )
{
  GFL_ASSERT( m_pPositonTable == NULL );
  GFL_ASSERT( m_pRotateTable == NULL );

  m_pPositonTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_HAKASE_LOCATOR_MAX ];
  m_pRotateTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_HAKASE_LOCATOR_MAX ];

  s32 boneIndex;
  gfl::math::MTX34* pBoneMtx;
  for( u32 i = 0; i < INTRO_HAKASE_LOCATOR_MAX; i++)
  {
    // {[ʒu擾
    boneIndex = pLocator->GetBonesIndex( c_IntroLocatorBoneNameHakaseTable[i] );
    pBoneMtx = pLocator->GetBoneMatrixPointerOfWorldMatrixPose( boneIndex );
    m_pPositonTable[i].x = pBoneMtx->m[ 0 ][ 3 ];
    m_pPositonTable[i].y = pBoneMtx->m[ 1 ][ 3 ];
    m_pPositonTable[i].z = pBoneMtx->m[ 2 ][ 3 ];
  }

  m_pRotateTable[0].x = 0.0f;
  m_pRotateTable[0].y = 0.0f;
  m_pRotateTable[0].z = 0.0f;

  m_pRotateTable[1].x = 0.0f;
  m_pRotateTable[1].y = GFL_MATH_DEG_TO_RAD( 59.7153778f );
  m_pRotateTable[1].z = 0.0f;

  m_pRotateTable[2].x = 0.0f;
  m_pRotateTable[2].y = 0.0f;
  m_pRotateTable[2].z = 0.0f;

  m_pRotateTable[3].x = 0.0f;
  m_pRotateTable[3].y = 0.0f;
  m_pRotateTable[3].z = 0.0f;
 
}

void IntroHakase::ChangeSequence( s32 seq )
{
  GFL_ASSERT( seq > 0 );
  seq--;
  GFL_ASSERT( seq < INTRO_HAKASE_SEQUENCE_MAX );
  GFL_ASSERT( m_pPositonTable );
  GFL_ASSERT( m_pRotateTable );

  if( seq == m_Seq )
    return;
  
  // fɈʒuZbg
  m_Seq = seq;

  m_pTrModel->SetTranslate( m_pPositonTable[ c_IntroHakaseLocatorTable[ m_Seq ] ] );
  m_pTrModel->SetRotateXYZ( m_pRotateTable[ c_IntroHakaseLocatorTable[ m_Seq ] ] );

  // Aj[VύX
  m_pTrModel->ChangeMotion( c_IntroHakaseAnimationTable[m_Seq] );
 // m_pTrModel->ChangeMotion( TRMOT_OTHER_BA90_OPENING02 );

  m_pTrModel->SetMotionLoop( c_IntroHakaseAnimationLoopTable[m_Seq] );
  GFL_PRINT("hakase seq : %d\n", m_Seq );

}

proj::motion::Motion* IntroHakase::GetMotion( void )
{
  return static_cast< proj::motion::Motion* >( m_pTrModel->GetMotion() );
}



} // namespace intro
} // namespace app

