//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *  GAME FREAK inc.
 *
 *  @file   IntroEffect.cpp
 *  @brief  Cg
 *  @author Koji Kawada
 *  @date   2012.08.12
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


// gflib
#include <gflib.h>

// kujira
#include "gamesystem/GameProc.h"
#include "print/system_font.h"
#include "dll/DllProc.h"
#include "print/WordSet.h"
#include "app/tool/app_tool_YesNoMenu.h"
#include "app/strinput/strinput.h"
#include "app/util/app_util_heap.h"
#include "app/util/app_util_Common.h"

// intro
#include "BaseModel.h"
#include "IntroEffect.h"

// arc
#include "arc/arc_def.h"            // ARCID_ 


namespace app {
namespace intro {

const s32 INTRO_EFFECT_SEQUENCE_MAX(4);
const s32 INTRO_EFFECT_LOCATOR_MAX(1);
const char* const c_IntroLocatorBoneNameEffectTable[ INTRO_EFFECT_LOCATOR_MAX ] = {
  "loc_centre"
};
const u32 c_IntroEffectLocatorTable[ INTRO_EFFECT_SEQUENCE_MAX ] = {
  0,
  0,
  0,
  0
};

const b32 c_IntroEffectVisibleTable[ INTRO_EFFECT_SEQUENCE_MAX ] = {
  true,
  false,
  true,
  false
};

const b32 c_IntroEffectAnimationTable[ INTRO_EFFECT_SEQUENCE_MAX ] = {
  0,
  0, // _~[
  1, 
  1  // _~[
};


// OBJ̃V[PXԍBG̃V[PXԍɕϊ
const s32 c_IntroEffectSeqObjToEffectTable[ INTRO_OBJ_SEQUENCE_MAX ] = {
  0,
  1,
  1,
  1,
  2,
  3,
  3,
  3,
  3,
  3,
  3,
  3,
  3
};




//-----------------------------------------------------------------------------
/**
 *          NX
 */
//-----------------------------------------------------------------------------

//-------------------------------------
/// wi
//=====================================
IntroEffect::IntroEffect(
  gfl::heap::HeapBase*      heap_memory,
  gfl::heap::HeapBase*      device_memory,
  gfl::heap::NwAllocator*   heap_allocator,
  gfl::heap::NwAllocator*   device_allocator,
  gfl::fs::FileReadManager* file_read_manager,
  gfl::grp::g3d::Scene*     scene,
  s32                       calc_group,
  s32                       draw_group,
  const ArcInfo&            arc_info
)
  : BaseModel(
      heap_memory,
      device_memory,
      heap_allocator,
      device_allocator,
      file_read_manager,
      scene,
      calc_group,
      draw_group,
      arc_info
    ),
    m_Seq( -1 ),              // ݂̃V[PXԍ
    m_SeqMax( 0 ),            // V[PXԍ
    m_pPositonTable( NULL ),  // \W
    m_pRotateTable( NULL )
{
  // RXgN^qŏłȂ
  {


  }
}

IntroEffect::~IntroEffect(void)
{
  GFL_SAFE_DELETE_ARRAY( m_pPositonTable ); 
  GFL_SAFE_DELETE_ARRAY( m_pRotateTable ); 
}

void IntroEffect::CreateLocatorTable( gfl::grp::g3d::Model* pLocator )
{
  GFL_ASSERT( m_pPositonTable == NULL );

  m_pPositonTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_EFFECT_LOCATOR_MAX ];
  m_pRotateTable = GFL_NEW_ARRAY( m_heap_memory ) gfl::math::VEC3[ INTRO_EFFECT_LOCATOR_MAX ];

  s32 boneIndex;
  gfl::math::MTX34* pBoneMtx;
  for( u32 i = 0; i < INTRO_EFFECT_LOCATOR_MAX; i++)
  {
    // {[ʒu擾
    boneIndex = pLocator->GetBonesIndex( c_IntroLocatorBoneNameEffectTable[i] );
    pBoneMtx = pLocator->GetBoneMatrixPointerOfWorldMatrixPose( boneIndex );
    m_pPositonTable[i].x = pBoneMtx->m[ 0 ][ 3 ];
    m_pPositonTable[i].y = pBoneMtx->m[ 1 ][ 3 ];
    m_pPositonTable[i].z = pBoneMtx->m[ 2 ][ 3 ];
  }

  m_pRotateTable[0].x = 0.0f;
  m_pRotateTable[0].y = 0.0f;
  m_pRotateTable[0].z = 0.0f;

  // @
  gfl::grp::g3d::Model* pModel = GetModel();
  s32 numMesh = pModel->GetMeshCount();
  for( s32 i = 0; i < numMesh; i++)
    pModel->SetMeshVisible( i, false );

}

void IntroEffect::ChangeSequence( s32 seq )
{
  GFL_ASSERT( seq > 0 );
  seq--;
  GFL_ASSERT( seq < INTRO_OBJ_SEQUENCE_MAX );
  GFL_ASSERT( m_pPositonTable );
  seq = c_IntroEffectSeqObjToEffectTable[ seq ];

  if( seq == m_Seq )
    return;
  
  // fɈʒuZbg
  m_Seq = seq;
  gfl::grp::g3d::Model* pModel = GetModel();
  pModel->SetTranslate( m_pPositonTable[ c_IntroEffectLocatorTable[ m_Seq ] ] );
  pModel->SetRotateXYZ( m_pRotateTable[ c_IntroEffectLocatorTable[ m_Seq ] ] );
  
  // \E\̐؂ւ
  s32 numMesh = pModel->GetMeshCount();
  for( s32 i = 0; i < numMesh; i++)
    pModel->SetMeshVisible( i, c_IntroEffectVisibleTable[ m_Seq ] );

  // Aj[V̐؂ւ
  GetConnector()->ChangeAnimNo( c_IntroEffectAnimationTable[ m_Seq ] );

}
void IntroEffect::Message( MESSAGE msg )
{
  switch( msg )
  {
    case MESSAGE_STOP:
    {
      GetConnector()->SetStepFrame( 0.0f );
      break;
    }
  
    case MESSAGE_RESUME:
    {
      GetConnector()->SetStepFrame( 1.0f );
      break;
    }
  }

}

} // namespace intro
} // namespace app

