//==============================================================================
/**
 * @file	pss_subproc_assist_power_use.cpp
 * @brief orrTuvZXuAVXgp[gpvNX
 * @author	ichiraku_katsuhiko
 * @data	2012/08/27, 17:56
 */
// =============================================================================

#include "pss_subproc_assist_power_use.h"
#include "app/pss/pss_message_window/pss_message_window.h"
#include <app/pss/pss_invite_window/pss_invite_window.h>

GFL_NAMESPACE_BEGIN(field)
GFL_NAMESPACE_BEGIN(subscreen)
GFL_NAMESPACE_BEGIN(pss)
GFL_NAMESPACE_BEGIN(subproc )


// RXgN^
PssSubProcAssistPowerUse::PssSubProcAssistPowerUse( void )
{

}

// fXgN^
PssSubProcAssistPowerUse::~PssSubProcAssistPowerUse( void )
{
}

//--------------------------------------------------------------------------
/**
	* @brief		
	*
	* @param   gameProcMgr        GameProcManagerւ̃|C^
	* @param   layout             LayoutSystemւ̃|C^
	* @param   beaconResponder    PssBeaconResponderւ̃|C^
	* @param   iconMgr            PlayerIconManagerւ̃|C^
	* @param		apowerId						gpAp[ID
	* @param   friendKey						l̏ꍇ͑M҂̃thL[ 
	* @param   msgData            bZ[Wf[^
	* @param   wordset            [hZbg
	* @param   paramWork          Procp[^p̈
	*
	* @return	PssSubProcBaseւ̃|C^
	*/
//--------------------------------------------------------------------------
PssSubProcBase* PssSubProcAssistPowerUse::Init( gamesystem::GameProcManager *gameProcMgr,
												gfl::grp::g2d::LytSys *layout,
												netapp::pss::PssBeaconResponder* beaconResponder,
												xy_system::player_icon::PlayerIconManager* iconMgr,
                        netapp::assist_power::APOWER_ID apowerId,
												gflnet::friends::FriendKey friendKey,
												gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
	InitBase( gameProcMgr, layout, beaconResponder, paramWork );


  app::pss::pss_message_window::APP_PARAM *param = static_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = m_layout;
  param->m_messageData   = msgData;
  param->m_wordset       = wordset;
	param->m_targetPlayer	 = friendKey;
  param->m_type          = app::pss::pss_message_window::E_TYPE_ASSIST_POWER_USE;
  param->m_messageText   = msg_pss_02_53;  // uXX񂩂 XXĂIv
  param->m_playerIconMgr = iconMgr;
  param->m_isDispLoading = false;
  param->m_inputLock     = false;
	param->m_apowerId			 = apowerId;
	param->m_apowerMgr		 = m_gameMgr->GetAssistPowerManager();

  m_subProc = dll::CreatePssMessageWindow( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );

	// JnԂL^
	gfl::std::DateTime::GetNow( &m_connectStartingTime );

	ICHI_PRINT("AVXgp[gpʏ\n");

  return this;
}

//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcAssistPowerUse::Update( void )
{
	switch( m_seq ){
	case 0:
		// bZ[W^b`邩 3boƎ
		if( !UpdateSubProc() || IsTimeout( 3000 ) )
		{
			m_seq++;
		}
		break;

//******************************************************
// ȈՓIȃGtFNgƂătF[hꂽ
//******************************************************
	case 1:
		gfl::grp::Fade_RequestOut( gfl::grp::Fade::DISP_APPER, gfl::grp::Fade::OUTTYPE_WHITE,10, true );
		m_seq++;
		break;
	case 2:
		if( gfl::grp::Fade_IsEnd() == true )
		{
			gfl::grp::Fade_RequestIn( gfl::grp::Fade::DISP_APPER, 5 );

			m_seq++;
		}
		break;
//******************************************************
//******************************************************
	case 3:
		if( gfl::grp::Fade_IsEnd() == true )
		{
			// ŃAVXgp[𔭓
			UseApower();

			gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
			return RET_ASSIST_POWER_USE_RETURN;
		}
	}

  return RET_NONE;
}

//--------------------------------------------------------------------------
/**
 * @breif		AVXgp[𔭓
 */
//--------------------------------------------------------------------------
void PssSubProcAssistPowerUse::UseApower( void )
{
	netapp::assist_power::AssistPowerManager* apowerManager = m_gameMgr->GetAssistPowerManager();
  netapp::pss::PssPersonalData* me = m_gameMgr->GetPssPersonalDataManager()->GetMyData();

	// gpAp[ID
	netapp::assist_power::APOWER_ID apowerId;
	apowerId = apowerManager->GetBeaconParamApowerID();

	// p[\if[^XV
	me->SetPacketGameStatusWithAssistPower( static_cast<u8>(apowerId) );
	me->SetRequestUpadateGameStatus();
	
	// r[Rf[^M
	m_beaconResponder->SendMyData();

	// Ap[
	apowerManager->SetOccurID( apowerId, true );
}

GFL_NAMESPACE_END(subproc)
GFL_NAMESPACE_END(pss)
GFL_NAMESPACE_END(subscreen)
GFL_NAMESPACE_END(field)

