
//============================================================================================
/**
 * @brief orrTuvZXug[h\ݑJځiԊO)vNX
 */
//============================================================================================
#include "pss_subproc_trade_request_ir.h"
#include <app/pss/pss_invite_window/pss_invite_window.h>
#include <netapp/pss/PssPacketUtil.h>


namespace field {
namespace subscreen {
namespace pss {
namespace subproc {


//--------------------------------------------------------------------------------------------
/**
* @brief   RXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::PssSubProcTradeRequestWithIR( void ) : PssSubProcBase()
{
}


//--------------------------------------------------------------------------------------------
/**
* @brief   fXgN^
*
* @param   none
*
* @return  none
*/
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::~PssSubProcTradeRequestWithIR( void )
{
}

//--------------------------------------------------------------------------------------------
/**
* @brief   
*
* @param   gameProcMgr        GameProcManagerւ̃|C^
* @param   layout             LayoutSystemւ̃|C^
* @param   beaconResponder    PssBeaconResponderւ̃|C^
* @param   iconMgr            PlayerIconManagerւ̃|C^
* @param   topList            PSSgbvXgvZXւ̃|C^
* @param   topListUIListener  PSSgbvXgpftHgUIXi
* @param   msgData            bZ[Wf[^
* @param   wordset            [hZbg
* @param   invitedUser        PSSŒڑIꂽ[U[̃thL[
* @param   paramWork          Procp[^p̈
*
* @return  PssSubProcBaseւ̃|C^
*/
//--------------------------------------------------------------------------------------------
PssSubProcBase* PssSubProcTradeRequestWithIR::Init( gamesystem::GameProcManager *gameProcMgr,
                      gfl::grp::g2d::LytSys *layout,
                      netapp::pss::PssBeaconResponder* beaconResponder,
                      xy_system::player_icon::PlayerIconManager* iconMgr,
                      app::pss::pss_top_list::Proc* topList,
                      app::pss::pss_top_list::PssTopListUIListener* topListUIListener,
                      const gflnet::friends::FriendKey& invitedUser,
                      gfl::str::MsgData* msgData, WordSet* wordset, void* paramWork )
{
  InitBase( gameProcMgr, layout, beaconResponder, paramWork );
  InitPssMatchingLib( m_gameMgr->GetGameData()->GetPssTradeMachingInfo() );

  m_invitedUser       = invitedUser;
  m_topListProc       = topList;
  m_playerIconMgr     = iconMgr;
  m_msgData           = msgData;
  m_wordset           = wordset;
  m_topListUIListener = topListUIListener;
  m_pssPersonalMgr    = m_gameMgr->GetPssPersonalDataManager();

  if( InitPlayerSelect() ){
    m_seq = MAINSEQ_PLAYER_SELECT;
  }
  else
  {
    InitCheckUser();
    m_seq = MAINSEQ_CHECK_USER;
  }

  return this;
}


//--------------------------------------------------------------------------------------------
/**
* @brief   XV
*
* @param   none
*
* @return  ANZXR[h
*/
//--------------------------------------------------------------------------------------------
field::subscreen::pss::E_PSS_PROC_RESULT PssSubProcTradeRequestWithIR::Update( void )
{
  switch( m_seq )
  {
    case MAINSEQ_PLAYER_SELECT:
      m_seq = PlayerSelect();
      break;
    case MAINSEQ_CHECK_USER:
      m_seq = CheckUser();
      break;
    case MAINSEQ_SAVE:
      m_seq = Save();
      break;
    case MAINSEQ_NETWORK_CALLING:
      m_seq = NetworkCalling();
      break;
    case MAINSEQ_REQUEST_CANCEL:
      m_seq = RequestCancel();
      break;
    case MAINSEQ_REQUEST_FAILED:
      m_seq = RequestFailed();
      break;
  }

  if( m_seq == MAINSEQ_GOTO_TRADE )
  {
    StartTradeRequest();
    return RET_TRADE_GOTO_TRADE;
  }
  else if( m_seq == MAINSEQ_STOP )
  {
    CancelTradeRequest();
    return RET_TRADE_STOP;
  }
  else if( m_seq == MAINSEQ_CANCEL )
  {
    CancelTradeRequest();
    return RET_TRADE_CANCEL;
  }

  return RET_NONE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief   vC[Iʏ
 *
 * @param   none
 *
 * @return  vC[IXLbvȂfalsew
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcTradeRequestWithIR::InitPlayerSelect(void)
{
  app::pss::pss_player_select::APP_PARAM *param = static_cast<app::pss::pss_player_select::APP_PARAM*>(m_paramWork);
  param->m_layout      = m_layout;
  param->m_messageData = m_msgData;
  param->m_wordset     = m_wordset;
  param->m_inviteNum   = 1;
  param->m_listMenu    = m_topListProc;

  // m胆[U[o^ς݁H
  if( netapp::pss::PssPacketUtil::IsValidFriendKey(m_invitedUser) )
  {
    // VOg[hł́Aΐ҂ƂĊmI
    m_guestUser    = m_invitedUser;
    m_guestUserNum = 1;
    return false;
  }
  else{
    param->m_commitNum = 0;
  }

  app::pss::pss_player_select::Proc* subProc = dll::CreatePssPlayerSelectProc( m_gameProcMgr, param );
  m_subProc = subProc;
  m_subProc->InitFunc( m_gameProcMgr );

  // PssTopListUIListener̒ʒmύX
  m_topListProc->SetPssTopListUIListener( subProc->GetPssTopListUIListener() );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		vC[I
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::PlayerSelect(void)
{
  if( m_topListProc )
  {
    m_topListProc->UpdateFunc( m_gameProcMgr );
  }

  if( !UpdateSubProc() )
  {
    app::pss::pss_player_select::APP_PARAM *param = static_cast<app::pss::pss_player_select::APP_PARAM*>(m_paramWork);

    // LXg̃CxgXiCɖ߂
    m_topListProc->SetPssTopListUIListener( m_topListUIListener );

    if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_CANCEL )
    {
      return MAINSEQ_CANCEL;
    }
    else if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_CLOSE )
    {
      gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
      return MAINSEQ_STOP;
    }
    // ҎҊmI
    else if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_SELECTED_ALL )
    {
      m_guestUser    = param->m_selectedPlayer[0];
      m_guestUserNum = param->m_selectedPlayerNum;

      InitCheckUser();
      return MAINSEQ_CHECK_USER;
    }
    // FBEm荇ΐɏ
    else if( param->m_endMode == app::pss::pss_player_select::PSS_PLAYER_SELECT_RESULT_INVITE )
    {
      m_guestUser.initialize();
      m_guestUserNum = 0;

      return GotoSave();
    }
  }
  return MAINSEQ_PLAYER_SELECT;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  uQҊmFv
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::InitCheckUser( void )
{
  app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);
  param->m_layout          = m_layout;
  param->m_messageData     = m_msgData;
  param->m_wordset         = m_wordset;
  param->m_ruleSetting     = m_battleRuleSetting;
  param->m_playerIconMgr   = m_playerIconMgr;
  param->m_targetPlayerNum = m_guestUserNum;
  param->m_execMode        = app::pss::pss_user_notify::E_MODE_TRADE_REQUEST;
  param->m_targetPlayer[0] = m_guestUser;

  m_subProc = dll::CreatePssUserNotifyProc( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief  uQҊmFvvZX
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::CheckUser(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_user_notify::APP_PARAM *param = static_cast<app::pss::pss_user_notify::APP_PARAM*>(m_paramWork);

    // łnjI
    if( param->m_isSelectYes )
    {
      return GotoSave();
    }
    // ₾AȂI
    else
    {
      gfl::grp::Fade_Reset( gfl::grp::Fade::DISP_LOWER );
      if( InitPlayerSelect() ){
        return MAINSEQ_PLAYER_SELECT;
      }
      else
      {
        return MAINSEQ_STOP;
      }
    }
  }

  return MAINSEQ_CHECK_USER;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   Z[u֑J
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::GotoSave(void)
{
#ifdef PSS_SKIP_SAVE_MODE
  // Z[uXLbv
  if( InitNetworkCalling() ){
    return MAINSEQ_NETWORK_CALLING;
  }
  else{
    return MAINSEQ_STOP;
  }
#else
  InitSave();
  return MAINSEQ_SAVE;
#endif
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Z[uʏ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::InitSave(void)
{
  app::report::APP_PARAM *param = static_cast<app::report::APP_PARAM*>(m_paramWork);
  param->m_layout       = m_layout;
  param->m_isEnableFade = false;
  param->m_heap         = gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU );
  param->m_devHeap      = gfl::heap::Manager::GetHeapByHeapId( HEAPID_FIELDMENU_DEV );

  m_subProc = dll::CreateReportMenuProc( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief		Z[u
 *
 * @param		none
 *
 * @return	e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::Save(void)
{
  if( !UpdateSubProc() )
  {
    app::report::APP_PARAM *param = static_cast<app::report::APP_PARAM*>(m_paramWork);

    // Z[u
    if( param->m_isSaveSuccess )
    {
      if( InitNetworkCalling() ){
        return MAINSEQ_NETWORK_CALLING;
      }
      else{
        return MAINSEQ_STOP;
      }
    }
    // Z[uȂ
    else
    {
      if( InitPlayerSelect() ){
        return MAINSEQ_PLAYER_SELECT;
      }
      else
      {
        return MAINSEQ_STOP;
      }
    }
  }

  return MAINSEQ_SAVE;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   QXg[Uڑ҂ʏ
 *
 * @param   none
 *
 * @return  ɏłȂtrueԋp
 */
//--------------------------------------------------------------------------------------------
bool PssSubProcTradeRequestWithIR::InitNetworkCalling(void)
{
  app::pss::pss_message_window::APP_PARAM* param = static_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  // [U[m
  if( m_guestUserNum == 1 )
  {
    netapp::pss::PssPersonalData* targetPerson = m_pssPersonalMgr->GetPersonalData( m_guestUser );

    if( targetPerson == NULL ){
      return false;
    }
    param->m_targetPlayer  = m_guestUser;
    param->m_type          = app::pss::pss_message_window::E_TYPE_CHAR_MESSAGE;

    // PSS[U[ʕʂɃbZ[WύX
    if( targetPerson->IsRelatonFriend() ){
      param->m_messageText = msg_pss_10_01_01;  // Ƃ́Ɍ\ł܂
    }
    else if( targetPerson->IsRelatonAcquaintance() ){
      param->m_messageText = msg_pss_10_02_01;  // m荇́Ɍ\ł܂
    }
    else{
      param->m_messageText = msg_pss_10_03_01;  // ʂ肷́Ɍ\ł܂
    }
  }
  // [U[m
  else
  {
    param->m_type          = app::pss::pss_message_window::E_TYPE_OK_MESSAGE;
    param->m_messageText   = msg_pss_10_00_01;  // W
  }
  param->m_layout        = m_layout;
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = true;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProcMgr, param );

  m_subProc->InitFunc( m_gameProcMgr );

  // g̑ΐ}b`Oݒ肷
  SetMachingInfo();

  // ʐMJnԂL^
  gfl::std::DateTime::GetNow( &m_connectStartingTime );

  return true;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ}b`Oݒ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::SetMachingInfo( void )
{
  netapp::pss::PssPersonalData* myInfo = m_pssPersonalMgr->GetMyData();

  // e@ΐ҂҂悤ɃpPbgݒ
  myInfo->SetRequestInvitingTrade();
  myInfo->SetTradeRequestTargetUser( m_guestUser, m_guestUserNum, true );
  m_beaconResponder->SendMyData();

  // ΐ}b`Oݒ
  const netapp::pss::PacketTradeInvite& invite = myInfo->GetPacketTradeInvite();

  m_tradeMatchingInf->SetupHost( myInfo->GetFriendKey(), invite.ticketID, m_guestUserNum, m_guestUser,
                                 m_gameMgr->GetXyNetManager()->IsWifi() );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   QXg[Uڑ҂ʂ̍XV
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::NetworkCalling(void)
{
  bool joinStatus[MATCHING_PLAYER_MAX];   // Q󋵃tO

  s32 joinUserNum = GetTradeJoinUserNum( m_pssPersonalMgr );

  // mQ҂̕sQmI
  if( joinUserNum < 0)
  {
    ReleaseProc( &m_subProc );
    InitTradeCancelAction();
    return MAINSEQ_REQUEST_FAILED;
  }
  // Q҂H
  else if( m_tradeMatchingInf->GetNeedGuestNum() == joinUserNum )
  {
    return MAINSEQ_GOTO_TRADE;
  }

  if( !UpdateSubProc() )
  {
    // Î҂ɂLZ
    InitRequestCancel();
    return MAINSEQ_REQUEST_CANCEL;
  }

  // PԂŃ^CAEg
  if( IsTimeout(60000) )
  {
    ReleaseProc( &m_subProc );
    InitTradeCancelAction();
    return MAINSEQ_REQUEST_FAILED;
  }

  return MAINSEQ_NETWORK_CALLING;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑG[
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::RequestFailed(void)
{
  if( !UpdateSubProc() )
  {
    return MAINSEQ_STOP;
  }

  return MAINSEQ_REQUEST_FAILED;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ΐ󂯓ʁFuڑLZv
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::InitTradeCancelAction( void )
{
  app::pss::pss_message_window::APP_PARAM *param = static_cast<app::pss::pss_message_window::APP_PARAM*>(m_paramWork);

  param->m_layout        = m_layout;
  param->m_messageData   = m_msgData;
  param->m_wordset       = m_wordset;
  param->m_type          = app::pss::pss_message_window::E_TYPE_MESSAGE;
  param->m_messageText   = msg_pss_10_11_01;  // sȂ܂B𒆎~܂B
  param->m_playerIconMgr = m_playerIconMgr;
  param->m_isDispLoading = false;
  param->m_inputLock     = false;

  m_subProc = dll::CreatePssMessageWindow( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑ҂LZʏ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::InitRequestCancel(void)
{
  app::pss::pss_yesno_dialog::APP_PARAM *param = static_cast<app::pss::pss_yesno_dialog::APP_PARAM*>(m_paramWork);
  param->m_layout       = m_layout;
  param->m_messageData  = m_msgData;
  param->m_wordset      = m_wordset;
  param->m_messageId    = msg_pss_10_04_01; // 𒆎~܂H

  m_subProc = dll::CreatePssYesNoDialog( m_gameProcMgr, param );
  m_subProc->InitFunc( m_gameProcMgr );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   ڑLZ
 *
 * @param   none
 *
 * @return  e
 */
//--------------------------------------------------------------------------------------------
PssSubProcTradeRequestWithIR::E_TRADE_REQUEST_SEQUENCE PssSubProcTradeRequestWithIR::RequestCancel(void)
{
  if( !UpdateSubProc() )
  {
    app::pss::pss_yesno_dialog::APP_PARAM *param = static_cast<app::pss::pss_yesno_dialog::APP_PARAM*>(m_paramWork);

    // ~
    if( param->m_isSelectYes )
    {
      return MAINSEQ_STOP;
    }
    // ~Ȃ
    else
    {
      if( InitNetworkCalling() ){
        return MAINSEQ_NETWORK_CALLING;
      }
      else{
        return MAINSEQ_STOP;
      }
    }
  }

  return MAINSEQ_REQUEST_CANCEL;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief  u ΐJniۂɂ̓}b`OJnjvpPbg̑Mݒ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::StartTradeRequest( void )
{
  netapp::pss::PssPersonalData* me = m_pssPersonalMgr->GetMyData();

  // Q҃f[^XV
  me->SetTradeRequestTargetUser( m_tradeMatchingInf->GetGuestUser(), m_tradeMatchingInf->GetGuestNum(), false );
  me->SetRequestStartingTrade();

  // ȉP2PmɍsĂ炤
  //m_beaconResponder->SendMyData();
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   uʐMΐ풆~vpPbg̑Mݒ
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void PssSubProcTradeRequestWithIR::CancelTradeRequest( void )
{
  netapp::pss::PssPersonalData* me = m_pssPersonalMgr->GetMyData();
  me->SetRequestCancelingTrade();
  m_beaconResponder->SendMyData();
}




}		// subproc
}		// pss
}		// subscreen
}		// field

