//===================================================================
/**
 * @file    PermanentSaveData.cpp
 * @brief   ivɏȂZ[uf[^
 * @author  tamada
 * @date    2012.08.26
 *
 * @note
 * R[hwAuAn|PvȂǏQ[N
 * ܂ύXȂZ[uf[^߂̃f[^\B
 * Z[uf[^ĂȂB
 */
//===================================================================

#include <gflib.h>

#include "savedata/PermanentSaveData.h"

#include "poke_tool/RealRegionPokemon.h"  //for RealRegion::DecideRegion

GFL_NAMESPACE_BEGIN(savedata)

//===================================================================
/**
 * @struct  PermanentCoreData
 */
//===================================================================
struct PermanentCoreData
{
  u32 magic_number;
  u8 langId;        
  u8 RealRegionFormNo;
};

//-----------------------------------------------------------------------------
/**
 * @param heap
 */
//-----------------------------------------------------------------------------
PermanentSaveData::PermanentSaveData( gfl::heap::HeapBase * heap ):
  m_pHeap( heap )
{
  m_CoreData = GFL_NEW(heap) PermanentCoreData();
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
PermanentSaveData::~PermanentSaveData()
{
  GFL_DELETE( m_CoreData );
}

//-----------------------------------------------------------------------------
/**
 * @param  pSLControl
 */
//-----------------------------------------------------------------------------
void PermanentSaveData::AddBackupEntry( SaveLoadControl* pSLControl )
{
  pSLControl->AddBackupEntry( m_CoreData, sizeof(PermanentCoreData) );
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
void PermanentSaveData::Clear( gfl::heap::HeapBase * heap )
{
  gfl::std::MemClear( m_CoreData, sizeof(PermanentCoreData) );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
bool PermanentSaveData::IsValidData( void ) const
{
  return m_CoreData->magic_number == MAGIC_NUMBER;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static u8 DecideLangId( nn::cfg::CfgLanguageCode code )
{
  u8 lang_id = LANG_NULL;
  switch ( code )
  {
  case nn::cfg::CFG_LANGUAGE_JAPANESE:      lang_id = LANG_JAPAN;   break;	//{
  case nn::cfg::CFG_LANGUAGE_ENGLISH:	      lang_id = LANG_ENGLISH; break;  //p
  case nn::cfg::CFG_LANGUAGE_FRENCH:	      lang_id = LANG_FRANCE;  break;  //tX
  case nn::cfg::CFG_LANGUAGE_GERMAN:	      lang_id = LANG_GERMANY; break;  //hCc
  case nn::cfg::CFG_LANGUAGE_ITALIAN:	      lang_id = LANG_ITALY;   break;  //C^A
  case nn::cfg::CFG_LANGUAGE_SPANISH:	      lang_id = LANG_SPAIN;   break;  //XyC
  case nn::cfg::CFG_LANGUAGE_SIMP_CHINESE:  lang_id = LANG_ENGLISH; break;  //iȑ̎j
  case nn::cfg::CFG_LANGUAGE_KOREAN:	      lang_id = LANG_KOREA;   break;  //؍
  case nn::cfg::CFG_LANGUAGE_DUTCH:	        lang_id = LANG_ENGLISH; break;  //I_
  case nn::cfg::CFG_LANGUAGE_PORTUGUESE:	  lang_id = LANG_ENGLISH; break;  //|gK
  case nn::cfg::CFG_LANGUAGE_RUSSIAN:	      lang_id = LANG_ENGLISH; break;  //VA
  case nn::cfg::CFG_LANGUAGE_TRAD_CHINESE:	lang_id = LANG_ENGLISH; break;  //iɑ̎j
  //case nn::cfg::CFG_LANGUAGE_CODE_MAX:	
  }
  if ( lang_id == LANG_NULL )
  {
    GFL_ASSERT( 0 );
    lang_id = LANG_ENGLISH;
  }
  return lang_id;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static u8 DecideRealRegion( gfl::heap::HeapBase * pHeap )
{
  u8 form_no = 0;
  nn::cfg::CTR::SimpleAddress* simpleAddress = GFL_NEW_LOW(pHeap) nn::cfg::CTR::SimpleAddress();
  if( simpleAddress != NULL )
  {
    // ܓx/ox擾
    nn::cfg::CTR::GetSimpleAddress( simpleAddress );
    u16 longitude = simpleAddress->longitude;
    u16 latitude  = simpleAddress->latitude;
    form_no = poke_tool::RealRegion::DecideRegion( latitude, longitude );
  }
  GFL_SAFE_DELETE( simpleAddress );
  return form_no;
}

//-----------------------------------------------------------------------------
/**
 * @brief   ݒ菈
 * @todo    CRC̐`FbNǉ
 */
//-----------------------------------------------------------------------------
void PermanentSaveData::Setup( void )
{
  m_CoreData->magic_number = MAGIC_NUMBER;

  m_CoreData->langId = DecideLangId( nn::cfg::CfgLanguageCode() );

  m_CoreData->RealRegionFormNo = DecideRealRegion( m_pHeap );
}


//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
u8 PermanentSaveData::GetLangID( void ) const
{
  return m_CoreData->langId;
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
u8 PermanentSaveData::GetRealRegionFormNo( void ) const
{
  return m_CoreData->RealRegionFormNo;
}


GFL_NAMESPACE_END(savedata)

