//=============================================================================
/**
 * @file    RealRegionPokemon.cpp
 * @brief   An|P̃tH肷
 * @author  tamada
 * @date    2012.08.26
 */
//=============================================================================

GFL_NAMESPACE_BEGIN(poke_tool)
GFL_NAMESPACE_BEGIN(RealRegion)

enum {
  LATITUDE_INDEX_MAX = 16,
  LONGITUDE_INDEX_MAX = 36,
};

//-----------------------------------------------------------------------------
//xy_doc/|P֘A/An|Pdl.xlscsvŏóAƂŐ`
//-----------------------------------------------------------------------------
static const u8 RegionTable[LATITUDE_INDEX_MAX][LONGITUDE_INDEX_MAX] = {
  {  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  {  3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
  {  5, 5, 5, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
  {  9, 9, 9, 7, 9, 9, 9,11,11,11,11,11,11,11,11, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3,11,11, 8, 8, 2, 2, 2, 2, 2, 2 },
  {  9, 9, 9, 9, 9, 9,12,12,12,12, 4, 4, 4, 4, 4, 4, 6, 6, 9, 9, 9, 9, 9, 9, 9, 9,11,11,11, 8, 8, 8, 8, 8, 8, 8 },
  { 17,13,13,13,13,13,12,12,12,12,14,14,14,14, 4,14,17,17,17,17,17,17,17,17,17,17,17,11,11,11,10,10,10,10,10,10 },
  { 17,13,13,13,13,13,12,12,12,12,14,14,14,14,14,14,17,17,17,17,17,17,17,17,17,17,17,17,16,16,16,10,10,10,10,10 },
  { 17,18,18,18,18,18,16,12,17,17,18,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,17,17 },
  { 17,17,17,18,18,18,16,16,17,17,17,17,17,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17,17,17,18,18,18,18,15,15 },
  { 17,17,17,17,16,16,16,16,17,17,17,17,17,17,16,16,16,16,17,17,17,17,17,17,17,17,17,17,17,17,17,15,15,15,15,15 },
  { 17,17,17,17,13,13,16,16,17,17,17,17,17,17,13,13,13,13,13,17,17,17,17,17,17,17,17,17,17,17,17, 9,15,15,15,15 },
  { 10,10,10,10,10,10,10,10,10,10,10,13,13,13,13,13,13,13,13, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 9, 9, 9, 4,15, 4, 4 },
  { 10,10,10,10,10,10,10,10,10,10,10,13,13,13,13,13,13, 5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 9, 9, 9, 4, 4, 4, 4 },
  {  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1 },
  {  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
};

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
u8 DecideRegion( u16 latitude, u16 longitude )
{
  s16 deg_latitude = 0;
  if (0x0000 <= latitude && latitude <=0x4000)
  {
    deg_latitude = (latitude * 90) / 0x4000;
    if ( deg_latitude > 80 ) deg_latitude = 80;
  }
  else if (0xc0000 <= latitude && latitude <= 0xffff)
  {
    deg_latitude = (static_cast<s16>(latitude) * 90) / 0x4000;
    if ( deg_latitude < -80 ) deg_latitude = -80;
  }
  else
  {
    GFL_ASSERT( 0 );
  }
  int index_latitude = ( 80 - deg_latitude ) / 10;
  GFL_ASSERT( 0 <= index_latitude && index_latitude < LATITUDE_INDEX_MAX );

  int deg_longitude = (longitude * 360) / 0x10000;
  int index_longitude = ( (deg_longitude + 30) % 360 ) / 10;
  GFL_ASSERT( 0 <= index_longitude && index_longitude < LONGITUDE_INDEX_MAX );
  
  int form_index = RegionTable[index_latitude][index_longitude] - 1; // 1 org --> 0 org
  
  GFL_ASSERT( 0 <= form_index && form_index < 18 ); //20ނ邪2ނ͔zzp

  return form_index;
}


GFL_NAMESPACE_END(RealRegion)
GFL_NAMESPACE_END(poke_tool);
