//======================================================================
/**
 * @file  monster_ball.cpp
 * @brief ogX^[{[\[X
 * @author  ariizumi
 * @data  12/8/26
 */
//======================================================================

#include "item/monsball_id.h"
#include "item/itemsym.h"
#include "common_res/monster_ball.h"
#include "arc/monsball_gra_battle.gaix"


namespace common {
namespace resource {

u32 GetMonsterBallArcId_BallId( u32 ballId )
{
  GFL_ASSERT( ballId >= item::BALLID_MASUTAABOORU && ballId <= item::BALLID_MAX );
  
  if( ballId >= item::BALLID_MASUTAABOORU && ballId <= item::BALLID_MAX )
  {
    return GARC_monsball_gra_battle_ob0201_00_BCMDL + ballId-1;
  }
  else
  {
    return GARC_monsball_gra_battle_ob0204_00_BCMDL;
  }
}

u32 GetMonsterBallArcId_ItemId( u32 itemId )
{
  switch( itemId )
  {
  case ITEM_MASUTAABOORU:  //    ( 1 )   // }X^[{[
    return GARC_monsball_gra_battle_ob0201_00_BCMDL;
  case ITEM_HAIPAABOORU:   //    ( 2 )   // nCp[{[
    return GARC_monsball_gra_battle_ob0202_00_BCMDL;
  case ITEM_SUUPAABOORU:   //    ( 3 )   // X[p[{[
    return GARC_monsball_gra_battle_ob0203_00_BCMDL;
  case ITEM_MONSUTAABOORU: //    ( 4 )   // X^[{[
    return GARC_monsball_gra_battle_ob0204_00_BCMDL;
  case ITEM_SAFARIBOORU:   //    ( 5 )   // Tt@{[
    return GARC_monsball_gra_battle_ob0205_00_BCMDL;
  case ITEM_NETTOBOORU:    //    ( 6 )   // lbg{[
    return GARC_monsball_gra_battle_ob0206_00_BCMDL;
  case ITEM_DAIBUBOORU:    //    ( 7 )   // _Cu{[
    return GARC_monsball_gra_battle_ob0207_00_BCMDL;
  case ITEM_NESUTOBOORU:   //    ( 8 )   // lXg{[
    return GARC_monsball_gra_battle_ob0208_00_BCMDL;
  case ITEM_RIPIITOBOORU:  //    ( 9 )   // s[g{[
    return GARC_monsball_gra_battle_ob0209_00_BCMDL;
  case ITEM_TAIMAABOORU:   //    ( 10 )    // ^C}[{[
    return GARC_monsball_gra_battle_ob0210_00_BCMDL;
  case ITEM_GOOZYASUBOORU: //    ( 11 )    // S[WX{[
    return GARC_monsball_gra_battle_ob0211_00_BCMDL;
  case ITEM_PUREMIABOORU:  //    ( 12 )    // v~A{[
    return GARC_monsball_gra_battle_ob0212_00_BCMDL;
  case ITEM_DAAKUBOORU:    //    ( 13 )    // _[N{[
    return GARC_monsball_gra_battle_ob0213_00_BCMDL;
  case ITEM_HIIRUBOORU:    //    ( 14 )    // q[{[
    return GARC_monsball_gra_battle_ob0214_00_BCMDL;
  case ITEM_KUIKKUBOORU:   //    ( 15 )    // NCbN{[
    return GARC_monsball_gra_battle_ob0215_00_BCMDL;
  case ITEM_PURESYASUBOORU://    ( 16 )    // vVX{[
    return GARC_monsball_gra_battle_ob0216_00_BCMDL;
  case ITEM_SUPIIDOBOORU:  //    ( 492 )   // Xs[h{[
    return GARC_monsball_gra_battle_ob0217_00_BCMDL;
  case ITEM_REBERUBOORU:   //    ( 493 )   // x{[
    return GARC_monsball_gra_battle_ob0218_00_BCMDL;
  case ITEM_RUAABOORU:     //    ( 494 )   // A[{[
    return GARC_monsball_gra_battle_ob0219_00_BCMDL;
  case ITEM_HEBIIBOORU:    //    ( 495 )   // wr[{[
    return GARC_monsball_gra_battle_ob0220_00_BCMDL;
  case ITEM_RABURABUBOORU: //    ( 496 )   // uu{[
    return GARC_monsball_gra_battle_ob0221_00_BCMDL;
  case ITEM_HURENDOBOORU:  //    ( 497 )   // th{[
    return GARC_monsball_gra_battle_ob0222_00_BCMDL;
  case ITEM_MUUNBOORU:     //    ( 498 )   // [{[
    return GARC_monsball_gra_battle_ob0223_00_BCMDL;
  case ITEM_KONPEBOORU:    //    ( 499 )   // Ry{[
    return GARC_monsball_gra_battle_ob0224_00_BCMDL;
  case ITEM_DORIIMUBOORU:  //    ( 576 )   // h[{[
    return GARC_monsball_gra_battle_ob0225_00_BCMDL;
  }
  return GARC_monsball_gra_battle_ob0204_00_BCMDL;
}

}//namespace resource {
}//namespace common {
