//==============================================================================
/**
 * @file	battle_match_standby_view.h
 * @brief	ʃTur[@ΐ폀mF
 * @author	ichiraku_katsuhiko
 * @data	2012/08/26, 14:39
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_STANDBY_VIEW_H__ )
#define	__BATTLE_MATCH_STANDBY_VIEW_H__


#include <app/ui/UIView.h>
#include <pml_PokeParty.h>

#include "../battle_match_view_base.h"

// 
#include "common_res/poke_icon.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

class StandbyView : public ViewBase
{
	GFL_FORBID_COPY_AND_ASSIGN(StandbyView);

public:
	//-------------------------------------
  /// |PpyC\\	
  //=====================================
	typedef struct
	{
		gfl::grp::g2d::LytPaneIndex		poke;			///< |PACR
		gfl::grp::g2d::LytPaneIndex		item;			///< ACeACR
		gfl::grp::g2d::LytPaneIndex		lv;				///< LvACR
		gfl::grp::g2d::LytPaneIndex		lv_val;		///< x
		gfl::grp::g2d::LytPaneIndex		sex;			///< 
	} POKEMON_PANE;

public:
  // RXgN^
	StandbyView( app::util::Heap * heap,
						app::util::G2DUtil* g2dUtil,
						app::util::G2DUtil::LAYOUT_WORK* lyt_wk );
  // fXgN^
  virtual ~StandbyView( void );

public:

  //-----------------------------------------------------------------------
  // VXe
  //-----------------------------------------------------------------------
	//--------------------------------------------------------------------------
  /**
   *  @brief `
   */
  //--------------------------------------------------------------------------
  virtual void Update(void);

  //--------------------------------------------------------------------------
  /**
   *  @brief `
   */
  //--------------------------------------------------------------------------
  virtual void Draw(void);

  //--------------------------------------------------------------------------
	/**
	 * @brief	 ^Cg̕\
   * @param msg_id1		t[[eBO
   * @param msg_id2		og[
   */
  //--------------------------------------------------------------------------
	void SetTextTitle( u32 msg_id1, u32 msg_id2 );

  //--------------------------------------------------------------------------
  /**
   *  @brief |PACR\[X쐬
   */
  //--------------------------------------------------------------------------
	void CreatePokeIcon( void );

  //--------------------------------------------------------------------------
  /**
   *  @brief |PACR\[Xj
	 * 
	 *  @return	trueŔjł
   */
  //--------------------------------------------------------------------------
	bool DeletePokeIcon( void );

  //----------------------------------------------------------------------------
	/**
	 * @brief |Pꗗ̍XV 
   * @param p_pokeParty		莝|P
   */
  //----------------------------------------------------------------------------
	void UpdateSelectBoxPokemon( const pml::PokeParty* p_pokeParty );

  //----------------------------------------------------------------------------
	/**
	 * @brief |Pꗗ̍XV 
   * @param p_battleBox		og{bNX
   */
  //----------------------------------------------------------------------------
	void UpdateSelectBoxPokemon( savedata::BattleBox* p_battleBox );


  //----------------------------------------------------------------------------
	/**
	 * @brief		ׂĔ\ɂ
   */
  //----------------------------------------------------------------------------
	void VisibleOff( void );

private:

  //----------------------------------------------------------------------------
  /**
   *	@brief	|P̕\
   *	@param	icon_index			ǂݍޏꏊ
	 *  @param	pane_index			|P\yC\̂̃CfbNX
	 *	@aram	m	pp							|Pp[^
   */
  //----------------------------------------------------------------------------
	void SetPokemon( const u8 icon_index, const u8 pane_index, const pml::pokepara::PokemonParam *pp );

	// \E\ݒ
	void SetVisible( bool is_visible );

private:
  common::resource::PokeIcon*		m_pPokeIcon;				///< ʃ\[XF|PACR
	static const POKEMON_PANE			m_pokePaneTbl[6];	///< |P\pyC

};

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)



#endif	/* __BATTLE_MATCH_STANDBY_VIEW_H__ */

