//==============================================================================
/**
 * @file	battle_match_poke_select_view.cpp
 * @brief	ʃTur[@ĂEog{bNX\
 * @author	ichiraku_katsuhiko
 * @data	2012/08/26, 11:35
 */
// =============================================================================


#include "battle_match_poke_select_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "../battle_match_gra.h"
#include "../battle_match_gra_pane.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match )

//==========================================================================
/**
 *					|P\pyC`
 */
//==========================================================================

const PokeSelectView::POKEMON_PANE PokeSelectView::m_pokePaneTbl[ 12 ] = {
	// og{bNXp
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_01_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_01_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_01_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_01_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_01_01,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_01_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_01_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_01_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_01_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_01_02,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_01_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_01_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_01_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_01_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_01_03,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_01_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_01_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_01_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_01_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_01_04,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_01_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_01_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_01_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_01_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_01_05,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_01_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_01_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_01_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_01_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_01_06,
  },

	// Ă悤
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_02_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_02_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_02_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_02_01,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_02_01,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_02_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_02_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_02_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_02_02,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_02_02,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_02_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_02_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_02_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_02_03,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_02_03,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_02_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_02_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_02_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_02_04,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_02_04,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_02_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_02_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_02_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_02_05,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_02_05,
  },
  {
    PANENAME_BATTLEMATCH_UPPER_PANE_POKE_ICON_02_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_ITEM_HOLD_02_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_ICON_02_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_LEVEL_02_06,
    PANENAME_BATTLEMATCH_UPPER_PANE_SEIBETU_02_06,
  },
};

// RXgN^
PokeSelectView::PokeSelectView(	app::util::Heap * heap,
													app::util::G2DUtil* g2dUtil,
													app::util::G2DUtil::LAYOUT_WORK* lyt_wk ) :
	ViewBase( heap )
{
	// er[̃CAEgg
	Create2D( heap, g2dUtil->GetLayoutSystem(), LAYOUT_ID_MAX,
					  lyt_wk, LAYOUT_ID_MAX,
					  g2dUtil->GetMessageData(), g2dUtil->GetWordSet() );

}

// fXgN^
PokeSelectView::~PokeSelectView( void )
{
  GFL_SAFE_DELETE( m_pPokeIcon );
	Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void PokeSelectView::Update( void )
{
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void PokeSelectView::Draw( void )
{
  m_g2dUtil->Draw2D( GetSuperView()->GetGraphicSystem(), LAYOUT_ID_UPPER );
}


//--------------------------------------------------------------------------
/**
 *  @brief |PACR\[X쐬
 */
//--------------------------------------------------------------------------
void PokeSelectView::CreatePokeIcon( void )
{
  // |PACR\[X
  m_pPokeIcon = GFL_NEW( m_heap->pHeap ) common::resource::PokeIcon( m_heap->pHeap, m_heap->pDevHeap, 12 );
}


//--------------------------------------------------------------------------
/**
 *  @brief |PACR\[Xj
 * 
 *  @return	trueŔjł
 */
//--------------------------------------------------------------------------
bool PokeSelectView::DeletePokeIcon( void )
{
	if( m_pPokeIcon == NULL )
	{
		return true;
	}

	// j\`FbN
	if( m_pPokeIcon->IsModuleFree() == false )
	{
		return false;
	}

  GFL_SAFE_DELETE( m_pPokeIcon );
	return true;
}



//----------------------------------------------------------------------------
/**
 * @brief |Pꗗ̍XV 
 * @param p_pokeParty		莝|P
 */
//----------------------------------------------------------------------------

void PokeSelectView::UpdateSelectBoxPokemon( const pml::PokeParty* p_pokeParty )
{
  u32 cnt = p_pokeParty->GetMemberCount();	// 莝擾
  int i;
	const int diff = 6;		// 0IWł͂Ȃ̂

  // 莝\
  // @note WBł̓^}S\Ă̂ŕ\
  for ( i = 0; i < cnt; i++ )
  {
    const pml::pokepara::PokemonParam *pp = p_pokeParty->GetMemberPointerConst( i );
    SetPokemon( i + diff, i + diff, pp );
  }
  for ( ; i < pml::PokeParty::MAX_MEMBERS; i++ )
  {
    // \
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i + diff].poke, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i + diff].item, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i + diff].lv, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i + diff].lv_val, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i + diff].sex, false );
  }

	// ڕ\:Ă
	SetTextboxPaneMessage( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_PLAYER_NAME_02, battle_match_button_16 );


	// S\
	SetVisible( true );

  ICHI_PRINT( "莝\ %d\n", cnt );
}

//----------------------------------------------------------------------------
/**
 * @brief |Pꗗ̍XV 
 * @param p_battleBox		og{bNX
 */
//----------------------------------------------------------------------------

void PokeSelectView::UpdateSelectBoxPokemon( savedata::BattleBox* p_battleBox )
{
	u32 cnt = p_battleBox->GetPokemonCount( m_heap->pHeap ); // og{bNX̃|P
  int i;


  // 莝\
  // @note WBł̓^}S\Ă̂ŕ\
  for ( i = 0; i < cnt; i++ )
  {
		// og{bNX|Pp擾
		const pml::pokepara::CoreParam *cp = p_battleBox->GetPokemon( i, m_heap->pHeap );

		pml::pokepara::PokemonParam * pp = GFL_NEW_LOW( m_heap->pHeap ) pml::pokepara::PokemonParam( m_heap->pHeap, *cp );

		// |P\
    SetPokemon( i, i, pp );

		GFL_DELETE pp;
		GFL_DELETE cp;
  }
  for ( ; i < pml::PokeParty::MAX_MEMBERS; i++ )
  {
    // \
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i].poke, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i].item, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i].lv, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i].lv_val, false );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[i].sex, false );
  }

	// ڕ\:og{bNX
	SetTextboxPaneMessage( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_PLAYER_NAME_01, battle_match_button_15 );
  ICHI_PRINT( "og{bNX\\n" );

	// S\
	SetVisible( true );
}

//--------------------------------------------------------------------------
/**
 *  @brief \ɂ
 */
//--------------------------------------------------------------------------
void PokeSelectView::VisibleOff( void )
{
	SetVisible( false );
}

//----------------------------------------------------------------------------
/**
 *	@brief  |P̕\
 *	@param	icon_index			ǂݍޏꏊ
 *  @param	pane_index			|P\yC\̂̃CfbNX
 *	@aram	m	pp							|Pp[^
 */
//-----------------------------------------------------------------------------

void PokeSelectView::SetPokemon( const u8 icon_index, const u8 pane_index, const pml::pokepara::PokemonParam *pp )
{
  gfl::grp::g2d::LytWk* layout_work = GetG2DUtil()->GetLayoutWork( LAYOUT_ID_UPPER );

	ICHI_PRINT("|PACR\ icon_index %d pane_index %d poke_no \n", icon_index, pane_index, pp->GetMonsNo() );

  // SyC̕\
  GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].poke, true );
  GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].item, true );
  GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].lv, true );
  GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].lv_val, true );
  GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].sex, true );

  // |PACR
  {
    gfl::grp::g2d::LytPicture *pane = layout_work->GetPicturePane( m_pokePaneTbl[ pane_index ].poke );

    m_pPokeIcon->ReplacePaneTexture( icon_index, pp, 0, pane );
  }

  // ACeACR
  {
    u32	itemno = pp->GetItem();
    bool visible = ( itemno != ITEM_DUMMY_DATA );
    GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].item, visible );
  }

  // xݒ
  GetG2DUtil()->SetTextBoxPaneNumber( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].lv_val, battle_match_poke_lv, pp->GetLevel(), 3 );

  // 
  {
    pml::Sex sex = pp->GetSex();

    if( sex == pml::SEX_UNKNOWN )
    {
      // ʕsȂACR\
      GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].sex, false );
    }
    else
    {
      u32 msg_id;

      switch( sex ){
      case pml::SEX_MALE:		msg_id = battle_match_poke_sex_01; break;	// 
      case pml::SEX_FEMALE:	msg_id = battle_match_poke_sex_02; break;	// 
      default:							msg_id = battle_match_poke_sex_03; break;	// H
      }

      SetTextboxPaneMessage( LAYOUT_ID_UPPER, m_pokePaneTbl[ pane_index ].sex, msg_id );
    }
  }
}

//--------------------------------------------------------------------------
/**
 *  @brief \E\ݒ
 *  @param	is_visible	trueŕ\ falseŔ\
 */
//--------------------------------------------------------------------------
void PokeSelectView::SetVisible( bool is_visible )
{
	GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_SELECT_BG_01, is_visible );
	GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_SELECT_BG_02, is_visible );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

