//==============================================================================
/**
 * @file	battle_match_opponent_view.cpp
 * @brief	ʃTur[@ΐ푊
 * @author	ichiraku_katsuhiko
 * @data	2012/08/26, 14:55
 */
// =============================================================================


#include "battle_match_opponent_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "../battle_match_gra.h"
#include "../battle_match_gra_pane.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// RXgN^
OpponentView::OpponentView(	app::util::Heap * heap,
													app::util::G2DUtil* g2dUtil,
													app::util::G2DUtil::LAYOUT_WORK* lyt_wk ) :
	ViewBase( heap )
{
	// er[̃CAEgg
	Create2D( heap, g2dUtil->GetLayoutSystem(), LAYOUT_ID_MAX,
					  lyt_wk, LAYOUT_ID_MAX,
					  g2dUtil->GetMessageData(), g2dUtil->GetWordSet() );

	m_pPlayerIconTex				= NULL;
}

// fXgN^
OpponentView::~OpponentView( void )
{
	Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void OpponentView::Update( void )
{
	// vC[ACRXV
	if( m_pPlayerIconTexManager != NULL )
	{
		m_pPlayerIconTexManager->Update();
	}

  //this->app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void OpponentView::Draw( void )
{
  m_g2dUtil->Draw2D( GetSuperView()->GetGraphicSystem(), LAYOUT_ID_UPPER );
}

//--------------------------------------------------------------------------
/**
 * @brief	 ^Cg̕\
 * @param msg_id	\郁bZ[WID
 */
//--------------------------------------------------------------------------
void OpponentView::SetTextTitle( u32 msg_id )
{
	SetTextboxPaneMessage( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_TEXT_00_01, msg_id );
}

//--------------------------------------------------------------------------
/**
 * @brief	 [g̐lݒ
 * @param rate	\郌[gl
 */
//--------------------------------------------------------------------------
void OpponentView::SetCountRate( u32 rate )
{
	// [g
	SetTextboxPaneMessage( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING_TEXT_02, battle_match_oppstatus_02 );

  GetG2DUtil()->SetTextBoxPaneNumber( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING_TEXT_03, battle_match_oppstatus_03, rate, 4 );
}

//-----------------------------------------------------------------------------
/**
 * @brief	 ΐ푊̏\
 * 
 * @param		myst	\vC[̃}CXe[^X
 */
//-----------------------------------------------------------------------------
void OpponentView::SetPlayerData( const savedata::MyStatus * myst )
{
	// vC[
	{
		gfl::str::StrBuf	playerName( pml::PERSON_NAME_BUFFER_SIZE, m_heap->pHeap );
		myst->GetNameString( &playerName );
		SetTextboxPaneString( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING_TEXT_01, playerName.GetPtr() );
	}

	// @todo
	// ЂƂ
	SetTextboxPaneString( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING_TEXT_04, L"ɂ" );
	// og
	SetTextboxPaneString( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING_TEXT_05, L"ɂق" );
	SetTextboxPaneString( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING_TEXT_06, L"Ƃ傤" );
}

//--------------------------------------------------------------------------
/**
 * @brief	 ׂĂ̕\E\
 * @param is_visible		true = \, false = \
 */
//--------------------------------------------------------------------------
void OpponentView::SetVisibleAll( bool is_visible )
{
	GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_TEXT_WINDOW, is_visible );
	GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_RATING, is_visible );
}

//-----------------------------------------------------------------------------
/**
 * @brief	 vC[ACR}l[W쐬
 * 
 * @param		myst	\vC[̃}CXe[^X
 */
//-----------------------------------------------------------------------------
void OpponentView::CreatePlayerIcon( const savedata::MyStatus *myst )
{
	// vC[ACR쐬
	common::resource::PlayerIconTexManager::IconDesc desc;
	common::resource::PlayerIconTexManager::IconParam param;

	// l
	if( myst->GetSex() == PM_MALE ){
		param.fix_id = xy_system::player_icon::TR_ICON_ID_0001;
	// l
	}else{
		param.fix_id = xy_system::player_icon::TR_ICON_ID_0001;
	}
	param.fashion_buffer = &myst->GetDressUpData();

	desc.replace_info_num_max = 1;

	m_pPlayerIconTex = m_pPlayerIconTexManager->RequestCreatePlayerIconTex(
										m_heap->pHeap,
										m_heap->pDevHeap,
										m_heap->pHeap,
										m_heap->pDevHeap,
										param,
										desc );


	common::resource::PlayerIconTex::ReplaceInfo info;
	info.replace_mode = common::resource::PlayerIconTex::REPLACE_MODE_WAIT;
	info.pane = GetG2DUtil()->GetLayoutWork(LAYOUT_ID_UPPER)->GetPicturePane(PANENAME_BATTLEMATCH_UPPER_PANE_PLAYER_ICON);
	m_pPlayerIconTex->AddReplaceInfo( info );
}

//-----------------------------------------------------------------------------
/**
 * @brief	 vC[ACR}l[Wj
 * 
 * @return jłtrue
 */
//-----------------------------------------------------------------------------
bool OpponentView::DeletePlayerIcon( void )
{

	// jł邩mF
	if( IsDeletePlayerIcon() == false )
	{
		return false;
	}

	m_pPlayerIconTexManager->DestroyIcon( m_pPlayerIconTex, false, 0 );

	return true;
}

//-----------------------------------------------------------------------------
/**
 * @brief	 vC[ACR쐬Ă邩̃`FbN
 * 
 * @return 쐬Ftrue ܂쐬:false
 */
//-----------------------------------------------------------------------------
bool OpponentView::CheckCreatePlayerIconTex( void )
{
	return m_pPlayerIconTexManager->IsIconCreated( m_pPlayerIconTex );
}

//-----------------------------------------------------------------------------
/**
 * @brief	 vC[ACRj\`FbN
 * 
 * @return	jł:true	jłȂ:false
 */
//-----------------------------------------------------------------------------
bool OpponentView::IsDeletePlayerIcon( void )
{
	return m_pPlayerIconTexManager->IsAbleToDestroyIcon( m_pPlayerIconTex );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
