//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		H3dShaderModel.cpp
 *	@brief  VF[_[fNX
 *	@author	Masayuki Onoue
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <system/H3dShaderModel.h>
//#include "H3dShaderModel.h"

namespace xy_system {


//-----------------------------------------------------------------------------
/*
 *  @brief         RXgN^
 *                 Create͌Ă΂܂B
 */
//-----------------------------------------------------------------------------
H3dShaderModel::H3dShaderModel(void): H3dModel(),
  m_ppShaderAnimationData(NULL),
  m_MaterialCount(0),
  m_ppMaterialNames(NULL),
  m_pOneMaterialName(NULL),
  m_AnimationSlotNum(0),
  m_MaterialMax(DefaultMaterialMax),
  m_CreateSlotBit( 0 )
{
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[f֘Ap[^
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::DestroyH3dShaderModelParam(void)
{
  // }eAXg
  GFL_SAFE_DELETE_ARRAY( m_ppMaterialNames );
  
  // }eA֘Aj
  if( m_ppShaderAnimationData )
  {
    for( int i = 0; i < m_AnimationSlotNum ; i++ )
    {
      if( m_ppShaderAnimationData[i] )
      {
        // f[^̉
        GFL_SAFE_DELETE_ARRAY(m_ppShaderAnimationData[i]->pMaterialNumData);
        // f[^{̂̉
        GFL_SAFE_DELETE(m_ppShaderAnimationData[i]);
      }
    }
  }

  // Aj[Vz̉
  // ONOUE_PRINT("del = %x\n",m_ppShaderAnimationData);
  GFL_SAFE_DELETE_ARRAY( m_ppShaderAnimationData);

}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[Vp[^̉
 *
 * @param slot_index  XbgCfbNX
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::FreeH3dShaderModelParam( u32 slot_index )
{
  if( m_ppShaderAnimationData )
  {
    if( m_ppShaderAnimationData[slot_index] )
    {
      // f[^̉
      GFL_SAFE_DELETE_ARRAY(m_ppShaderAnimationData[slot_index]->pMaterialNumData);
      // f[^{̂̉
      GFL_SAFE_DELETE(m_ppShaderAnimationData[slot_index]);
    }
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief j
 *        ĂłvBfXgN^͌Ă΂܂B
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::Destroy(void)
{
  // VF[_[p[^
  DestroyH3dShaderModelParam();

  // ʏ̔j
  H3dModel::Destroy();
}

//-----------------------------------------------------------------------------
/*
 *  @brief         fXgN^
 */
//-----------------------------------------------------------------------------
H3dShaderModel::~H3dShaderModel()
{
  DestroyH3dShaderModelParam();
}
  
//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dShaderModel::Create(
    gfl::heap::NwAllocator*           allocator,
    gfl::heap::NwAllocator*           device_allocator,
    gfl::grp::g3d::H3dResource*          resource,
    s32                               index_in_resource,
    Description*                      description
)
{
  gfl::heap::HeapBase* pHeap = allocator->GetHeapBase();

  H3dModel::Create( allocator, device_allocator, resource, index_in_resource );
  CreateParam( pHeap ,description );
  
  if ( description && description->animation_slot_num )
  {
    CreateAnimationManager(allocator, description->animation_slot_num );
    ISHIGURO_PRINT("================== CreateAnimationManager =========================\n");
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[VɕKvȃf[^쐬
 *
 * @param pDescription  ݒf[^
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::CreateParam( gfl::heap::HeapBase* pHeap ,Description* pDescription )
{
  // w̎̓ftHggp
  Description description;
  if( pDescription )
  {
    description = *pDescription;
  }

  // }eA擾
  m_MaterialCount = this->GetMaterialCount();
  // XbgoĂ
  m_AnimationSlotNum = description.animation_slot_num;
  GFL_ASSERT( m_MaterialCount < m_MaterialMax );

  // XbgAVF[_[Aj[Vi[|C^쐬
  if( m_AnimationSlotNum > 0 )
  {
    if( m_ppShaderAnimationData )
    {
      GFL_ASSERT(0);
    }
    u32 slot_num = m_AnimationSlotNum;
    m_ppShaderAnimationData = GFL_NEW_ARRAY(pHeap) ShaderAnimationData*[slot_num]; 
    for( int i=0; i < slot_num; i ++ )
    {
      m_ppShaderAnimationData[i] = NULL;
    }
  }

  // }eA
  m_ppMaterialNames = GFL_NEW_ARRAY(pHeap) const char*[m_MaterialMax]; 
  // }eANA
  for( s32 i = 0; i < m_MaterialMax; ++i )
  {
    m_ppMaterialNames[ i ] = NULL;
  }
  // }eAZbg
  for( s32 i = 0; i < m_MaterialCount; ++i )
  {
    m_ppMaterialNames[ i ] = this->GetMaterialName( i );
  }
}

//-----------------------------------------------------------------------------
/*
 *  @brief         vZ
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::Calculate(void)
{
    // }eA֘Aj
  for( int i = 0; i < m_AnimationSlotNum ; i++ )
  {
    if( IsEnableShaderAnimation(i) )
    {
      // VF[_[p[^̍XV
      UpdateShaderParam( m_ppShaderAnimationData[i] );
    }
  }
  // vZ̎s
  H3dModel::Calculate();
}

void H3dShaderModel::createAnimationSlot( gfl::heap::NwAllocator* allocator, gfl::grp::g3d::H3dResAnim* res_anim, u32 slot_index)
{
  u32     checkBit = ( 1 << slot_index );
  if ( (m_CreateSlotBit & checkBit) == 0 )
  {
    gfl::grp::g3d::H3dAnimationSlot::Description   slot_desc;
    slot_desc.res_anim = res_anim;

    CreateAnimationSlot( allocator, slot_index, &slot_desc );
    m_CreateSlotBit |= checkBit;
    
    ISHIGURO_PRINT("--------------- createAnimationSlot ------------------\n");
  }
}

//-----------------------------------------------------------------------------
/*
*  @brief         Aj[VύX(\[X̎ނ𔻒fāACSHADERŃZbgAbv)
 *                 slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AΏۃXbgAnimation𐶐B
 *                 slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAΏۃXbgAnimation𐶐B
 *
 *  @param[in]     allocator               AP[^
 *  @param[in]     res_anim                Aj[V\[X(NULLnƑS(XP^A}eAArWreB)̃Aj[V܂)
 *  @param[in]     change_frame            t[ŕύX邩(̊ԃuh)
 *  @param[in]     slot_index              Aj[V蓖ĂXbg̃CfbNX
 *  @param[in]     max_anim_members        Aj[V郁o̍ő吔B(res_animNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOKA܂CSHADERɂ͖)
 *                                         slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AgpB
 *                                         slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAgpB
 *                                         Resource::Get???MemberAnimSetCountœlnƂ悢B
 *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRSTnƁA
 *                                         ŏChangeœnAj[V\[XGetMemberAnimSetCountgp܂B
 *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERSnƁA
 *                                         ŏChangeœnAj[V\[X̃Aj[VO[ṽoɁA
 *                                         ÃAj[V^Cvɂő吔ɂ܂B
 *  @param[in]     force                   IɃAj[V֘At܂B(res_animNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOKACSHADERɂ͖)
 *
 *  @note CSHADERȂǓƎtH[}bgɂ̓XbggpȂ
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::ChangeAnimation(
    gfl::heap::NwAllocator* allocator,
    gfl::grp::g3d::H3dResAnim* res_anim,
    u32                     change_frame,
    u32                     slot_index,
    s32                     max_anim_members,
    bool                    force
    )
{
  ANIMATION_SETUP_TYPE setup_type = GetAnimationSetupType( res_anim );
  // ONOUE_PRINT("m_MaterialMax = %d\n",m_MaterialMax);
  
  //max_anim_members
  //force
  GFL_ASSERT_MSG( (change_frame==0), "not surpport yet..." );

  // NULL̂Ƃ̓Aj[V
  if( res_anim == NULL )
  {
    if( IsEnableShaderAnimation(slot_index) )
    {
      // Xbgf[^̉
      FreeH3dShaderModelParam(slot_index);
    }
    else
    {
      // ChangeAnimationNULLNAĂȂȂ
      H3dModel::ChangeAnimationByResAnim( slot_index, res_anim );
    }
    return;
  }
  
  createAnimationSlot( allocator, res_anim, slot_index );

  // ʏZbgAbv
  if( setup_type == ANIMATION_SETUP_TYPE_NORMAL )
  {
    H3dModel::ChangeAnimationByResAnim( slot_index, res_anim );
  }
  // CSHADER̔f
  else if( setup_type == ANIMATION_SETUP_TYPE_CSHADER )
  {
    ChangeShaderAnimation(
        allocator,
        res_anim,
        change_frame,
        slot_index);
  }
  else
  {
    GFL_ASSERT_MSG(0,"Aj[VZbgAbv^Cvsł\n");
  }
}

// u}eAAj[Vt@Cɂ1̃}eAp̃Aj[Vvuf̑SẴ}eAvɓKp
void H3dShaderModel::SetUseOneMaterialAnimation(
  const char*             one_material_name
)
{
  m_pOneMaterialName = one_material_name;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[Aj[Vݒ肷
 *
 * @param allocator         AP[^
 * @param res_anim          Aj\[X
 * @param change_frame      Nt[
 * @param slot_index        gpXbgԍ
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::ChangeShaderAnimation( 
    gfl::heap::NwAllocator* allocator,
    gfl::grp::g3d::H3dResAnim* res_anim,
    u32                     change_frame,
    u32                     slot_index )
{
  if( !m_ppShaderAnimationData[slot_index] )
  {
    // ̓AP[^ȂƏłȂ
    // @todo ̓AT[g?
    if( allocator == NULL ){ return; }
    
    // Aj[Vf[^쐬
    AllocShaderAnimation(allocator,m_ppShaderAnimationData[slot_index]);
  }
  else
  {
    // 2ڈȍ~̓AP[^ȂĂv
    
    ClearShaderAnimation( m_ppShaderAnimationData[slot_index] );
  }

  // Aj[Vf[^ݒ
  SetShaderAttributeAnimData( res_anim ,m_ppShaderAnimationData[slot_index] );

  f32 end_frame = m_ppShaderAnimationData[slot_index]->pResAnim->GetFrameSize();
  SetAnimationStartAndEndFrame(0,end_frame,slot_index);
  // Aj[V̔f
  UpdateShaderAttributeAnim( m_ppShaderAnimationData[slot_index] );
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[VύX
 *                 slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AΏۃXbgAnimation𐶐B
 *                 slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAΏۃXbgAnimation𐶐B
 *
 *  @param[in]     allocator               AP[^
 *  @param[in]     resource                \[X(NULLnƑS(XP^A}eAArWreB)̃Aj[V܂)
 *  @param[in]     animation_resource_type Aj[V\[X̃^Cv(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
 *  @param[in]     index_in_resource       \[XɂCfbNX(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
 *  @param[in]     change_frame            t[ŕύX邩(̊ԃuh)
 *  @param[in]     slot_index              Aj[V蓖ĂXbg̃CfbNX
 *  @param[in]     max_anim_members        Aj[V郁o̍ő吔B(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
 *                                         slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AgpB
 *                                         slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAgpB
 *                                         Resource::Get???MemberAnimSetCountœlnƂ悢B
 *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRSTnƁA
 *                                         ŏChangeœnAj[V\[XGetMemberAnimSetCountgp܂B
 *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERSnƁA
 *                                         ŏChangeœnAj[V\[X̃Aj[VO[ṽoɁA
 *                                         ÃAj[V^Cvɂő吔ɂ܂B
 *  @param[in]     force                   IɃAj[V֘At܂B(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::ChangeAnimation(
    gfl::heap::NwAllocator*          allocator,
    gfl::grp::g3d::H3dResAnim*         res_anim,
    gfl::grp::g3d::Resource::AnimationResourceType  animation_resource_type,
    s32                              index_in_resource,
    u32                              change_frame,
    u32                              slot_index,
    s32                              max_anim_members,
    bool                             force )
{
  // NULL̂Ƃ̓Aj[V
  if( res_anim == NULL )
  {
    if( IsEnableShaderAnimation(slot_index) )
    {
      // Xbgf[^̉
      FreeH3dShaderModelParam(slot_index);
    }
    else
    {
      H3dModel::ChangeAnimationByResAnim( slot_index, NULL );
    }
    return;
  }
  
  createAnimationSlot( allocator, res_anim, slot_index );

  // ZbgAbv^Cv擾
  ANIMATION_SETUP_TYPE setup_type = GetAnimationSetupType( res_anim );
  
  // ʏZbgAbv
  if( setup_type == ANIMATION_SETUP_TYPE_NORMAL )
  {
    H3dModel::ChangeAnimationByResAnim( slot_index, res_anim );
  }
  // CSHADER̔f
  else if( setup_type == ANIMATION_SETUP_TYPE_CSHADER )
  {
    ChangeShaderAnimation(
        allocator,
        res_anim,
        change_frame,
        slot_index);
  }
  else
  {
    GFL_ASSERT_MSG(0,"Aj[VZbgAbv^Cvsł\n");
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief   Aj[VZbgAbv^Cv擾
 *
 * @param   ׂAj[V^Cv
 *
 * @return  Aj[ṼZbgAbv^Cv
 */
/* -------------------------------------------------------------------------*/
H3dShaderModel::ANIMATION_SETUP_TYPE H3dShaderModel::GetAnimationSetupType( const gfl::grp::g3d::H3dResAnim* res_anim )
{
  if ( res_anim == NULL )    return ANIMATION_SETUP_TYPE_MAX;

  // tH[}bg^Cv擾
  s32 user_data_count = res_anim->GetUserDataCount();
  if( user_data_count <= 0 )
  {
    return H3dShaderModel::ANIMATION_SETUP_TYPE_NORMAL;
  }
  else
  {
    // ƎtH[}bg
    gfl::grp::g3d::H3dUserData    user_data;
    s32                           user_data_index = 0;
    
    user_data_index = res_anim->GetUserDataIndex( "$FormatType" );
    res_anim->GetUserData( user_data_index, &user_data );

    s32 formatType = user_data.GetIntValue( 0 );
    if( formatType == USER_FORMAT_TYPE_CSHADER )
    {
      return H3dShaderModel::ANIMATION_SETUP_TYPE_CSHADER;
    }
    else if( formatType == USER_FORMAT_TYPE_CKEY )
    {
      return H3dShaderModel::ANIMATION_SETUP_TYPE_CKEY;
    }
  }
    
  GFL_ASSERT_MSG(0,"m̃Aj[VtH[}bg\n");
  return H3dShaderModel::ANIMATION_SETUP_TYPE_MAX;
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[V̊Jnt[ƏIt[ݒ肷
 *
 *  @param[in]     start_frame     Jnt[
 *  @param[in]     end_frame       It[
 *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::SetAnimationStartAndEndFrame(f32 start_frame, f32 end_frame, u32 slot_index)
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    ShaderAnimationData* pShaderAnimationData = m_ppShaderAnimationData[slot_index];
    pShaderAnimationData->ShaderAnimFrame     = start_frame;
    pShaderAnimationData->ShaderAnimEndFrame  = end_frame;
  }
  else
  {
    H3dModel::SetAnimationStartFrame(slot_index, start_frame);
    H3dModel::SetAnimationEndFrame(slot_index, end_frame);
    //Model::SetAnimationStartAndEndFrame( start_frame, end_frame, slot_index);
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[̃p[^XbgɉăAbvf[g
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::UpdateShaderParam( ShaderAnimationData* pAnmData )
{
  // Aj[Vf[^ȂƂ͍XVsȂ
  if( !pAnmData )
  {
    return;
  }

  // Aj[V\[Xݒ肳ĂȂꍇXLbv
  const gfl::grp::g3d::H3dResAnim* pResAnim = pAnmData->pResAnim;
  if( !pResAnim )
  {
    GFL_ASSERT_MSG(0,"Aj[V\[Xݒ肳Ă܂\n");
    return;
  }

  // Aj[Vt[̍XV
  pAnmData->ShaderAnimFrame += pAnmData->ShaderStepFrame;

  // Aj[V̔f
  UpdateShaderAttributeAnim( pAnmData );

  // Aj[Ṽ[v
  f32 max = pAnmData->ShaderAnimEndFrame; //pResAnim->GetFrameSize();
  if( pAnmData->ShaderAnimationLoop )
  {
    // [vL
    if( pAnmData->ShaderAnimFrame >= max )
    {
      pAnmData->ShaderAnimFrame = 0;
    }
  }
  else
  {
    // [v
    if( pAnmData->ShaderAnimFrame >= max )
    {
      pAnmData->ShaderAnimFrame = max-1.0f;
    }
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[V̍XVt[ݒ肷
 *
 * @param frame       t[
 * @param slot_index  XbgCfbNX
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::SetAnimationStepFrame(f32 frame, u32 slot_index)
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    m_ppShaderAnimationData[slot_index]->ShaderStepFrame = frame;
  }
  else
  {
    H3dModel::SetAnimationStepFrame( slot_index, frame );
    //Model::SetAnimationStepFrame( frame ,slot_index );
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[V̍XVt[擾
 *
 * @param slot_index  XbgCfbNX
 * @return Aj[Vt[
 */
/* -------------------------------------------------------------------------*/
f32 H3dShaderModel::GetAnimationStepFrame( u32 slot_index ) const
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    return m_ppShaderAnimationData[slot_index]->ShaderStepFrame;
  }
  //return Model::GetAnimationStepFrame( slot_index );
  return H3dModel::GetAnimationStepFrame( slot_index );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[V̍XVt[ݒ肷
 *
 * @param frame       t[
 * @param slot_index  XbgCfbNX
 * @return Aj[Vt[
 */
/* -------------------------------------------------------------------------*/
f32 H3dShaderModel::GetAnimationFrame( u32 slot_index ) const
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    return m_ppShaderAnimationData[slot_index]->ShaderAnimFrame;
  }
  //return Model::GetAnimationFrame( slot_index );
  return H3dModel::GetAnimationFrame( slot_index );
}

/* -------------------------------------------------------------------------*/
/**
 * @brief Aj[V̍XVt[ݒ肷邷
 *
 * @param frame       t[
 * @param slot_index  XbgCfbNX
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::SetAnimationFrame( f32 frame ,u32 slot_index )
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    m_ppShaderAnimationData[slot_index]->ShaderAnimFrame = frame;
  }
  else
  {
    H3dModel::SetAnimationFrame( slot_index, frame );
    //Model::SetAnimationFrame( frame ,slot_index );
  }
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[V[vĐۂ擾
 *
 *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
 *
 *  @retval        bool            [v̂ƂtrueA[vłȂƂfalseԂ
 */
//-----------------------------------------------------------------------------
bool H3dShaderModel::IsAnimationLoop(u32 slot_index) const
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    return m_ppShaderAnimationData[slot_index]->ShaderAnimationLoop;
  }
  //return Model::IsAnimationLoop( slot_index );
  return H3dModel::IsAnimationLoop( slot_index );
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[VɃ[vĐݒ肷
 *
 *  @param[in]     loop            [v̂ƂtrueA[vłȂƂfalseݒ肷
 *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::SetAnimationLoop(bool loop, u32 slot_index)
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    m_ppShaderAnimationData[slot_index]->ShaderAnimationLoop = loop;
  }
  else
  {
    H3dModel::SetAnimationLoop( slot_index, loop );
    //Model::SetAnimationLoop( loop, slot_index);
  }
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[V݂̌̃t[It[ۂ肷
 *
 *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
 *
 *  @retval        bool    ݂̃t[It[̏ꍇtureԂ
 */
//-----------------------------------------------------------------------------
bool H3dShaderModel::IsAnimationFrameEndFrame(u32 slot_index) const
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    const gfl::grp::g3d::H3dResAnim* pResAnim;
    pResAnim = m_ppShaderAnimationData[slot_index]->pResAnim;
    f32 max = m_ppShaderAnimationData[slot_index]->ShaderAnimEndFrame; //pResAnim->GetFrameSize();
    if( m_ppShaderAnimationData[slot_index]->ShaderAnimFrame >= (max -1.0f) )
    {
      return true;
    }
    return false;
  }
  return H3dModel::IsAnimationFrameEndFrame( slot_index );
  //return Model::IsAnimationFrameEndFrame( slot_index );
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[V̏It[擾
 *
 *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
 *
 *  @retval        t[
 */
//-----------------------------------------------------------------------------
f32 H3dShaderModel::GetAnimationEndFrame( u32 slot_index ) const
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    return m_ppShaderAnimationData[slot_index]->ShaderAnimEndFrame; //m_ppShaderAnimationData[slot_index]->pResAnim->GetFrameSize();
  }
  return H3dModel::GetAnimationEndFrame( slot_index );
  //return Model::GetAnimationEndFrame( slot_index );
}

//-----------------------------------------------------------------------------
/*
 *  @brief         Aj[V̏It[Zbg
 *
 *  @param[in]    frame            t[
 *  @param[in]    slot_index       Aj[V蓖ĂXbg̃CfbNX
 *
 *  @retval        none
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::SetAnimationEndFrame( f32 frame, u32 slot_index )
{
  if( IsEnableShaderAnimation(slot_index) )
  {
    m_ppShaderAnimationData[slot_index]->ShaderAnimEndFrame = frame;
  }
  H3dModel::SetAnimationEndFrame( slot_index, frame );
  //Model::SetAnimationEndFrame( frame, slot_index );
}

//-----------------------------------------------------------------------------
/**
 * @brief VF[_[Agr[gAj[Vt[ݒ
 * @param frame t[
 *
 * @note 폜\
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::SetShaderAttributeAnimFrame( f32 frame )
{
}

//-----------------------------------------------------------------------------
/**
 * @brief ݂̃Aj[Vt[ɍ킹āAf[^XV
 * @param frame t[
 */
//-----------------------------------------------------------------------------
void H3dShaderModel::UpdateShaderAttributeAnim( ShaderAnimationData* pAnmData )
{  
  // NULL`FbN
  if( pAnmData == NULL ) return;
  if ( pAnmData->pResAnim == NULL )    return;

  const gfl::grp::g3d::H3dResAnim*  pResAnim = pAnmData->pResAnim;
  ShaderMaterialNumData* pMat = pAnmData->pMaterialNumData;

  // ONOUE_PRINT("anm_frame:%f\n",pAnmData->ShaderAnimFrame);
 
  // }eAAbvf[gs
  for( s32 materialNo = 0; materialNo < m_MaterialCount; ++materialNo )
  {
    // f[^擾
    //nw::gfx::Material*  material = this->GetMaterial( materialNo );
    const char*         pMaterialName = this->GetMaterialName( materialNo );
    s32                 matIdx = getMaterialIndex( pMaterialName );
    
    // }eAȂꍇ̓XLbv
    if ( matIdx == -1 ){ continue; }
    
    s32 dataHandle = -1;
    
    {  
      //res_material = material->GetMaterialColorResMaterial();
      //nw::gfx::ResMaterialColor res_color = res_material.GetMaterialColor();
      setConstantAnim( pResAnim, &pMat[matIdx], pAnmData->ShaderAnimFrame, materialNo );
    }

    dataHandle = pMat[matIdx].AlphaRefHandle;
    if ( dataHandle != -1 )
    {
      f32 value;
      //res_material = material->GetAlphaTestResMaterial();
      //nw::gfx::res::ResFragmentShader res_shader = res_material.GetFragmentShader();
      //nw::gfx::res::ResAlphaTest  res_alpha_test = res_shader.GetAlphaTest();
      //value = pResAnim->GetFloatValue( dataHandle, pAnmData->ShaderAnimFrame );
      //res_alpha_test.SetTestReference( value );
      //res_material.SetAlphaTestHash(0x0);
      
      pResAnim->GetFloatValue( dataHandle, pAnmData->ShaderAnimFrame, &value );
      SetMaterialAlphaTestReference( materialNo, value );
    }
    
    {
      //res_material = material->GetTextureCombinerResMaterial();
      //nw::gfx::res::ResFragmentShader res_shader = res_material.GetFragmentShader();
      
      for ( s32 keyCnt = 0; keyCnt < pMat[matIdx].CombinerKeyCnt; ++keyCnt )
      {
        s32 attrType = pMat[matIdx].CombinerHandleType[keyCnt];
        dataHandle = pMat[matIdx].CombinerHandle[keyCnt];
        
        s32                 colorType = ( attrType < FloatAnimDataType::TextureCombinerAlpha0_MathFormula ) ? CombinerColorType::RGB : CombinerColorType::A;
        s32                 convNo;
        s32                 elementType;
        float               value;

        convNo = attrType - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
        convNo %= CombinerStageNum;

        elementType = attrType - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
        elementType /= CombinerStageNum;
        elementType = ( colorType == CombinerColorType::RGB ) ? elementType : elementType - CombinerElementNum;

        //nw::gfx::ResTextureCombiner res_combiner = res_shader.GetTextureCombiners(convNo);
        
        switch( elementType ){
        case CombinerElementType::MathFormula:
          {         
            if ( colorType == CombinerColorType::RGB )
              //res_combiner.SetCombineRgb( getCombinerCombineData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerCombineRgb(materialNo, convNo, getCombinerCombineData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
            else
              //res_combiner.SetCombineAlpha( getCombinerCombineData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerCombineAlpha(materialNo, convNo, getCombinerCombineData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
          }
          break;
        case CombinerElementType::Scale:
          {         
            if ( colorType == CombinerColorType::RGB )
              //res_combiner.SetScaleRgb( getCombinerScaleData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerScaleRgb(materialNo, convNo, getCombinerScaleData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
            else
              //res_combiner.SetScaleAlpha( getCombinerScaleData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerScaleAlpha( materialNo, convNo, getCombinerScaleData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
          }
          break;
        case CombinerElementType::InputSourceA:
        case CombinerElementType::InputSourceB:
        case CombinerElementType::InputSourceC:
          {
            s32     index = elementType - CombinerElementType::InputSourceA;

            if ( colorType == CombinerColorType::RGB )
              //res_combiner.SetSourceRgb( index, getCombinerSrcData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerSourceRgb( materialNo, convNo, index, getCombinerSrcData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
            else
              //res_combiner.SetSourceAlpha( index, getCombinerSrcData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerSourceAlpha( materialNo, convNo, index, getCombinerSrcData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
          }
          break;
        case CombinerElementType::OperandA:
        case CombinerElementType::OperandB:
        case CombinerElementType::OperandC:
          {
            s32     index = elementType - CombinerElementType::OperandA;

            if ( colorType == CombinerColorType::RGB )
              //res_combiner.SetOperandRgb( index, getCombinerOperandRgbData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerOperandRgb( materialNo, convNo, index, getCombinerOperandRgbData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
            else
              //res_combiner.SetOperandAlpha( index, getCombinerOperandAlphaData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ) );
              SetMaterialTextureCombinerOperandAlpha( materialNo, convNo, index, getCombinerOperandAlphaData( pResAnim, dataHandle, pAnmData->ShaderAnimFrame ) );
          }
          break;
        case CombinerElementType::OutPutBuffer:
          {//̒iւ̏o͐ݒł͂ȂAO̒i̓͐ݒȂ̂ŒӂKvBiconvNo + 1j
            if ( colorType == CombinerColorType::RGB )
              //res_shader.SetBufferInputRgb(convNo + 1, getCombinerBufferInputData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ));
              SetMaterialFragmentShaderBufferInputRgb(materialNo, convNo + 1, getCombinerBufferInputData( pResAnim,dataHandle, pAnmData->ShaderAnimFrame ));
            else
              //res_shader.SetBufferInputAlpha(convNo + 1, getCombinerBufferInputData(pResAnim, dataHandle, pAnmData->ShaderAnimFrame ));
              SetMaterialFragmentShaderBufferInputAlpha(materialNo, convNo + 1, getCombinerBufferInputData(pResAnim, dataHandle, pAnmData->ShaderAnimFrame ));
          }
          break;
        }
      }
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
bool H3dShaderModel::setConstantAnim( const gfl::grp::g3d::H3dResAnim* pResAnim, ShaderMaterialNumData* pMat, s32 frame, s32 materialNo )
{
  bool      fUpdate = false;
   
  for( s32 constantType = VecAnimDataType::Constant0; constantType < VecAnimDataType::ConstantNum; ++constantType )
  {
    if ( isVecHandleEnable( pMat, static_cast<VecAnimDataType::Enum>(constantType) ) )
    {
      //nw::ut::FloatColor      color = res_color.GetConstant0();
      //color = overWriteColorData( color, pResAnim, pMat, VecAnimDataType::Constant0, frame );
      //res_color.SetConstant0( color );
      //fUpdate = true;

      gfl::grp::ColorF32      color;
      GetMaterialColorConstant( materialNo, constantType, &color );
      color = overWriteColorData( color, pResAnim, pMat, static_cast<VecAnimDataType::Enum>(constantType), frame );
      SetMaterialColorConstant( materialNo, constantType, color );
    }
  }

  return fUpdate;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
s32 H3dShaderModel::getMaterialIndex( const char* pMaterialName )
{
  for( s32 i = 0; i < m_MaterialMax; ++i )
  {
    if ( pMaterialName == m_ppMaterialNames[i] )
      return i;//Ԃ|C^rłBʖڂȂ當r
  }
  
  return -1;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dShaderModel::resetHandle( ShaderAnimationData* pAnmData )
{
  ShaderMaterialNumData* pMat = pAnmData->pMaterialNumData;

  for( s32 i = 0; i < m_MaterialMax; ++i )
  {
    pMat[i].AlphaRefHandle = -1;
    pMat[i].CombinerKeyCnt = 0;
    
    for( s32 i2 = 0; i2 < VecAnimDataType::NumberOf; ++i2 )
    {
      for( s32 i3 = 0; i3 < 4; ++i3 )
      {
        pMat[i].VectorAnimHadles[ i2 ][i3] = -1;
      }
    }
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::g3d::H3dTextureCombinerExConst::Combine H3dShaderModel::getCombinerCombineData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame )
{
  gfl::grp::g3d::H3dTextureCombinerExConst::Combine      sampleTable[] = {
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_REPLACE,        //!< A ł
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_MODULATE,       //!< A * B łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_ADD,            //!< A + B łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_ADDSIGNED,      //!< A + B - 0.5 łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_INTERPOLATE,    //!< A * C + B * ( 1 - C ) łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_SUBTRACT,       //!< A - B łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_DOT3_RGB,       //!< RGB  Dot ( A , B ) łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_DOT3_RGBA,      //!< RGBA  Dot ( A , B ) łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_MULT_ADD,       //!< ( A * B ) + C łB
    gfl::grp::g3d::H3dTextureCombinerExConst::COMBINE_ADD_MULT        //!< ( A + B ) * C łB
  };
  
  f32     fValue;
  pResAnim->GetFloatValue( dataHandle, frame, &fValue );
  s32 value = static_cast<s32>( fValue );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::g3d::H3dTextureCombinerExConst::Scale H3dShaderModel::getCombinerScaleData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame )
{
  gfl::grp::g3d::H3dTextureCombinerExConst::Scale      sampleTable[] = {
    gfl::grp::g3d::H3dTextureCombinerExConst::SCALE_ONE,     //!< 1.0 {B
    gfl::grp::g3d::H3dTextureCombinerExConst::SCALE_TWO,     //!< 2.0 {B
    gfl::grp::g3d::H3dTextureCombinerExConst::SCALE_FOUR     //!< 4.0 {B
  };
  
  f32     fValue;
  pResAnim->GetFloatValue( dataHandle, frame, &fValue );
  s32 value = static_cast<s32>( fValue );
  //s32 value = static_cast<s32>( pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::g3d::H3dTextureCombinerExConst::OperandAlpha H3dShaderModel::getCombinerOperandAlphaData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame )
{
  gfl::grp::g3d::H3dTextureCombinerExConst::OperandAlpha      sampleTable[] = {
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_SRC_ALPHA,             //!< At@łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_SRC_ONE_MINUS_ALPHA, //!< 1 - At@łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_RED,                 //!< R łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_ONE_MINUS_RED,       //!< 1 - R łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_GREEN,               //!< G łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_ONE_MINUS_GREEN,     //!< 1 - G łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_BLUE,                //!< B łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDALPHA_ONE_MINUS_BLUE       //!< 1 - B łB
  };
  
  f32     fValue;
  pResAnim->GetFloatValue( dataHandle, frame, &fValue );
  s32 value = static_cast<s32>( fValue );
  //s32 value = static_cast<s32>( pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::ColorF32 H3dShaderModel::overWriteColorData( 
    gfl::grp::ColorF32 src, 
    const gfl::grp::g3d::H3dResAnim* pResAnim,
    ShaderMaterialNumData* pMat,
    VecAnimDataType::Enum type, s32 frame )
{
  s32     dataHandle;
  
  dataHandle = pMat->VectorAnimHadles[type].x;
  if( dataHandle != -1 )
  {
    pResAnim->GetFloatValue( dataHandle, frame, &src.r );
    //src.r = pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  dataHandle = pMat->VectorAnimHadles[type].y;
  if( dataHandle != -1 )
  {
    pResAnim->GetFloatValue( dataHandle, frame, &src.g );
    //src.g = pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  dataHandle = pMat->VectorAnimHadles[type].z;
  if( dataHandle != -1 )
  {
    pResAnim->GetFloatValue( dataHandle, frame, &src.b );
    //src.b = pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  dataHandle = pMat->VectorAnimHadles[type].w;
  if( dataHandle != -1 )
  {
    pResAnim->GetFloatValue( dataHandle, frame, &src.a );
    //src.a = pResAnim->GetFloatValue( dataHandle, frame );
  }
  
  return src;
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::g3d::H3dTextureCombinerExConst::Source H3dShaderModel::getCombinerSrcData( const gfl::grp::g3d::H3dResAnim* pResAnim, int dataHandle, int frame )
{
  gfl::grp::g3d::H3dTextureCombinerExConst::Source      sampleTable[] = {
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_TEXTURE0,                    //!< eNX` 0 łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_TEXTURE1,                    //!< eNX` 1 łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_TEXTURE2,                    //!< eNX` 2 łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_TEXTURE3,                    //!< eNX` 3 łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_CONSTANT,                    //!< RX^gJ[łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_PRIMARY_COLOR,               //!< _VF[_[̏o͌ʂłB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_FRAGMENT_PRIMARY_COLOR,      //!< vC}J[łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_FRAGMENT_SECONDARY_COLOR,    //!< ZJ_J[łB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_PREVIOUS,                    //!< Oȉo͌ʂłB
    gfl::grp::g3d::H3dTextureCombinerExConst::SOURCE_PREVIOUS_BUFFER              //!< Oĩobt@łB
  };
  
  f32     fValue;
  pResAnim->GetFloatValue( dataHandle, frame, &fValue );
  s32 value = static_cast<s32>( fValue );
  //s32 value = static_cast<s32>( pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::g3d::H3dTextureCombinerExConst::OperandRgb H3dShaderModel::getCombinerOperandRgbData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame )
{
  gfl::grp::g3d::H3dTextureCombinerExConst::OperandRgb      sampleTable[] = {
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_SRC_COLOR,               //!< RGB łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_ONE_MINUS_SRC_COLOR,   //!< 1 - RGB łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_SRC_ALPHA,             //!< At@łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_ONE_MINUS_SRC_ALPHA,   //!< 1 - At@łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_RED,                   //!< R łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_ONE_MINUS_RED,       //!< 1 - R łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_GREEN,                 //!< G łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_ONE_MINUS_GREEN,       //!< 1 - G łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_BLUE,                  //!< B łB
    gfl::grp::g3d::H3dTextureCombinerExConst::OPERANDRGB_ONE_MINUS_BLUE        //!< 1 - B łB
  };
  
  f32     fValue;
  pResAnim->GetFloatValue( dataHandle, frame, &fValue );
  s32 value = static_cast<s32>( fValue );
  //s32 value = static_cast<s32>( pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
gfl::grp::g3d::H3dFragmentShaderExConst::BufferInput H3dShaderModel::getCombinerBufferInputData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame )
{
  gfl::grp::g3d::H3dFragmentShaderExConst::BufferInput      sampleTable[] = {
    gfl::grp::g3d::H3dFragmentShaderExConst::BUFFERINPUT_PREVIOUS,          //Oȉo͌ʂłB
    gfl::grp::g3d::H3dFragmentShaderExConst::BUFFERINPUT_PREVIOUS_BUFFER,   //Oĩobt@łB
  };
  
  f32     fValue;
  pResAnim->GetFloatValue( dataHandle, frame, &fValue );
  s32 value = static_cast<s32>( fValue );
  //s32 value = static_cast<s32>( pResAnim->GetFloatValue( dataHandle, frame ) );
  
  return sampleTable[value];
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
inline bool H3dShaderModel::isVecHandleEnable( ShaderMaterialNumData* pMat, VecAnimDataType::Enum type )
{
  IntVec  &rHandle = pMat->VectorAnimHadles[type];

  for( int i = 0; i < 4; ++i )
  {
    if ( rHandle[i] != -1 )
      return true;
  }

  return false;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief \[Xf[^ݒ֐
 *
 * @param pData     Aj[V\[X
 * @param pAnmData  Aj[Vf[^i[
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::SetShaderAttributeAnimData( gfl::grp::g3d::H3dResAnim *pData ,ShaderAnimationData* pAnmData )
{
  ShaderMaterialNumData* pMat = pAnmData->pMaterialNumData;
  // f[^ݒ肷
  pAnmData->pResAnim = reinterpret_cast<gfl::grp::g3d::H3dResMaterialAnim*>( pData );

  // ONOUE_PRINT("Aj[VZbg[%x]\n",pAnmData->pResAnim);

  // nhZbg
  resetHandle( pAnmData );

  if ( pAnmData->pResAnim == NULL )    return;
  if ( pMat == NULL )    return;
  
  for( s32 matNo = 0; matNo < m_MaterialCount; ++matNo )
  {
    if ( m_ppMaterialNames[matNo] == NULL )
      continue;
    
    const char*   pMatName = m_ppMaterialNames[matNo];
    // ONOUE_PRINT("%s\n",pMatName);
    if( m_pOneMaterialName ) pMatName = m_pOneMaterialName;
    char          attrName[ ShaderAttributeNameMaxLen ];//̃obt@z镶͂ȂBGNX|[^[Ń`FbNĂB
    char          tempName[ ShaderAttributeNameMaxLen ];//̃obt@z镶͂ȂBGNX|[^[Ń`FbNĂB
    
    for( s32 type = 0; type < VecAnimDataType::NumberOf; ++type )
    {
      IntVec     &rHadle = pMat[ matNo ].VectorAnimHadles[type];
      
      if ( type >= VecAnimDataType::Constant0 && type <= VecAnimDataType::Constant5 )
      {
        static const char* attrTypeName[] = {
          "Constant0", "Constant1", "Constant2", "Constant3", "Constant4", "Constant5"
        };
        
        s32   index = type - VecAnimDataType::Constant0;
        
        sprintf( tempName, "%s.%s", pMatName, attrTypeName[index] );
      }
      
      for( s32 i = 0; i < 4; ++i )
      {
        static const char* elementName[] = {
          "x", "y", "z", "w"
        };
        
        sprintf( attrName, "%s.%s", tempName, elementName[i] );
        rHadle[i] = pAnmData->pResAnim->GetAnimElementIndex( attrName );
        ISHIGURO_PRINT( "attrName = %s : %d\n", attrName, rHadle[i] );
      }
    }
    
    for( s32 type = 0; type < FloatAnimDataType::NumberOf; ++type )
    {     
      if ( type == FloatAnimDataType::AlphaRef )
      {
        sprintf( attrName, "%s.AlphaRef", pMatName );
        pMat[matNo].AlphaRefHandle = pAnmData->pResAnim->GetAnimElementIndex( attrName );
      }
      else if ( type >= FloatAnimDataType::TextureCombinerRgb0_MathFormula && type <= FloatAnimDataType::TextureCombinerAlpha5_OutPutBuffer )
      {
        if ( pMat[matNo].CombinerKeyCnt < CombinerKeyMax )
        {
          static const char*	ElementName[] = { "MathFormula", "Scale", "InputSourceA", "InputSourceB", "InputSourceC", "OperandA", "OperandB", "OperandC", "OutPutBuffer" };
          static const char*	ColorName[CombinerColorType::NumberOf] = { "RGB", "Alpha" };
          s32                 colorType = ( type < FloatAnimDataType::TextureCombinerAlpha0_MathFormula ) ? CombinerColorType::RGB : CombinerColorType::A;
          s32                 convNo;
          s32                 elementType;
          float               value;

          convNo = type - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
          convNo %= CombinerStageNum;

          elementType = type - FloatAnimDataType::TextureCombinerRgb0_MathFormula;
          elementType /= CombinerStageNum;
          elementType = ( colorType == CombinerColorType::RGB ) ? elementType : elementType - CombinerElementNum;

          sprintf( attrName, "%s.Combiner%01d.%s.%s", pMatName, convNo, ColorName[colorType], ElementName[elementType] );

          s32     handle = pAnmData->pResAnim->GetAnimElementIndex( attrName );
          
          if ( handle != -1 )
          {
            s32 KeyCnt = pMat[matNo].CombinerKeyCnt;
            pMat[matNo].CombinerHandle[KeyCnt] = handle;
            pMat[matNo].CombinerHandleType[KeyCnt] = type;
            ++pMat[matNo].CombinerKeyCnt;
          }
        }
      }
    }
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[Aj[Vf[^i[̈쐬
 *
 * @param pAllocator            AP[^[
 * @param pShaderAnimationData  Aj[Vf[^
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::AllocShaderAnimation( 
    gfl::heap::NwAllocator* pAllocator,
    ShaderAnimationData*& pShaderAnimationData )
{
  gfl::heap::HeapBase* pHeap = pAllocator->GetHeapBase();
  
  // }eAɊ֘Af[^AP[g
  if( m_MaterialMax >  0 )
  {
    // AP[g
    pShaderAnimationData = GFL_NEW(pHeap) ShaderAnimationData;
    pShaderAnimationData->pMaterialNumData = 
      GFL_NEW_ARRAY(pHeap) ShaderMaterialNumData[m_MaterialMax];
    // NA
    ClearShaderAnimation( pShaderAnimationData );
  }
  else
  {
    GFL_ASSERT_MSG(0,"}eA񂪑݂Ȃf[^ɃAj[V𓖂Ă\n");
    // Createɂ̊֐Ăяo
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[Aj[Vf[^i[̈
 *
 * @param pShaderAnimationData  Aj[Vf[^
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::ClearShaderAnimation( ShaderAnimationData* pShaderAnimationData )
{
  if( pShaderAnimationData )
  {
    // NA
    for( int i = 0; i < m_MaterialMax; i++ )
    {
      pShaderAnimationData->ShaderAnimationLoop = false;
      pShaderAnimationData->ShaderAnimFrame     = 0;
      pShaderAnimationData->ShaderStepFrame     = 0;
      pShaderAnimationData->ShaderAnimEndFrame  = 0;
      gfl::std::MemClear( 
          &pShaderAnimationData->pMaterialNumData[i], 
          sizeof(ShaderMaterialNumData) );
    }
  }
  else
  {
    GFL_ASSERT_MSG(0,"NGCgĂȂ̈悤Ƃ");
  }
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[Aj[VLǂ`FbN
 *
 * @param SlotIndex XbgCfbNX
 *
 * @return true̎ɗL
 */
/* -------------------------------------------------------------------------*/
bool H3dShaderModel::IsEnableShaderAnimation( u32 SlotIndex ) const
{
  if( m_AnimationSlotNum > 0 )
  {
    // VF[_[Aj[Vf[^݂邩`FbN
    if( m_ppShaderAnimationData[SlotIndex] )
    {
      return true;
    }
  }
  return false;
}

/* -------------------------------------------------------------------------*/
/**
 * @brief VF[_[Aj[Ṽ}eAő吔ݒ肷
 *
 * @param material_max  }eA̍ő吔
 */
/* -------------------------------------------------------------------------*/
void H3dShaderModel::SetShaderAnimationMaterialMax( s32 material_max )
{
  m_MaterialMax = material_max;
}


//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dShaderModel::SetIDEdgeColor( s32 color, s32 materialNo )
{
  if ( materialNo == -1 )
  {
    for( s32 i = 0; i < this->GetMaterialCount(); ++i )
    {
      SetIDEdgeColor( color, i );
    }
  }
  else
  {
    //nw::gfx::Material                     *material = this->GetMaterial( materialNo );
    //nw::gfx::ResMaterial                  res_material = material->GetTextureMapperResMaterial();
    //nw::gfx::res::ResFragmentOperation    resOp = res_material.GetFragmentOperation();
    //nw::gfx::res::ResStencilOperation     stencilOp = resOp.GetStencilOperation();
    //stencilOp.SetTestReference( color );
    
    SetMaterialStencilOperationTestReference( materialNo, color );
  }
}

//-----------------------------------------------------------------------------
/// @brief
//-----------------------------------------------------------------------------
void H3dShaderModel::ShiftIDEdgeColor( s32 shift, s32 materialNo )
{
  if ( materialNo == -1 )
  {
    for( s32 i = 0; i < this->GetMaterialCount(); ++i )
    {
      ShiftIDEdgeColor( shift, i );
    }
  }
  else
  {
    gfl::grp::g3d::H3dUserData        user_data;
    s32     user_data_index = this->GetMaterialUserDataIndex( materialNo, "&EdgeID" );
    if ( user_data_index < 0 )
      return;
    this->GetMaterialUserData( materialNo, user_data_index, &user_data);

    s32     defaultColor = user_data.GetIntValue(0);

    SetIDEdgeColor( static_cast<u8>( defaultColor + shift ), materialNo );
  }
}

}  // namespace xy_system

