//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		H3dShaderModel.h
 *	@brief  VF[_[fNX
 *	@author	Masayuki Onoue
 *	@date		2012.06.13
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#if !defined( __H3dShaderModel_H__ )
#define __H3dShaderModel_H__

#include <gflib.h>

// NW4C
//#include <nw/gfx.h>
//#include <nw/gfx/gfx_Model.h>

#include <grp/g3d/gfl_G3dH3dModel.h>
#include <grp/g3d/gfl_G3dH3dResAnim.h>
#include <grp/g3d/gfl_G3dH3dResMaterialAnim.h>

#define DECLARE_ENUM_BEGIN( CLASSNAME )	\
	class CLASSNAME {											\
	public:																\
		enum Enum {
#define DECLARE_ENUM_END( CLASSNAME )		\
		};                                  \
	};

namespace xy_system {

class H3dShaderModel : public gfl::grp::g3d::H3dModel
{
public:
  struct Description {
    Description() : animation_slot_num(1){}
    s32     animation_slot_num;
  };
  //-------------------------------------------------------------------------------------------------------------------------------------------------
  //!  Aj[Vf[^^Cv
  DECLARE_ENUM_BEGIN( VecAnimDataType )
    Constant0 = 0,
    Constant1,
    Constant2,
    Constant3,
    Constant4,
    Constant5,
    NumberOf,

    ConstantNum = (Constant5 - Constant0) + 1
  DECLARE_ENUM_END( VecAnimDataType )    

  //-----------------------------------------------------------------------------
  //! Aj[Vf[^^Cv
  DECLARE_ENUM_BEGIN( FloatAnimDataType )
    AlphaRef = 0,

    TextureCombinerRgb0_MathFormula,
    TextureCombinerRgb1_MathFormula,
    TextureCombinerRgb2_MathFormula,
    TextureCombinerRgb3_MathFormula,
    TextureCombinerRgb4_MathFormula,
    TextureCombinerRgb5_MathFormula,

    TextureCombinerRgb0_Scale,
    TextureCombinerRgb1_Scale,
    TextureCombinerRgb2_Scale,
    TextureCombinerRgb3_Scale,
    TextureCombinerRgb4_Scale,
    TextureCombinerRgb5_Scale,

    TextureCombinerRgb0_InputSourceA,
    TextureCombinerRgb1_InputSourceA,
    TextureCombinerRgb2_InputSourceA,
    TextureCombinerRgb3_InputSourceA,
    TextureCombinerRgb4_InputSourceA,
    TextureCombinerRgb5_InputSourceA,

    TextureCombinerRgb0_InputSourceB,
    TextureCombinerRgb1_InputSourceB,
    TextureCombinerRgb2_InputSourceB,
    TextureCombinerRgb3_InputSourceB,
    TextureCombinerRgb4_InputSourceB,
    TextureCombinerRgb5_InputSourceB,

    TextureCombinerRgb0_InputSourceC,
    TextureCombinerRgb1_InputSourceC,
    TextureCombinerRgb2_InputSourceC,
    TextureCombinerRgb3_InputSourceC,
    TextureCombinerRgb4_InputSourceC,
    TextureCombinerRgb5_InputSourceC,

    TextureCombinerRgb0_OperandA,
    TextureCombinerRgb1_OperandA,
    TextureCombinerRgb2_OperandA,
    TextureCombinerRgb3_OperandA,
    TextureCombinerRgb4_OperandA,
    TextureCombinerRgb5_OperandA,

    TextureCombinerRgb0_OperandB,
    TextureCombinerRgb1_OperandB,
    TextureCombinerRgb2_OperandB,
    TextureCombinerRgb3_OperandB,
    TextureCombinerRgb4_OperandB,
    TextureCombinerRgb5_OperandB,

    TextureCombinerRgb0_OperandC,
    TextureCombinerRgb1_OperandC,
    TextureCombinerRgb2_OperandC,
    TextureCombinerRgb3_OperandC,
    TextureCombinerRgb4_OperandC,
    TextureCombinerRgb5_OperandC,

    TextureCombinerRgb0_OutPutBuffer,
    TextureCombinerRgb1_OutPutBuffer,
    TextureCombinerRgb2_OutPutBuffer,
    TextureCombinerRgb3_OutPutBuffer,
    TextureCombinerRgb4_OutPutBuffer,
    TextureCombinerRgb5_OutPutBuffer,

    TextureCombinerAlpha0_MathFormula,
    TextureCombinerAlpha1_MathFormula,
    TextureCombinerAlpha2_MathFormula,
    TextureCombinerAlpha3_MathFormula,
    TextureCombinerAlpha4_MathFormula,
    TextureCombinerAlpha5_MathFormula,

    TextureCombinerAlpha0_Scale,
    TextureCombinerAlpha1_Scale,
    TextureCombinerAlpha2_Scale,
    TextureCombinerAlpha3_Scale,
    TextureCombinerAlpha4_Scale,
    TextureCombinerAlpha5_Scale,

    TextureCombinerAlpha0_InputSourceA,
    TextureCombinerAlpha1_InputSourceA,
    TextureCombinerAlpha2_InputSourceA,
    TextureCombinerAlpha3_InputSourceA,
    TextureCombinerAlpha4_InputSourceA,
    TextureCombinerAlpha5_InputSourceA,

    TextureCombinerAlpha0_InputSourceB,
    TextureCombinerAlpha1_InputSourceB,
    TextureCombinerAlpha2_InputSourceB,
    TextureCombinerAlpha3_InputSourceB,
    TextureCombinerAlpha4_InputSourceB,
    TextureCombinerAlpha5_InputSourceB,

    TextureCombinerAlpha0_InputSourceC,
    TextureCombinerAlpha1_InputSourceC,
    TextureCombinerAlpha2_InputSourceC,
    TextureCombinerAlpha3_InputSourceC,
    TextureCombinerAlpha4_InputSourceC,
    TextureCombinerAlpha5_InputSourceC,

    TextureCombinerAlpha0_OperandA,
    TextureCombinerAlpha1_OperandA,
    TextureCombinerAlpha2_OperandA,
    TextureCombinerAlpha3_OperandA,
    TextureCombinerAlpha4_OperandA,
    TextureCombinerAlpha5_OperandA,

    TextureCombinerAlpha0_OperandB,
    TextureCombinerAlpha1_OperandB,
    TextureCombinerAlpha2_OperandB,
    TextureCombinerAlpha3_OperandB,
    TextureCombinerAlpha4_OperandB,
    TextureCombinerAlpha5_OperandB,

    TextureCombinerAlpha0_OperandC,
    TextureCombinerAlpha1_OperandC,
    TextureCombinerAlpha2_OperandC,
    TextureCombinerAlpha3_OperandC,
    TextureCombinerAlpha4_OperandC,
    TextureCombinerAlpha5_OperandC,

    TextureCombinerAlpha0_OutPutBuffer,
    TextureCombinerAlpha1_OutPutBuffer,
    TextureCombinerAlpha2_OutPutBuffer,
    TextureCombinerAlpha3_OutPutBuffer,
    TextureCombinerAlpha4_OutPutBuffer,
    TextureCombinerAlpha5_OutPutBuffer,

    NumberOf,

    CombinerAttrNum = (TextureCombinerAlpha5_OutPutBuffer - TextureCombinerRgb0_MathFormula) + 1

  DECLARE_ENUM_END( FloatAnimDataType )  

  //-------------------------------------------------------------------------------------------------------------------------------------------------
  //!  RoCi^Cv
  DECLARE_ENUM_BEGIN( CombinerColorType )
    RGB	= 0,
    A,
    NumberOf
  DECLARE_ENUM_END( CombinerColorType )

  //-------------------------------------------------------------------------------------------------------------------------------------------------
  //!  RoCivf^Cv
  DECLARE_ENUM_BEGIN( CombinerElementType )
    MathFormula = 0,
    Scale,
    InputSourceA,
    InputSourceB,
    InputSourceC,
    OperandA,
    OperandB,
    OperandC,
    OutPutBuffer,
    NumberOf
  DECLARE_ENUM_END( CombinerElementType )
  
protected:
  struct IntVec{
    union
    {
      struct
      {
        int		x;
        int		y;
        int		z;
        int		w;
      };

      struct
      {
        int		i[4];
      };

    };
    
    int& operator []( int index ){ return this->i[index]; }
    const int& operator []( int index ) const { return this->i[index]; }
  };

  //---------------------------
  /// NX萔
  enum{
    SLOT_INDEX_NONE = 0xFFF,  ///< Xbg̏
  };

  static const s32      DefaultMaterialMax = 48 + 1;              ///< p[eBN}eAPǉ
  static const s32      ShaderAttributeNameMaxLen = 256;  ///< lςƂ̓Ro[^[ς
  static const s32      CombinerKeyMax = 8;               ///< lςƂ̓Ro[^[ς
  static const s32      MAX_PATH = 4;
  static const int      CombinerStageNum = 6;
  static const int      ConstantMax = 6;
  static const int      CombinerElementNum = 9;
 
  //---------------------------
  /// ƎAj[VZbgAbv^Cv
  typedef enum{
    USER_FORMAT_TYPE_CSHADER = 0, ///< ƎtH[}bgFCSHADER
    USER_FORMAT_TYPE_CKEY    = 1,    ///< ƎtH[}bgFCKEY
  }USER_FORMAT_TYPE;

  //---------------------------
  /// }eAKvȃf[^
  struct ShaderMaterialNumData {
    IntVec                VectorAnimHadles[VecAnimDataType::NumberOf];
    s32                   AlphaRefHandle;
    s32                   CombinerHandle[CombinerKeyMax];
    s32                   CombinerHandleType[CombinerKeyMax];
    s32                   CombinerKeyCnt;
  };

  //---------------------------
  /// Aj[Vf[^
  struct ShaderAnimationData {
    ShaderMaterialNumData*  pMaterialNumData;  ///< }eAɊ֘AĂf[^
    const gfl::grp::g3d::H3dResMaterialAnim* pResAnim;     ///< Aj[V\[X|C^

    bool  ShaderAnimationLoop;        ///< Aj[Ṽ[v
    f32   ShaderStepFrame;            ///< XVt[
    f32   ShaderAnimFrame;            ///< Aj[Ṽt[
    f32   ShaderAnimEndFrame;         ///< It[
  };

protected:

  ShaderAnimationData** m_ppShaderAnimationData;  ///< VF[_[Aj[Vf[^z
  s32           m_MaterialCount;
  const char**  m_ppMaterialNames;

  const char* m_pOneMaterialName;  // }eAAj[Vt@Cɂ1̃}eA̖O

  u32   m_AnimationSlotNum;  ///< Aj[VXbg̐
  s32   m_MaterialMax;       ///< }eA̍ő吔
  u32   m_CreateSlotBit;

public:
  
  //---------------------------
  /// Aj[VZbgAbv^Cv
  typedef enum{
    ANIMATION_SETUP_TYPE_NORMAL,  ///< ʏtH[}bg
    ANIMATION_SETUP_TYPE_CSHADER, ///< ƎtH[}bgFCSHADER
    ANIMATION_SETUP_TYPE_CKEY,    ///< ƎtH[}bgFCKEY
    ANIMATION_SETUP_TYPE_MAX,
  }ANIMATION_SETUP_TYPE;
 
  //-----------------------------------------------------------------------------
  /*
   *  @brief         RXgN^
   *                 Create͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  H3dShaderModel(void);

  //-----------------------------------------------------------------------------
  /*
   *  @brief         fXgN^
   *                 DestroyĂт܂B
   */
  //-----------------------------------------------------------------------------
  virtual ~H3dShaderModel();
 
  //-----------------------------------------------------------------------------
  /*
   *  @brief         
   *
   *  @param[in]     allocator          AP[^
   *  @param[in]     device_allocator   foCX̃AP[^
   *  @param[in]     resource           \[X
   *  @param[in]     index_in_resource  \[XɂCfbNX
   *  @param[in]     description        ݒe
   */
  //-----------------------------------------------------------------------------
  virtual void Create(
      gfl::heap::NwAllocator*           allocator,
      gfl::heap::NwAllocator*           device_allocator,
      gfl::grp::g3d::H3dResource*       resource,
      s32                               index_in_resource,
      Description*                      description  = NULL
  );

  //-----------------------------------------------------------------------------
  /*
   *  @brief         Aj[VύX(\[X̎ނ𔻒fāACSHADERŃZbgAbv)
   *                 slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AΏۃXbgAnimation𐶐B
   *                 slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAΏۃXbgAnimation𐶐B
   *
   *  @param[in]     allocator               AP[^
   *  @param[in]     res_anim                Aj[V\[X(NULLnƑS(XP^A}eAArWreB)̃Aj[V܂)
   *  @param[in]     change_frame            t[ŕύX邩(̊ԃuh)
   *  @param[in]     slot_index              Aj[V蓖ĂXbg̃CfbNX
   *  @param[in]     max_anim_members        Aj[V郁o̍ő吔B(res_animNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOKA܂CSHADERɂ͖)
   *                                         slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AgpB
   *                                         slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAgpB
   *                                         Resource::Get???MemberAnimSetCountœlnƂ悢B
   *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRSTnƁA
   *                                         ŏChangeœnAj[V\[XGetMemberAnimSetCountgp܂B
   *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERSnƁA
   *                                         ŏChangeœnAj[V\[X̃Aj[VO[ṽoɁA
   *                                         ÃAj[V^Cvɂő吔ɂ܂B
   *  @param[in]     force                   IɃAj[V֘At܂B(res_animNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
   */
  //-----------------------------------------------------------------------------
    virtual void ChangeAnimation(
    gfl::heap::NwAllocator* allocator,
    gfl::grp::g3d::H3dResAnim* res_anim,
    u32                     change_frame = 0,
    u32                     slot_index = 0,
    s32                     max_anim_members = gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRST,
    bool                    force = false
  );

    // u}eAAj[Vt@Cɂ1̃}eAp̃Aj[Vvuf̑SẴ}eAvɓKp
    virtual void SetUseOneMaterialAnimation(
      const char*             one_material_name
    );

    //-----------------------------------------------------------------------------
    /*
     *  @brief         Aj[VύX
     *                 slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AΏۃXbgAnimation𐶐B
     *                 slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAΏۃXbgAnimation𐶐B
     *
     *  @param[in]     allocator               AP[^
     *  @param[in]     resource                \[X(NULLnƑS(XP^A}eAArWreB)̃Aj[V܂)
     *  @param[in]     animation_resource_type Aj[V\[X̃^Cv(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
     *  @param[in]     index_in_resource       \[XɂCfbNX(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
     *  @param[in]     change_frame            t[ŕύX邩(̊ԃuh)
     *  @param[in]     slot_index              Aj[V蓖ĂXbg̃CfbNX
     *  @param[in]     max_anim_members        Aj[V郁o̍ő吔B(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
     *                                         slot_indexŎw肵Xbgɑ΂ď߂Ă̊֐Ă񂾂Ƃ́AgpB
     *                                         slot_indexŎw肵Xbgɑ΂ď߂change_frame>0ł̊֐Ă񂾂ƂAgpB
     *                                         Resource::Get???MemberAnimSetCountœlnƂ悢B
     *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRSTnƁA
     *                                         ŏChangeœnAj[V\[XGetMemberAnimSetCountgp܂B
     *                                         gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_MAX_MEMBERSnƁA
     *                                         ŏChangeœnAj[V\[X̃Aj[VO[ṽoɁA
     *                                         ÃAj[V^Cvɂő吔ɂ܂B
     *  @param[in]     force                   IɃAj[V֘At܂B(resourceNULL̂Ƃ͎gpȂ̂łĂƁ[ȒlOK)
     */
    //-----------------------------------------------------------------------------
    virtual void ChangeAnimation(
        gfl::heap::NwAllocator*          allocator,
        gfl::grp::g3d::H3dResAnim*         resource,
        gfl::grp::g3d::Resource::AnimationResourceType  animation_resource_type,
        s32                              index_in_resource,
        u32                              change_frame = 0,
        u32                              slot_index = 0,
        s32                              max_anim_members = gfl::grp::g3d::ANIMATION_MAX_ANIM_MEMBERS_USE_FIRST,
        bool                             force = false
        );

    //-----------------------------------------------------------------------------
    /*
     *  @brief         vZ
     */
    //-----------------------------------------------------------------------------
    virtual void Calculate(void);

    /* -------------------------------------------------------------------------*/
    /**
     * @brief Aj[V̍XVt[ݒ肷
     *
     * @param frame       t[
     * @param slot_index  XbgCfbNX
     */
    /* -------------------------------------------------------------------------*/
    virtual void SetAnimationStepFrame(f32 frame, u32 slot_index = 0);

    /* -------------------------------------------------------------------------*/
    /**
     * @brief Aj[V̍XVt[擾
     *
     * @param slot_index  XbgCfbNX
     * @return Aj[Vt[
     */
    /* -------------------------------------------------------------------------*/
    virtual f32 GetAnimationStepFrame( u32 slot_index = 0) const;

    /* -------------------------------------------------------------------------*/
    /**
     * @brief Aj[V̍XVt[ݒ肷邷
     *
     * @param frame       t[
     * @param slot_index  XbgCfbNX
     */
    /* -------------------------------------------------------------------------*/
    virtual void SetAnimationFrame( f32 frame ,u32 slot_index = 0 );

    //-----------------------------------------------------------------------------
    /*
     *  @brief         Aj[V[vĐۂ擾
     *
     *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
     *
     *  @retval        bool            [v̂ƂtrueA[vłȂƂfalseԂ
     */
    //-----------------------------------------------------------------------------
    virtual bool IsAnimationLoop(u32 slot_index = 0) const;

    //-----------------------------------------------------------------------------
    /*
     *  @brief         Aj[VɃ[vĐݒ肷
     *
     *  @param[in]     loop            [v̂ƂtrueA[vłȂƂfalseݒ肷
     *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
     */
    //-----------------------------------------------------------------------------
    virtual void SetAnimationLoop(bool loop, u32 slot_index = 0);

    /* -------------------------------------------------------------------------*/
    /**
     * @brief Aj[V̍XVt[ݒ肷
     *
     * @param frame       t[
     * @param slot_index  XbgCfbNX
     * @return Aj[Vt[
     */
    /* -------------------------------------------------------------------------*/
    virtual f32 GetAnimationFrame( u32 slot_index = 0 ) const;

    //-----------------------------------------------------------------------------
    /*
     *  @brief         Aj[V݂̌̃t[It[ۂ肷
     *
     *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
     *
     *  @retval        bool    ݂̃t[It[̏ꍇtureԂ
     */
    //-----------------------------------------------------------------------------
    virtual bool IsAnimationFrameEndFrame( u32 slot_index = 0 ) const;

    //-----------------------------------------------------------------------------
    /*
     *  @brief         Aj[V̏It[擾
     *
     *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
     *
     *  @retval        t[
     */
    //-----------------------------------------------------------------------------
    virtual f32 GetAnimationEndFrame( u32 slot_index = 0 ) const;

    //-----------------------------------------------------------------------------
    /*
     *  @brief         Aj[V̏It[Zbg
     *
     *  @param[in]    frame            t[
     *  @param[in]    slot_index       Aj[V蓖ĂXbg̃CfbNX
     *
     *  @retval        none
     */
    //-----------------------------------------------------------------------------
    virtual void SetAnimationEndFrame( f32 frame, u32 slot_index = 0 );

    //-----------------------------------------------------------------------------
    /*
    *  @brief         Aj[V̊Jnt[ƏIt[ݒ肷
    *
    *  @param[in]     start_frame     Jnt[
    *  @param[in]     end_frame       It[
    *  @param[in]     slot_index      Aj[V蓖ĂXbg̃CfbNX
    */
    //-----------------------------------------------------------------------------
    virtual void SetAnimationStartAndEndFrame(f32 start_frame, f32 end_frame, u32 slot_index = 0);
    
    //-----------------------------------------------------------------------------
    /**
     * @brief VF[_[Agr[gAj[Vt[ݒ
   * @param frame t[
   */
  //-----------------------------------------------------------------------------
  void SetShaderAttributeAnimFrame( f32 frame );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief   Aj[VZbgAbv^Cv擾
   *
   * @param   ׂAj[V^Cv
   *
   * @return  Aj[ṼZbgAbv^Cv
   */
  /* -------------------------------------------------------------------------*/
  static H3dShaderModel::ANIMATION_SETUP_TYPE GetAnimationSetupType( const gfl::grp::g3d::H3dResAnim* res_anim );

  //-----------------------------------------------------------------------------
  /*
   *  @brief         j
   *                 ĂłvBfXgN^͌Ă΂܂B
   */
  //-----------------------------------------------------------------------------
  virtual void Destroy(void);

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[Aj[Ṽ}eAő吔ݒ肷
   *
   * @param material_max  }eA̍ő吔
   */
  /* -------------------------------------------------------------------------*/
  void SetShaderAnimationMaterialMax( s32 material_max );

  //-----------------------------------------------------------------------------
  /**
   * @brief hcGbWJ[w
   * @param color           J[l
   * @param materialNo      ݒ肷}eAԍ(-1̂Ƃ͓őS}eAɂȂēK)
   */
  //-----------------------------------------------------------------------------
  void SetIDEdgeColor( s32 color, s32 materialNo = -1 );
  
  //-----------------------------------------------------------------------------
  /**
   * @brief hcGbWJ[Vtg
   * @param color           J[l
   * @param materialNo      ݒ肷}eAԍ(-1̂Ƃ͓őS}eAɂȂēK)
   */
  //-----------------------------------------------------------------------------
  void ShiftIDEdgeColor( s32 shift, s32 materialNo = -1 );

protected:
  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  void resetHandle( ShaderAnimationData* pAnmData );

private:
  /* -------------------------------------------------------------------------*/
  /**
   * @brief Ɏ擾Kvȃp[^W߂
   */
  /* -------------------------------------------------------------------------*/
  void CreateParam( gfl::heap::HeapBase* pHeap ,Description* pDescription );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  bool setConstantAnim( const gfl::grp::g3d::H3dResAnim* pResAnim, ShaderMaterialNumData* pMat, s32 frame, s32 materialNo );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  s32 getMaterialIndex( const char* pMaterialName );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  inline bool isVecHandleEnable( ShaderMaterialNumData* pMat, VecAnimDataType::Enum type );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dTextureCombinerExConst::Combine getCombinerCombineData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dTextureCombinerExConst::Scale getCombinerScaleData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dTextureCombinerExConst::OperandAlpha getCombinerOperandAlphaData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::ColorF32 overWriteColorData( 
      gfl::grp::ColorF32 src, 
      const gfl::grp::g3d::H3dResAnim* pResAnim,
      ShaderMaterialNumData* pMat,
      VecAnimDataType::Enum type, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dTextureCombinerExConst::Source getCombinerSrcData( const gfl::grp::g3d::H3dResAnim* pResAnim, int dataHandle, int frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dTextureCombinerExConst::OperandRgb getCombinerOperandRgbData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame );

  //-----------------------------------------------------------------------------
  /// @brief
  //-----------------------------------------------------------------------------
  gfl::grp::g3d::H3dFragmentShaderExConst::BufferInput getCombinerBufferInputData( const gfl::grp::g3d::H3dResAnim* pResAnim, s32 dataHandle, s32 frame );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[̃p[^XbgɉăAbvf[g
   *
   * @param pAnmData  XVAj[Vf[^
   */
  /* -------------------------------------------------------------------------*/
  void UpdateShaderParam( ShaderAnimationData* pAnmData );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief \[Xf[^ݒ֐
   *
   * @param pData     Aj[V\[X
   * @param pAnmData  Aj[Vf[^i[
   */
  /* -------------------------------------------------------------------------*/
  void SetShaderAttributeAnimData( gfl::grp::g3d::H3dResAnim *pData ,ShaderAnimationData* pAnmData );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[Aj[Vf[^i[̈쐬
   *
   * @param pAllocator            AP[^[
   * @param pShaderAnimationData  Aj[Vf[^
   */
  /* -------------------------------------------------------------------------*/
  void AllocShaderAnimation( 
      gfl::heap::NwAllocator* pAllocator,
      ShaderAnimationData*& pShaderAnimationData );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[Aj[Vf[^i[̈
   *
   * @param pShaderAnimationData  Aj[Vf[^
   */
  /* -------------------------------------------------------------------------*/
  void ClearShaderAnimation( ShaderAnimationData* pShaderAnimationData );

  //-----------------------------------------------------------------------------
  /**
   * @brief ݂̃Aj[Vt[ɍ킹āAf[^XV
   * @param frame t[
   */
  //-----------------------------------------------------------------------------
  void UpdateShaderAttributeAnim( ShaderAnimationData* pAnmData );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[Aj[VLǂ`FbN
   *
   * @param SlotIndex XbgCfbNX
   *
   * @return true̎ɗL
   */
  /* -------------------------------------------------------------------------*/
  bool IsEnableShaderAnimation( u32 SlotIndex ) const;

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[f֘Ap[^
   */
  /* -------------------------------------------------------------------------*/
  void DestroyH3dShaderModelParam(void);

  /* -------------------------------------------------------------------------*/
  /**
   * @brief VF[_[Aj[Vݒ肷
   *
   * @param allocator         AP[^
   * @param res_anim          Aj\[X
   * @param change_frame      Nt[
   * @param slot_index        gpXbgԍ
   */
  /* -------------------------------------------------------------------------*/
  void ChangeShaderAnimation( 
      gfl::heap::NwAllocator* allocator,
      gfl::grp::g3d::H3dResAnim* res_anim,
      u32                     change_frame,
      u32                     slot_index );

  /* -------------------------------------------------------------------------*/
  /**
   * @brief Aj[Vp[^̉
   *
   * @param slot_index  XbgCfbNX
   */
  /* -------------------------------------------------------------------------*/
  void FreeH3dShaderModelParam( u32 slot_index );
  
  void createAnimationSlot( gfl::heap::NwAllocator* allocator, gfl::grp::g3d::H3dResAnim* res_anim, u32 slot_index);
};

}  // namespace xy_system

#endif		// __H3dShaderModel_H__
