//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_status_Touchbar.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.08.25
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_status_Touchbar.h"
#include "waza_pane.h"

namespace app {
namespace status {

/**
 * @brief ^b`o[ݒe[u
 */
static const app::ui::UITouchBarView::SETUP  setup[] =
{
  {
    app::ui::UITouchBarView::BUTTON_ID_EXIT,
    PANENAME_WAZA_PANE_EXIT_ICON_POS
  },
  {
    app::ui::UITouchBarView::BUTTON_ID_RETURN,
    PANENAME_WAZA_PANE_RETURN_ICON_POS
  },
  {
    app::ui::UITouchBarView::BUTTON_ID_PARAMS,
    PANENAME_WAZA_PANE_PARAMS_ICON_POS
  },
  {
    app::ui::UITouchBarView::BUTTON_ID_MEMO,
    PANENAME_WAZA_PANE_MEMO_ICON_POS
  },
};

/**
 * @brief RXgN^
 *
 * @param heap  q[v
 * @param graphic_system  OtBbNVXe
 * @param layout_system CAEgVXe
 * @param position_layout_work  CAEg[N
 * @param mode  [h
 */
Touchbar::Touchbar( app::util::Heap * heap, gfl::grp::GraphicsSystem* graphic_system, gfl::grp::g2d::LytSys* layout_system, gfl::grp::g2d::LytWk *position_layout_work ) :
  UITouchBarView( heap, graphic_system ),
  m_listener(NULL)
{
  this->Reload( heap, layout_system, position_layout_work, setup, GFL_NELEMS(setup) );
  this->UITouchBarView::SetInputListener( this );
}

/**
 * @brief fXgN^
 */
Touchbar::~Touchbar()
{
}

/**
 * @brief Xi[o^
 *
 * @param listener  Xi[
 */
void Touchbar::SetListener( TouchbarListener *listener )
{
  m_listener  = listener;
}

/**
 * @brief UITouchBarViewListener̎
 *
 * @param buttonID  {^ID
 *
 */
bool Touchbar::OnSelectedButton( u32 buttonID )
{
  if( m_listener )
  {
    switch( buttonID )
    {
    case app::ui::UITouchBarView::BUTTON_ID_EXIT:
      m_listener->OnSelectedReturnButton();
      return true;
    case app::ui::UITouchBarView::BUTTON_ID_RETURN:
      m_listener->OnSelectedExitButton();
      return true;
    case app::ui::UITouchBarView::BUTTON_ID_PARAMS:
      m_listener->OnSelectedParamsButton();
      return true;
    case app::ui::UITouchBarView::BUTTON_ID_MEMO:
      m_listener->OnSelectedMemoButton();
      return true;
    }
  }
  
  return false;
}

} // namespace status
} // namespace app
