//==============================================================================
/**
 * @file	battle_match_guide_view.cpp
 * @brief	ʃTur[@eڐ
 * @author	ichiraku_katsuhiko
 * @data	2012/08/25, 17:24
 */
// =============================================================================

#include "battle_match_guide_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "../battle_match_gra.h"
#include "../battle_match_gra_pane.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// RXgN^
GuideView::GuideView(	app::util::Heap * heap,
													app::util::G2DUtil* g2dUtil,
													app::util::G2DUtil::LAYOUT_WORK* lyt_wk ) :
	ViewBase( heap )
{
	// er[̃CAEgg
	Create2D( heap, g2dUtil->GetLayoutSystem(), LAYOUT_ID_MAX,
					  lyt_wk, LAYOUT_ID_MAX,
					  g2dUtil->GetMessageData(), g2dUtil->GetWordSet() );

}

// fXgN^
GuideView::~GuideView( void )
{
	Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void GuideView::Update( void )
{
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void GuideView::Draw( void )
{
  m_g2dUtil->Draw2D( GetSuperView()->GetGraphicSystem(), LAYOUT_ID_UPPER );
}

//--------------------------------------------------------------------------
/**
 * @brief KChbZ[Wݒ
 * @param msg_title		^Cg
 * @param msg_guide		
 */
//--------------------------------------------------------------------------
void GuideView::SetTextGuide( u32 msg_title, u32 msg_guide )
{
	SetTextboxPaneMessage( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_TEXT_01_00, msg_title );
	SetTextboxPaneMessage( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_TEXT_02_01, msg_guide );

	// \
	SetVisible( true );
}

//--------------------------------------------------------------------------
/**
 *  @brief \ɂ
 */
//--------------------------------------------------------------------------
void GuideView::VisibleOff( void )
{
	SetVisible( false );
}

//--------------------------------------------------------------------------
/**
 *  @brief \E\ݒ
 *  @param	is_visible	trueŕ\ falseŔ\
 */
//--------------------------------------------------------------------------
void GuideView::SetVisible( bool is_visible )
{
	GetG2DUtil()->SetPaneVisible( LAYOUT_ID_UPPER, PANENAME_BATTLEMATCH_UPPER_PANE_SELECT_BG_03, is_visible );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

