//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		EventFieldCaptureDemo.cpp
 *	@brief  tB[hLv`[f
 *	@author	Masayuki Onoue
 *	@date		2012.08.25
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "EventFieldCaptureDemo.h"

#include "arc/arc_def.h"
#include "arc/hideneffect.gaix"

namespace field{

#include "field/naminori.h"


//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
  //----------------------------------------------------------------------------
  /**
   *	@brief  f̏
   */
  //-----------------------------------------------------------------------------
  void EventFieldCaptureDemo::SetUp( const pml::pokepara::PokemonParam* cp_pokepara, int seq_no )
  {
    GFL_ASSERT_STOP( cp_pokepara );
    m_cpPokePara        = cp_pokepara;
    m_demo_seqfile_idx  = seq_no;
  }


  //--------------------------------------------------------------
  /**
   * @brief   Cxg𓮂Ă悢ǂ̔֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @retval  true  NĂ悢
   * @retval  false NȂ
   */
  //--------------------------------------------------------------
  bool EventFieldCaptureDemo::BootChk(gamesystem::GameManager* /*p_gman*/)
  {
    return true;
  }

  
  //--------------------------------------------------------------
  /**
   * @brief   bootchktruȅꍇɂĂяo鏉֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------
  void EventFieldCaptureDemo::InitFunc(gamesystem::GameManager* p_gman)
  {
    Fieldmap* p_fieldmap = p_gman->GetFieldmap();
    
    m_pGraphics = p_fieldmap->GetGraphics();
    gfl::fs::FileReadManager* p_readman = p_fieldmap->GetFileReadManager();

    // GtFNgp[^쐬
    FieldDemoPlayer::FieldDemoPlayerParam param;
    param.cp_pokepara   = m_cpPokePara;
    param.field_demo_no = m_demo_seqfile_idx;
    
    // GtFNgJnB
    m_Effect.Create( gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT ), 
        gfl::heap::Manager::GetHeapByHeapId( HEAPID_EVENT_DEVICE ),
        param, m_pGraphics ,p_readman );
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   * @return  GMEVENT_RESULT  Cxg֐̖߂l
   */
  //--------------------------------------------------------------
  gamesystem::GMEVENT_RESULT EventFieldCaptureDemo::MainFunc(gamesystem::GameManager* p_gman)
  {
    enum{
      SEQ_INIT,
      SEQ_CAPTURE,
      SEQ_CAPTURE_WAIT,
      SEQ_CONTINUE,
      SEQ_END,
    };

    switch( m_Seq ){
    case SEQ_INIT:
      {
        bool is_end;
        is_end = m_Effect.Initialize();
        if( !is_end ){
          break;
        }
      }
      ++m_Seq;
      break;

    case SEQ_CAPTURE:
      m_pGraphics->SetStop( true );
      ++m_Seq;
      break;
      
    case SEQ_CAPTURE_WAIT:
      if( !m_pGraphics->IsStop() ){
        break;
      }
      ++m_Seq;
      // break through 

    case SEQ_CONTINUE:
      {
        bool is_end;

        is_end = m_Effect.Update();
        if( !is_end ){
          break;
        }
      }
      ++m_Seq;
      // break through 
      
    case SEQ_END:
      m_Effect.Delete();
      m_pGraphics->SetStop( false );
      return gamesystem::GMEVENT_RES_FINISH;
    }

    return gamesystem::GMEVENT_RES_CONTINUE;
  }

  //--------------------------------------------------------------
  /**
   * @brief   Ăяo֐ z֐
   * @param   p_gman       Q[}l[W[NX
   */
  //--------------------------------------------------------------
  void EventFieldCaptureDemo::EndFunc(gamesystem::GameManager* /*p_gman*/)
  {
    m_pGraphics->SetStop( false );
    m_Effect.Delete();
  }



} // namespace field

