//==============================================================================
/**
 * @file	battle_match_yesno_view.cpp
 * @brief	ʃTur[@͂E
 * @author	ichiraku_katsuhiko
 * @data	2012/08/25, 12:21
 */
// =============================================================================


#include "battle_match_yesno_view.h"

// resource
#include <arc/arc_def.h>
#include <message/message.gaix>
#include <message/msg_battle_match.h>
#include "../battle_match_gra.h"
#include "../battle_match_gra_pane.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

//-----------------------------------------------------------------------------
/**
 *    ButtonManagerpBoundbox Xg`
 */
//-----------------------------------------------------------------------------
// yes no 
static const app::ui::ButtonInfo BUTTON_YESNO[] ={
  ///< {^1
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_01_01,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_01_01,			// bound_pane
    ANMID_LOWER_HOLD		+ 0,								// hold_anime_index
    ANMID_LOWER_RELEASE + 0,								// release_anime_index
    ANMID_LOWER_SELECT	+ 0,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 0,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 0,								// passive_anime_index
  },
  ///< ߂
  {
    PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_01_02,	// picture_pane
    PANENAME_BATTLEMATCH_LOWER_PANE_BOUND_01_02,			// bound_pane
    ANMID_LOWER_HOLD		+ 1,								// hold_anime_index
    ANMID_LOWER_RELEASE + 1,								// release_anime_index
    ANMID_LOWER_SELECT	+ 1,								// select_anime_index
    ANMID_LOWER_ACTIVE	+ 1,								// active_anime_index
    ANMID_LOWER_PASSIVE	+ 1,								// passive_anime_index
  },
};

// RXgN^
YesnoView::YesnoView(	app::util::Heap * heap,
													app::util::G2DUtil* g2dUtil,
													app::util::G2DUtil::LAYOUT_WORK* lyt_wk ) :
	ViewBase( heap ),
	m_uiListener( NULL )
{
	// er[̃CAEgg
	Create2D( heap, g2dUtil->GetLayoutSystem(), LAYOUT_ID_MAX,
					  lyt_wk, LAYOUT_ID_MAX,
					  g2dUtil->GetMessageData(), g2dUtil->GetWordSet() );
	
	SetInputListener( this );

	// {^}l[Wo^
	this->SetButtonManager();
}

// fXgN^
YesnoView::~YesnoView( void )
{
	Delete2D();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void YesnoView::Update( void )
{
  this->app::ui::UIView::Update();
}

//--------------------------------------------------------------------------
/**
 *  @brief `
 */
//--------------------------------------------------------------------------
void YesnoView::Draw( void )
{
  m_g2dUtil->Draw2D( GetSuperView()->GetGraphicSystem(), LAYOUT_ID_LOWER );
}

//--------------------------------------------------------------------------
/**
 * @brief		UICxgpXi̓o^
 */
//--------------------------------------------------------------------------
void YesnoView::SetBattleMatchUIListener( BattleMatchUIListener *listener )
{
	m_uiListener = listener;
}

//------------------------------------------------------------------
/**
* @brief   yCCxǧm
*
* @param  layoutId ʒm󂯂郌CAEghc
* @param  painId   ʒm󂯂yChc
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool YesnoView::OnLayoutPaneEvent( const u32 painId )
{
	if( m_uiListener == NULL ){
		GFL_PRINT("UIXi[o^ĂȂ\n");
		return true;
	}
	// Aj͑얳
	if( IsAnimeEnd() == false )
	{
		GFL_PRINT("AjEEE\n");
		return true;
	}

  switch( painId ){
		// SCENE_1_SELECT̂
		case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_01_01:
			ICHI_PRINT("{^1\n");
			m_uiListener->OnButtonAction( 0 );
			return false;
		case PANENAME_BATTLEMATCH_LOWER_PANE_SELECT_BAR_01_02:
			ICHI_PRINT("{^2\n");
			m_uiListener->OnReturnAction();		// ߂
			return false;
	}

	return true;
}

//------------------------------------------------------------------
/**
* @brief   L[͂̌m
*
* @param  pKey    \L[
* @param  pStick  AiOXeBbN
*
* @return t[ł̑̓CxgȂtrueA
*         ̃CxgrȂfalseԋp邱ƁB
*/
//------------------------------------------------------------------
// overwride
bool YesnoView::OnKeyAction( gfl::ui::Button* pKey, gfl::ui::VectorDevice* pStick)
{
	if( m_uiListener == NULL ){
		GFL_PRINT("UIXi[o^ĂȂ\n");
		return true;
	}
	// Aj͑얳
	if( IsAnimeEnd() == false )
	{
		GFL_PRINT("AjEEE\n");
		return true;
	}

	if( pKey->IsTrigger( gfl::ui::BUTTON_B ) ){
		ICHI_PRINT("B{^\n");
		m_uiListener->OnReturnAction();
		return false;
	}

  return true;
}


//--------------------------------------------------------------------------
/**
 * @brief	 ^Cg̕\
 * @param msg_id	\郁bZ[WID
 */
//--------------------------------------------------------------------------
void YesnoView::SetTextTitle( u32 msg_id )
{
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_00_00, msg_id );
}

//--------------------------------------------------------------------------
/**
 * @brief	 {^̕\
 * @param msg_id1		{^ɕ\郁bZ[WID
 * @param msg_id2		{^ɕ\郁bZ[WID
 */
//--------------------------------------------------------------------------
void YesnoView::SetTextButton( u32 msg_id1, u32 msg_id2 )
{
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_01_01, msg_id1 );
	SetTextboxPaneMessage( LAYOUT_ID_LOWER, PANENAME_BATTLEMATCH_LOWER_PANE_TEXT_01_02, msg_id2 );
}

//--------------------------------------------------------------------------
/**
 * @breif	 {^}l[WɃ{^ݒ肷
 */
//--------------------------------------------------------------------------
void YesnoView::SetButtonManager( void )
{
	const u32	paneNum = ( sizeof(BUTTON_YESNO) / sizeof(app::ui::ButtonInfo) );
	ReloadButtonManager( m_heap, GetLayoutWork( LAYOUT_ID_LOWER ), BUTTON_YESNO, paneNum );
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
