#ifndef __GFL_G3DH3DEX_H__
#define __GFL_G3DH3DEX_H__
//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		gfl_G3dH3dEx.h
 *	@brief  H3Dǉ
 *	@author	Koji Kawada
 *	@date		2012.08.24
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0

H3Dɒǉė~悤ȃNX܂B
#endif


// CTR_SDK

// NW4C
#include <nw/gfx.h>

// gflib
#include <gfl_Heap.h>
#include <gfl_Macros.h>
#include <gfl_fs.h>

// gflib grp
#include <grp/gfl_GraphicsType.h>

// gflib grp g3d
#include <grp/g3d/gfl_G3dDefine.h>



#if GFL_GRP_G3D_H3D_USE

// NW4C
#include <nw/h3d.h>
// gflib grp g3dh3d



namespace gfl {
namespace grp {
namespace g3d {

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	H3Dǉ萔NX
//=====================================
  
// TextureCombiner
struct H3dTextureCombinerExConst
{
  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum Combine
  {
    COMBINE_REPLACE      = PICA_DATA_TEX_ENV_COMBINE_REPLACE     ,    //!< A ł
    COMBINE_MODULATE     = PICA_DATA_TEX_ENV_COMBINE_MODULATE    ,    //!< A * B łB
    COMBINE_ADD          = PICA_DATA_TEX_ENV_COMBINE_ADD         ,    //!< A + B łB
    COMBINE_ADDSIGNED    = PICA_DATA_TEX_ENV_COMBINE_ADD_SIGNED  ,    //!< A + B - 0.5 łB
    COMBINE_INTERPOLATE  = PICA_DATA_TEX_ENV_COMBINE_INTERPOLATE ,    //!< A * C + B * ( 1 - C ) łB
    COMBINE_SUBTRACT     = PICA_DATA_TEX_ENV_COMBINE_SUBTRACT    ,    //!< A - B łB
    COMBINE_DOT3_RGB     = PICA_DATA_TEX_ENV_COMBINE_DOT3_RGB    ,    //!< RGB  Dot ( A , B ) łB
    COMBINE_DOT3_RGBA    = PICA_DATA_TEX_ENV_COMBINE_DOT3_RGBA   ,    //!< RGBA  Dot ( A , B ) łB
    COMBINE_MULT_ADD     = PICA_DATA_TEX_ENV_COMBINE_MULT_ADD_DMP,    //!< ( A * B ) + C łB
    COMBINE_ADD_MULT     = PICA_DATA_TEX_ENV_COMBINE_ADD_MULT_DMP     //!< ( A + B ) * C łB
  };

  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum Scale
  {
    SCALE_ONE   = PICA_DATA_TEX_ENV_SCALE_1,    //!< 1.0 {B
    SCALE_TWO   = PICA_DATA_TEX_ENV_SCALE_2,    //!< 2.0 {B
    SCALE_FOUR  = PICA_DATA_TEX_ENV_SCALE_4     //!< 4.0 {B
  };

  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum OperandRgb
  {
    OPERANDRGB_SRC_COLOR            = PICA_DATA_OPE_RGB_SRC_COLOR          ,     //!< RGB łB
    OPERANDRGB_ONE_MINUS_SRC_COLOR  = PICA_DATA_OPE_RGB_ONE_MINUS_SRC_COLOR,     //!< 1 - RGB łB
    OPERANDRGB_SRC_ALPHA            = PICA_DATA_OPE_RGB_SRC_ALPHA          ,     //!< At@łB
    OPERANDRGB_ONE_MINUS_SRC_ALPHA  = PICA_DATA_OPE_RGB_ONE_MINUS_SRC_ALPHA,     //!< 1 - At@łB
    OPERANDRGB_RED                  = PICA_DATA_OPE_RGB_SRC_R_DMP          ,     //!< R łB
    OPERANDRGB_ONE_MINUS_RED        = PICA_DATA_OPE_RGB_ONE_MINUS_SRC_R_DMP,     //!< 1 - R łB
    OPERANDRGB_GREEN                = PICA_DATA_OPE_RGB_SRC_G_DMP          ,     //!< G łB
    OPERANDRGB_ONE_MINUS_GREEN      = PICA_DATA_OPE_RGB_ONE_MINUS_SRC_G_DMP,     //!< 1 - G łB
    OPERANDRGB_BLUE                 = PICA_DATA_OPE_RGB_SRC_B_DMP          ,     //!< B łB
    OPERANDRGB_ONE_MINUS_BLUE       = PICA_DATA_OPE_RGB_ONE_MINUS_SRC_B_DMP      //!< 1 - B łB
  };

  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum OperandAlpha
  {
    OPERANDALPHA_SRC_ALPHA            = PICA_DATA_OPE_ALPHA_SRC_ALPHA          ,   //!< At@łB
    OPERANDALPHA_SRC_ONE_MINUS_ALPHA  = PICA_DATA_OPE_ALPHA_ONE_MINUS_SRC_ALPHA,   //!< 1 - At@ł 
    OPERANDALPHA_RED                  = PICA_DATA_OPE_ALPHA_SRC_R_DMP          ,   //!< R łB
    OPERANDALPHA_ONE_MINUS_RED        = PICA_DATA_OPE_ALPHA_ONE_MINUS_SRC_R_DMP,   //!< 1 - R łB
    OPERANDALPHA_GREEN                = PICA_DATA_OPE_ALPHA_SRC_G_DMP          ,   //!< G łB
    OPERANDALPHA_ONE_MINUS_GREEN      = PICA_DATA_OPE_ALPHA_ONE_MINUS_SRC_G_DMP,   //!< 1 - G łB
    OPERANDALPHA_BLUE                 = PICA_DATA_OPE_ALPHA_SRC_B_DMP          ,   //!< B łB
    OPERANDALPHA_ONE_MINUS_BLUE       = PICA_DATA_OPE_ALPHA_ONE_MINUS_SRC_B_DMP    //!< 1 - B łB
  };

  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum Source
  {
    SOURCE_TEXTURE0                  = PICA_DATA_TEX_ENV_SRC_RGBA_TEXTURE0                    ,    //!< eNX` 0 łB
    SOURCE_TEXTURE1                  = PICA_DATA_TEX_ENV_SRC_RGBA_TEXTURE1                    ,    //!< eNX` 1 łB
    SOURCE_TEXTURE2                  = PICA_DATA_TEX_ENV_SRC_RGBA_TEXTURE2                    ,    //!< eNX` 2 łB
    SOURCE_TEXTURE3                  = PICA_DATA_TEX_ENV_SRC_RGBA_TEXTURE3                    ,    //!< eNX` 3 łB
    SOURCE_CONSTANT                  = PICA_DATA_TEX_ENV_SRC_RGBA_CONSTANT                    ,    //!< RX^gJ[łB
    SOURCE_PRIMARY_COLOR             = PICA_DATA_TEX_ENV_SRC_RGBA_PRIMARY_COLOR               ,    //!< _VF[_[̏o͌ʂłB
    SOURCE_FRAGMENT_PRIMARY_COLOR    = PICA_DATA_TEX_ENV_SRC_RGBA_FRAGMENT_PRIMARY_COLOR_DMP  ,    //!< vC}J[łB
    SOURCE_FRAGMENT_SECONDARY_COLOR  = PICA_DATA_TEX_ENV_SRC_RGBA_FRAGMENT_SECONDARY_COLOR_DMP,    //!< ZJ_J[łB
    SOURCE_PREVIOUS                  = PICA_DATA_TEX_ENV_SRC_RGBA_PREVIOUS                    ,    //!< Oȉo͌ʂłB
    SOURCE_PREVIOUS_BUFFER           = PICA_DATA_TEX_ENV_SRC_RGBA_PREVIOUS_BUFFER_DMP              //!< Oĩobt@łB
  };

  enum
  {
    STEP_NUM    = 6,  // eNX`RoCi̒i
    SOURCE_NUM  = 3   // eNX`RoCi1iɂ\[X
  };
};

// FragmentShader
struct H3dFragmentShaderExConst
{
  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum BufferInput
  {
    BUFFERINPUT_PREVIOUS_BUFFER  = PICA_DATA_TEX_ENV_BUFFER_INPUT_PREVIOUS_BUFFER_DMP,   //!< Oĩobt@łB
    BUFFERINPUT_PREVIOUS         = PICA_DATA_TEX_ENV_BUFFER_INPUT_PREVIOUS               //!< Oȉo͌ʂłB
  };
};

// StencilOperation
struct H3dStencilOperationExConst
{
  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum TestFunc
  {
    TESTFUNC_NEVER     = PICA_DATA_STENCIL_TEST_NEVER   ,  //!< ׂĕsʉ߂łB 
    TESTFUNC_ALWAYS    = PICA_DATA_STENCIL_TEST_ALWAYS  ,  //!< ׂĒʉ߂łB 
    TESTFUNC_EQUAL     = PICA_DATA_STENCIL_TEST_EQUAL   ,  //!< QƒlƓΒʉ߂܂B 
    TESTFUNC_NOTEQUAL  = PICA_DATA_STENCIL_TEST_NOTEQUAL,  //!< QƒlƓȂΒʉ߂܂B 
    TESTFUNC_LESS      = PICA_DATA_STENCIL_TEST_LESS    ,  //!< Qƒl菬Βʉ߂܂B 
    TESTFUNC_LEQUAL    = PICA_DATA_STENCIL_TEST_LEQUAL  ,  //!< QƒlȉłΒʉ߂܂B 
    TESTFUNC_GREATER   = PICA_DATA_STENCIL_TEST_GREATER ,  //!< Qƒl傫Βʉ߂܂B 
    TESTFUNC_GEQUAL    = PICA_DATA_STENCIL_TEST_GEQUAL  ,  //!< QƒlȏłΒʉ߂܂B 
  };

  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum StencilOp
  {
    STENCILOP_KEEP           = PICA_DATA_STENCIL_OP_KEEP     ,   //!< ݂̒lێ܂B 
    STENCILOP_ZERO           = PICA_DATA_STENCIL_OP_ZERO     ,   //!< 0 ɒu܂B 
    STENCILOP_REPLACE        = PICA_DATA_STENCIL_OP_REPLACE  ,   //!< Qƒlɒu܂B 
    STENCILOP_INCREASE       = PICA_DATA_STENCIL_OP_INCR     ,   //!< ܂Bɒl̓NvłB 
    STENCILOP_DECREASE       = PICA_DATA_STENCIL_OP_DECR     ,   //!< ܂Bɒl̓NvłB 
    STENCILOP_INVERT         = PICA_DATA_STENCIL_OP_INVERT   ,   //!< rbgPʂŔ]܂B 
    STENCILOP_INCREASE_WRAP  = PICA_DATA_STENCIL_OP_INCR_WRAP,   //!< ܂Bɒl͉荞݂łB 
    STENCILOP_DECREASE_WRAP  = PICA_DATA_STENCIL_OP_DECR_WRAP,   //!< ܂Bɒl͉荞݂łB 
  };
};

// AlphaTest
struct H3dAlphaTestExConst
{
  // PICAR}hɂ̂܂܎gpĂ̂ŒlςȂ悤ɁB
  enum TestFunc
  {
    TESTFUNC_NEVER     = PICA_DATA_ALPHA_TEST_NEVER   ,  //!< ׂĕsʉ߂łB 
    TESTFUNC_ALWAYS    = PICA_DATA_ALPHA_TEST_ALWAYS  ,  //!< ׂĒʉ߂łB 
    TESTFUNC_EQUAL     = PICA_DATA_ALPHA_TEST_EQUAL   ,  //!< QƒlƓΒʉ߂܂B 
    TESTFUNC_NOTEQUAL  = PICA_DATA_ALPHA_TEST_NOTEQUAL,  //!< QƒlƓȂΒʉ߂܂B 
    TESTFUNC_LESS      = PICA_DATA_ALPHA_TEST_LESS    ,  //!< Qƒl菬Βʉ߂܂B 
    TESTFUNC_LEQUAL    = PICA_DATA_ALPHA_TEST_LEQUAL  ,  //!< QƒlȉłΒʉ߂܂B 
    TESTFUNC_GREATER   = PICA_DATA_ALPHA_TEST_GREATER ,  //!< Qƒl傫Βʉ߂܂B 
    TESTFUNC_GEQUAL    = PICA_DATA_ALPHA_TEST_GEQUAL  ,  //!< QƒlȏłΒʉ߂܂B 
  };
};




//-------------------------------------
///	H3D}eAǉXe[gNX
//=====================================
class H3dMaterialExState
{
  GFL_FORBID_COPY_AND_ASSIGN(H3dMaterialExState);


  friend class H3dModel;
  friend class H3dCommandListenerReadMaterial;


private:  // friendɂ͌JĂJo

  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // RXgN^ / fXgN^
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  H3dMaterialExState(void);
  // nw::h3d::MaterialStateQlɂĂ̂ŃfXgN^ȂB


  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // 
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  void Initialize(const nw::h3d::res::MaterialContent* cont); 


  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // TextureCombiner
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
 
  // stepi
  void InitializeTextureCombinerCombineRgb(s32 step, H3dTextureCombinerExConst::Combine combine);
  void SetTextureCombinerCombineRgb(s32 step, H3dTextureCombinerExConst::Combine combine);
  H3dTextureCombinerExConst::Combine  GetTextureCombinerCombineRgb(s32 step);

  // stepi
  void InitializeTextureCombinerCombineAlpha(s32 step, H3dTextureCombinerExConst::Combine combine);
  void SetTextureCombinerCombineAlpha(s32 step, H3dTextureCombinerExConst::Combine combine);
  H3dTextureCombinerExConst::Combine  GetTextureCombinerCombineAlpha(s32 step);



  // stepi
  void InitializeTextureCombinerScaleRgb(s32 step, H3dTextureCombinerExConst::Scale scale);
  void SetTextureCombinerScaleRgb(s32 step, H3dTextureCombinerExConst::Scale scale);
  H3dTextureCombinerExConst::Scale  GetTextureCombinerScaleRgb(s32 step);
  
  // stepi
  void InitializeTextureCombinerScaleAlpha(s32 step, H3dTextureCombinerExConst::Scale scale);
  void SetTextureCombinerScaleAlpha(s32 step, H3dTextureCombinerExConst::Scale scale);
  H3dTextureCombinerExConst::Scale  GetTextureCombinerScaleAlpha(s32 step);



  // stepi
  // no \[Xno  A:\[X0  B:\[X1  C:\[X2
  void InitializeTextureCombinerOperandRgb(s32 step, s32 no, H3dTextureCombinerExConst::OperandRgb ope);
  void SetTextureCombinerOperandRgb(s32 step, s32 no, H3dTextureCombinerExConst::OperandRgb ope);
  H3dTextureCombinerExConst::OperandRgb  GetTextureCombinerOperandRgb(s32 step, s32 no);
  
  // stepi
  // no \[Xno  A:\[X0  B:\[X1  C:\[X2
  void InitializeTextureCombinerOperandAlpha(s32 step, s32 no, H3dTextureCombinerExConst::OperandAlpha ope);
  void SetTextureCombinerOperandAlpha(s32 step, s32 no, H3dTextureCombinerExConst::OperandAlpha ope);
  H3dTextureCombinerExConst::OperandAlpha  GetTextureCombinerOperandAlpha(s32 step, s32 no);



  // stepi
  // no \[Xno  A:\[X0  B:\[X1  C:\[X2
  void InitializeTextureCombinerSourceRgb(s32 step, s32 no, H3dTextureCombinerExConst::Source source);
  void SetTextureCombinerSourceRgb(s32 step, s32 no, H3dTextureCombinerExConst::Source source);
  H3dTextureCombinerExConst::Source  GetTextureCombinerSourceRgb(s32 step, s32 no);
  
  // stepi
  // no \[Xno  A:\[X0  B:\[X1  C:\[X2
  void InitializeTextureCombinerSourceAlpha(s32 step, s32 no, H3dTextureCombinerExConst::Source source);
  void SetTextureCombinerSourceAlpha(s32 step, s32 no, H3dTextureCombinerExConst::Source source);
  H3dTextureCombinerExConst::Source  GetTextureCombinerSourceAlpha(s32 step, s32 no);



  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // FragmentShader
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////

  // stepiڂ͑Oỉg(stepiڂ͌iɉnł͂Ȃ̂Œӂ邱)
  void InitializeFragmentShaderBufferInputRgb(s32 step, H3dFragmentShaderExConst::BufferInput input);
  void SetFragmentShaderBufferInputRgb(s32 step, H3dFragmentShaderExConst::BufferInput input);
  H3dFragmentShaderExConst::BufferInput  GetFragmentShaderBufferInputRgb(s32 step);

  // stepiڂ͑Oỉg(stepiڂ͌iɉnł͂Ȃ̂Œӂ邱)
  void InitializeFragmentShaderBufferInputAlpha(s32 step, H3dFragmentShaderExConst::BufferInput input);
  void SetFragmentShaderBufferInputAlpha(s32 step, H3dFragmentShaderExConst::BufferInput input);
  H3dFragmentShaderExConst::BufferInput  GetFragmentShaderBufferInputAlpha(s32 step);




  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // StencilOperation
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  void InitializeStencilOperationTest(u8 enable, H3dStencilOperationExConst::TestFunc func_func, u8 mask, u8 func_ref, u8 func_mask);
  void InitializeStencilOperationOp(
      H3dStencilOperationExConst::StencilOp op_fail, H3dStencilOperationExConst::StencilOp op_zfail, H3dStencilOperationExConst::StencilOp op_zpass);
  void SetStencilOperationTestFuncRef(u8 func_ref);
  u8 GetStencilOperationTestFuncRef(void) const;

  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // AlphaTest
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  void InitializeAlphaTest(u8 enable, H3dAlphaTestExConst::TestFunc func, u8 ref);
  void SetAlphaTestRef(u8 ref);
  u8 GetAlphaTestRef(void) const;



  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  //
  // R}h
  //
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////////////////////////

  void MakeMutableCommand(H3dCommand* command) const;



private:  // friendɂJȂJo

  // @brief  eNX`RoCi1\[X̏
  struct TextureCombinerSource
  {
    enum
    {
      TEXTURE_COMBINER_OPERAND_RGB_MUTABLE    = 1 <<  0,
      TEXTURE_COMBINER_OPERAND_ALPHA_MUTABLE  = 1 <<  1,
      TEXTURE_COMBINER_SOURCE_RGB_MUTABLE     = 1 <<  2,
      TEXTURE_COMBINER_SOURCE_ALPHA_MUTABLE   = 1 <<  3
    };
    bit32 bitflag;  // ύX̂̃rbg𗧂Ă

    //H3dTextureCombinerExConst::OperandRgb    operand_rgb;
    //H3dTextureCombinerExConst::OperandAlpha  operand_alpha;
    //H3dTextureCombinerExConst::Source        source_rgb;
    //H3dTextureCombinerExConst::Source        source_alpha;

    u8  operand_rgb;
    u8  operand_alpha;
    u8  source_rgb;
    u8  source_alpha;
  };
 
  // @brief  eNX`RoCi1ȉ
  struct TextureCombinerStep
  {
    enum
    {
      TEXTURE_COMBINER_COMBINE_RGB_MUTABLE        = 1 <<  0,
      TEXTURE_COMBINER_COMBINE_ALPHA_MUTABLE      = 1 <<  1,
      TEXTURE_COMBINER_SCALE_RGB_MUTABLE          = 1 <<  2,
      TEXTURE_COMBINER_SCALE_ALPHA_MUTABLE        = 1 <<  3,
      FRAGMENT_SHADER_BUFFER_INPUT_RGB_MUTABLE    = 1 <<  4,
      FRAGMENT_SHADER_BUFFER_INPUT_ALPHA_MUTABLE  = 1 <<  5
    };
    bit32 bitflag;  // ύX̂̃rbg𗧂Ă

    //H3dTextureCombinerExConst::Combine  combine_rgb;
    //H3dTextureCombinerExConst::Combine  combine_alpha;
    //H3dTextureCombinerExConst::Scale    scale_rgb;
    //H3dTextureCombinerExConst::Scale    scale_alpha;

    u8  combine_rgb;
    u8  combine_alpha;
    u8  scale_rgb;
    u8  scale_alpha;
    
    TextureCombinerSource  source[H3dTextureCombinerExConst::SOURCE_NUM];
    
    //H3dFragmentShaderExConst::BufferInput  buffer_input_rgb;
    //H3dFragmentShaderExConst::BufferInput  buffer_input_alpha;

    u8  buffer_input_rgb;
    u8  buffer_input_alpha;
  };
  
  // @brief  XeVIy[V̏
  struct StencilOperationInfo
  {
    enum
    {
      STENCIL_TEST_MUTABLE    = 1 <<  0,
      STENCIL_OP_MUTABLE      = 1 <<  1,
    };
    bit32 bitflag;  // ύX̂̃rbg𗧂Ă

    u8 enable;
    u8 func_func;
    u8 mask;
    u8 func_ref;
    u8 func_mask;
    u8 op_fail;
    u8 op_zfail;
    u8 op_zpass;

#if 0

CTR
DMPGL2.0VXeAPIdl

glDisable(GL_STENCIL_TEST)A
glEnable(GL_STENCIL_TEST)
glStencilFuncfunc
glStencilMask
glStencilFuncref
glStencilFuncmask
glStencilOpfail
glStencilOpzfail
glStencilOpzpass

#endif

  };

  // @brief  At@eXg̏
  struct AlphaTestInfo
  {
    enum
    {
      ALPHA_TEST_MUTABLE     = 1 <<  0,
    };
    bit32 bitflag;  // ύX̂̃rbg𗧂Ă

    u8 enable;
    u8 func;
    u8 ref;
  };

private:  // friendɂJȂJo
  TextureCombinerStep  m_tex_comb_step[H3dTextureCombinerExConst::STEP_NUM];
  StencilOperationInfo m_stencil_op_info;
  AlphaTestInfo        m_alpha_test_info;
};


}  // namespace g3d
}  // namespace grp
}  // namespace gfl



#endif  // GFL_GRP_G3D_H3D_USE



#endif // __GFL_G3DH3DEX_H__

