#pragma once
#if !defined( __GFL_G3DH3DCOMMANDUTIL_H__ )
#define __GFL_G3DH3DCOMMANDUTIL_H__

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		gfl_G3dH3dCommandUtil.h
 *	@brief  H3D[eBeB
 *	@author	Koji Kawada
 *	@date		2012.07.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#if 0

̓R}hɓH3dUtilłB
#endif


// CTR_SDK

// NW4C
#include <nw/gfx.h>

// gflib grp g3d
#include <grp/g3d/gfl_G3dDefine.h>


#if GFL_GRP_G3D_H3D_USE

// NW4C
#include <nw/h3d.h>
// gflib grp g3dh3d



namespace gfl {
namespace grp {
namespace g3d {


//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-------------------------------------
///	H3DR}hXi[
//=====================================
class H3dCommandListener
{
  GFL_FORBID_COPY_AND_ASSIGN(H3dCommandListener);
public:
  enum Access 
  {
    SINGLE_ACCESS,
    BURST_ACCESS
  };
public:
  H3dCommandListener(void) {}
  virtual ~H3dCommandListener() {}
public:
  virtual void OnReadHeader(u32 index, bit32 command, u32 addr, u32 be, u32 size, u32 seq, Access access) {}
  virtual void OnReadData(u32 index, bit32 command, u32 addr, u32 mask, u32 count, u32 count_max, Access access) {}
  virtual void OnReadIgnore(u32 index, bit32 command) {}
  virtual void OnReadError(u32 index, bit32 command) {}
};

class H3dCommandListenerDump : public H3dCommandListener
{
  GFL_FORBID_COPY_AND_ASSIGN(H3dCommandListenerDump);
public:
  static const char* STR_SINGLE_ACCESS;
  static const char* STR_BURST_ACCESS;
public:
  H3dCommandListenerDump(void) {}
  virtual ~H3dCommandListenerDump() {}
public:
  virtual void OnReadHeader(u32 index, bit32 command, u32 addr, u32 be, u32 size, u32 seq, Access access)
  {
    GFL_PRINT("[%2d](0x%X) [HEADER] %s ADDR=0x%X, BE=0x%X, SIZE=%d, SEQ=%d\n", index, command,
        (access==SINGLE_ACCESS)?STR_SINGLE_ACCESS:STR_BURST_ACCESS,
        addr, be, size, seq);
  }
  virtual void OnReadData(u32 index, bit32 command, u32 addr, u32 mask, u32 count, u32 count_max, Access access)
  {
    GFL_PRINT("[%2d](0x%X) [DATA] %s ADDR=0x%X, MASK=0x%X, count=%d/%d\n", index, command,
        (access==SINGLE_ACCESS)?STR_SINGLE_ACCESS:STR_BURST_ACCESS,
        addr, mask, count, count_max);
  }
  virtual void OnReadIgnore(u32 index, bit32 command)
  {
    GFL_PRINT("[%2d](0x%X) [IGNORE]\n", index, command);
  }
  virtual void OnReadError(u32 index, bit32 command)
  {
    GFL_PRINT("[%2d](0x%X) [ERROR]\n", index, command);
  }
};
const char* H3dCommandListenerDump::STR_SINGLE_ACCESS = "SINGLE_ACCESS";
const char* H3dCommandListenerDump::STR_BURST_ACCESS  = "BURST_ACCESS";


//-------------------------------------
///	H3DR}h[eBeB
//=====================================
class H3dCommandUtil
{
  GFL_FORBID_COPY_AND_ASSIGN(H3dCommandUtil);

public:
  // @brief  RXgN^
  H3dCommandUtil(void) {}
  // @brief  fXgN^
  virtual ~H3dCommandUtil() {}

public:
  // @brief  WX^
  static inline u32 GetTextureCombinerCombineRegister(s32 step)
  {
    static const u32 REG[6] =
    {
      PICA_REG_TEX_ENV0_COMBINE,
      PICA_REG_TEX_ENV1_COMBINE,
      PICA_REG_TEX_ENV2_COMBINE,
      PICA_REG_TEX_ENV3_COMBINE,
      PICA_REG_TEX_ENV4_COMBINE,
      PICA_REG_TEX_ENV5_COMBINE,
    };
    return REG[step];
  }
  static inline u32 GetTextureCombinerScaleRegister(s32 step)
  {
    static const u32 REG[6] =
    {
      PICA_REG_TEX_ENV0_SCALE,
      PICA_REG_TEX_ENV1_SCALE,
      PICA_REG_TEX_ENV2_SCALE,
      PICA_REG_TEX_ENV3_SCALE,
      PICA_REG_TEX_ENV4_SCALE,
      PICA_REG_TEX_ENV5_SCALE,
    };
    return REG[step];
  }
  static inline u32 GetTextureCombinerOperandRegister(s32 step)
  {
    static const u32 REG[6] =
    {
      PICA_REG_TEX_ENV0_OPERAND,
      PICA_REG_TEX_ENV1_OPERAND,
      PICA_REG_TEX_ENV2_OPERAND,
      PICA_REG_TEX_ENV3_OPERAND,
      PICA_REG_TEX_ENV4_OPERAND,
      PICA_REG_TEX_ENV5_OPERAND,
    };
    return REG[step];
  }
  static inline u32 GetTextureCombinerSourceRegister(s32 step)
  {
    static const u32 REG[6] =
    {
      PICA_REG_TEX_ENV0,
      PICA_REG_TEX_ENV1,
      PICA_REG_TEX_ENV2,
      PICA_REG_TEX_ENV3,
      PICA_REG_TEX_ENV4,
      PICA_REG_TEX_ENV5,
    };
    return REG[step];
  }

  // @brief  R}h
  static inline bit32* MakeTextureCombinerCombineRgbCommand(bit32* cmd, s32 step, PicaDataTexEnvCombine combine)
  {
    // NintendoWare/CTR/include/nw/h3d/fnd/h3d_Util.h
    // static NW_INLINE bit32*
    //     MakeCombinerConstantCommand(bit32* cmd, u16 headRegister, ut::Color8 color)

    // @todo R}h𕪂ƁAAhXɑ΂2R}h𔭍s邱ƂɂȂĂ܂BȂقB
    static const u32 BE = 0x3;  // 0011
    *cmd++ = PICA_CMD_DATA_TEX_ENV_COMBINE(combine, 0);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( GetTextureCombinerCombineRegister(step), BE );
    return cmd;
  }
  static inline bit32* MakeTextureCombinerCombineAlphaCommand(bit32* cmd, s32 step, PicaDataTexEnvCombine combine)
  {
    // @todo R}h𕪂ƁAAhXɑ΂2R}h𔭍s邱ƂɂȂĂ܂BȂقB
    static const u32 BE = 0xC;  // 1100
    *cmd++ = PICA_CMD_DATA_TEX_ENV_COMBINE(0, combine);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( GetTextureCombinerCombineRegister(step), BE );
    return cmd;
  }
  static inline bit32* MakeTextureCombinerScaleRgbCommand(bit32* cmd, s32 step, PicaDataTexEnvScale scale)
  {
    // @todo R}h𕪂ƁAAhXɑ΂2R}h𔭍s邱ƂɂȂĂ܂BȂقB
    static const u32 BE = 0x3;  // 0011
    *cmd++ = PICA_CMD_DATA_TEX_ENV_SCALE(scale, 0);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( GetTextureCombinerScaleRegister(step), BE );
    return cmd;
  }
  static inline bit32* MakeTextureCombinerScaleAlphaCommand(bit32* cmd, s32 step, PicaDataTexEnvScale scale)
  {
    // @todo R}h𕪂ƁAAhXɑ΂2R}h𔭍s邱ƂɂȂĂ܂BȂقB
    static const u32 BE = 0xC;  // 1100
    *cmd++ = PICA_CMD_DATA_TEX_ENV_SCALE(0, scale);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( GetTextureCombinerScaleRegister(step), BE );
    return cmd;
  }
  static inline bit32* MakeTextureCombinerOperandCommand(bit32* cmd, s32 step,
      PicaDataTexEnvOperand ope_rgb[3], PicaDataTexEnvOperand ope_alpha[3])
  {
    static const u32 BE = 0x7;  // 0111  // urgb0&rgb1vƁurgb2&alpha0vƁualpha1&alpha2vɕ邱Ƃł邪ASЂƂ܂Ƃ߂ɂB
    *cmd++ = PICA_CMD_DATA_TEX_ENV_OPERAND( \
        ope_rgb[0],   ope_rgb[1],   ope_rgb[2],  \
        ope_alpha[0], ope_alpha[1], ope_alpha[2] \
    );
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( GetTextureCombinerOperandRegister(step), BE );
    return cmd;
  }
  static inline bit32* MakeTextureCombinerSourceCommand(bit32* cmd, s32 step,
      PicaDataTexEnvSrc source_rgb[3], PicaDataTexEnvSrc source_alpha[3])
  {
    static const u32 BE = 0xF;  // 1111  // urgb0&rgb1vƁurgb2vƁualpha0&alpha1vƁualpha2vɕ邱Ƃł邪ASЂƂ܂Ƃ߂ɂB
    *cmd++ = PICA_CMD_DATA_TEX_ENV_SRC( \
        source_rgb[0],   source_rgb[1],   source_rgb[2],  \
        source_alpha[0], source_alpha[1], source_alpha[2] \
    );
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( GetTextureCombinerSourceRegister(step), BE );
    return cmd;
  }

  static inline bit32* MakeFragmentShaderBufferInputCommand(bit32* cmd,
      PicaDataTexEnvBufferInput input_rgb[4], PicaDataTexEnvBufferInput input_alpha[4])
  {
    static const u32 BE = 0x2;  // 0010
    *cmd++ = ( \
          PICA_CMD_DATA_TEX_ENV_BUFFER_INPUT(1, input_rgb[0], input_alpha[0]) \
        | PICA_CMD_DATA_TEX_ENV_BUFFER_INPUT(2, input_rgb[1], input_alpha[1]) \
        | PICA_CMD_DATA_TEX_ENV_BUFFER_INPUT(3, input_rgb[2], input_alpha[2]) \
        | PICA_CMD_DATA_TEX_ENV_BUFFER_INPUT(4, input_rgb[3], input_alpha[3]) \
    );
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( PICA_REG_TEX_ENV_BUF_INPUT, BE );
    return cmd;
  }

  static inline bit32* MakeStencilOperationTestCommand(bit32* cmd, u8 enable, PicaDataStencilTest func_func, u8 mask, u8 func_ref, u8 func_mask)
  {
    // @todo R}h𕪂邪ĂȂBĂ΁AƂƂ̒loĂȂĂ㏑ŉƂłB
    static const u32 BE = 0xF;  // 1111
    *cmd++ = PICA_CMD_DATA_STENCIL_TEST(enable, func_func, mask, func_ref, func_mask);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( PICA_REG_STENCIL_TEST, BE );
    return cmd;
  }
  
  static inline bit32* MakeStencilOperationOpCommand(bit32* cmd, PicaDataStencilOp op_fail, PicaDataStencilOp op_zfail, PicaDataStencilOp op_zpass)
  {
    // @todo BEݒ肵ȂĂƂ́AȂق肷̂H
    static const u32 BE = 0x3;  // 0011
    *cmd++ = PICA_CMD_DATA_STENCIL_OP(op_fail, op_zfail, op_zpass);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( PICA_REG_STENCIL_OP, BE );
    return cmd;
  }

  static inline bit32* MakeAlphaTestCommand(bit32* cmd, u8 enable, PicaDataAlphaTest func, u8 ref)
  {
    // @todo R}h𕪂邪ĂȂBĂ΁AƂƂ̒loĂȂĂ㏑ŉƂłB
    static const u32 BE = 0x3;  // 0011
    *cmd++ = PICA_CMD_DATA_FRAGOP_ALPHA_TEST(enable, func, ref);
    *cmd++ = PICA_CMD_HEADER_SINGLE_BE( PICA_REG_FRAGOP_ALPHA_TEST, BE );
    return cmd;
  }


public:
  // @brief  R}h𑖍
  // command32rbgvf̔z
  // command_size32rbgvf̌
  static void ScanCommand(const bit32* command, u32 command_size, H3dCommandListener* listener)
  {
#if 0
    Ql

    CTR vO~O}jA
    OtBbNXp
    2012-03-09
    Ver. 4.0

    8.7.2 3D R}hobt@̎dl
#endif

    //////// [h
    enum
    {
      MODE_HEADER  = 0,  // wb_
      MODE_DATA    = 1,  // f[^
      MODE_IGNORE  = 2   // f[^
    };
    
    u32 mode = MODE_HEADER;

    u32 addr = 0;
    u32 be   = 0;
    u32 size = 0;
    u32 seq  = 0;

  #define BE2MASK(be) ( 0xFF000000*((be&0x8)>>3) + 0xFF0000*((be&0x4)>>2) + 0xFF00*((be&0x2)>>1) + 0xFF*((be&0x1)>>0) )

    u32 count = 0;  // f[^̌̃JEg

    u32 i = 0;
    while( i < command_size )
    {
      if( mode == MODE_HEADER )
      {
        //////// 32rbgwb_A32rbgf[^
        // ʉʂЂԂȂƂȂ̂ŁA64rbg̃R}hǂ

        if( i+2 > command_size )
        {
          // R}h64rbgɖȂꍇAG[
          listener->OnReadError( i, command[i] );
          break;
        }
         
        // 32rbg̃wb_ǂ
        ++i;
        addr = ( command[i] ) & 0xFFFF;
        be   = ( command[i] >> 16 ) & 0xF;
        size = ( command[i] >> 20 ) & 0xFF;
        seq  = ( command[i] >> 31 );
        listener->OnReadHeader( i, command[i], addr, be, size, seq,
            ( size == 0 )?( H3dCommandListener::SINGLE_ACCESS ):( H3dCommandListener::BURST_ACCESS ) );
        
        // 32rbg̃f[^ǂ
        --i;
        if( size == 0 )
        {
          // VOANZX
          listener->OnReadData( i, command[i], addr, BE2MASK(be), 0, 1, H3dCommandListener::SINGLE_ACCESS );
        }
        else  // if( size >= 1 )
        {
          // o[XgANZX
          count = 0;
          listener->OnReadData( i, command[i], addr+((seq==1)?count:0), BE2MASK(be), count, size+1, H3dCommandListener::BURST_ACCESS );
          ++count;
        }
      
        // ̃R}h
        if( size >= 1 )
        {
          mode = MODE_DATA;
        }
        i += 2;
      }
      else if( mode == MODE_DATA )
      {
        ////// f[^
        // ʉʂЂԂȂĂ悢̂ŁA32rbgvfǂ
        
        // o[XgANZX
        listener->OnReadData( i, command[i], addr+((seq==1)?count:0), BE2MASK(be), count, size+1, H3dCommandListener::BURST_ACCESS );
        ++count;

        // f[^Af[^I
        if( count >= size+1 )
        {
          // f[^I
          if( (size+1)%2 == 0 )
          {
            // f[^̌̏ꍇ
            // 64rbgf[^̏32rbg̃f[^𖳎
            mode = MODE_IGNORE;
          }
          else
          {
            // f[^̌̏ꍇ
            // ̓wb_
            mode = MODE_HEADER;
          }
        }
        ++i;
      }
      else  // if( mode == MODE_IGNORE )
      {
        //////// 32rbg̃f[^𖳎
        listener->OnReadIgnore( i, command[i] );

        // f[^I
        // ̓wb_
        mode = MODE_HEADER;
        ++i;
      }
    }

  #undef BE2MASK

  }

public:
  // @brief  R}h̏o͂(Po)
  static void DumpCommandSimple(const nw::h3d::fnd::Command& command)
  {
    GFL_PRINT("%s\n", __PRETTY_FUNCTION__);
    GFL_PRINT("size=%d\n", command.size());

    for(s32 i=0; i<command.size(); ++i)
    {
      GFL_PRINT("[%d] 0x%X\n", i, command[i]);
    }
  }

  // @brief  R}h̏o͂(ǂ݈Ղ)
  // command32rbgvf̔z
  // command_size32rbgvf̌
  static void DumpCommandEasy(const bit32* command, u32 command_size)
  {
    H3dCommandListenerDump listener;

    GFL_PRINT("%s\n", __PRETTY_FUNCTION__);

    GFL_PRINT("-------- Start --------\n");

    //////// 32rbgvf̌
    // R}h64rbg1Ȃ̂ŁA32rbgvf͋łȂ΂ȂȂB
    GFL_PRINT("command_size=%d, 64bits_num=%d, Remain=%d[%s]\n",
        command_size, command_size/2,
        command_size%2, (command_size%2==1)?("ERROR"):("OK"));

    ////////
    ScanCommand(command, command_size, &listener);
    
    GFL_PRINT("-------- End --------\n");
  }
  static void DumpCommandEasy(const nw::h3d::fnd::Command& command)
  {
    DumpCommandEasy(reinterpret_cast<const bit32*>(command.GetBeginAddress()), command.size());
  }


#if 0
܂ĂLqcĂ

  // @brief  R}h̏o͂(ǂ݈Ղ)
  // command32rbgvf̔z
  // command_size32rbgvf̌
  static void DumpCommandEasy(const bit32* command, u32 command_size)
  {
#if 0
    Ql

    CTR vO~O}jA
    OtBbNXp
    2012-03-09
    Ver. 4.0

    8.7.2 3D R}hobt@̎dl
#endif

    GFL_PRINT("%s\n", __PRETTY_FUNCTION__);
   
    //////// 32rbgvf̌
    // R}h64rbg1Ȃ̂ŁA32rbgvf͋łȂ΂ȂȂB
    GFL_PRINT("command_size=%d, 64bits_num=%d, Remain=%d[%s]\n",
        command_size, command_size/2,
        command_size%2, (command_size%2==1)?("ERROR"):("OK"));

    //////// [h
    enum
    {
      MODE_HEADER  = 0,  // wb_
      MODE_DATA    = 1,  // f[^
      MODE_IGNORE  = 2   // f[^
    };
    
    u32 mode = MODE_HEADER;

    u32 addr = 0;
    u32 be   = 0;
    u32 size = 0;
    u32 seq  = 0;

    u32 count = 0;  // f[^̌̃JEg

    u32 i = 0;
    while( i < command_size )
    {
      if( mode == MODE_HEADER )
      {
        //////// 32rbgwb_A32rbgf[^
        // ʉʂЂԂȂƂȂ̂ŁA64rbg̃R}hǂ

        if( i+2 > command_size )
        {
          // R}h64rbgɖȂꍇAG[
          GFL_PRINT("[%2d](0x%X) [ERROR]\n", i, command[i]);
          break;
        }
         
        // 32rbg̃wb_ǂ
        ++i;
        addr = ( command[i] ) & 0xFFFF;
        be   = ( command[i] >> 16 ) & 0xF;
        size = ( command[i] >> 20 ) & 0xFF;
        seq  = ( command[i] >> 31 );
        GFL_PRINT("[%2d](0x%X) [HEADER] ADDR=0x%X, BE=0x%X, SIZE=%d, SEQ=%d\n", i, command[i], addr, be, size, seq);
        
        // 32rbg̃f[^ǂ
        --i;
        if( size == 0 )
        {
          // VOANZX
          GFL_PRINT("[%2d](0x%X) [DATA] SINGLE_ACCESS ADDR=0x%X, MASK=0x%X\n", i, command[i], addr,
              ( 0xFF000000*((be&0x8)>>3) + 0xFF0000*((be&0x4)>>2) + 0xFF00*((be&0x2)>>1) + 0xFF*((be&0x1)>>0) )
          );
        }
        else  // if( size >= 1 )
        {
          // o[XgANZX
          count = 0;
          GFL_PRINT("[%2d](0x%X) [DATA] BURST_ACCESS ADDR=0x%X, MASK=0x%X, count=%d/%d\n", i, command[i], addr+((seq==1)?count:0),
              ( 0xFF000000*((be&0x8)>>3) + 0xFF0000*((be&0x4)>>2) + 0xFF00*((be&0x2)>>1) + 0xFF*((be&0x1)>>0) )
              , count, size+1
          );
          ++count;
        }
      
        // ̃R}h
        if( size >= 1 )
        {
          mode = MODE_DATA;
        }
        i += 2;
      }
      else if( mode == MODE_DATA )
      {
        ////// f[^
        // ʉʂЂԂȂĂ悢̂ŁA32rbgvfǂ
        
        // o[XgANZX
        GFL_PRINT("[%2d](0x%X) [DATA] BURST_ACCESS ADDR=0x%X, MASK=0x%X, count=%d/%d\n", i, command[i], addr+((seq==1)?count:0),
            ( 0xFF000000*((be&0x8)>>3) + 0xFF0000*((be&0x4)>>2) + 0xFF00*((be&0x2)>>1) + 0xFF*((be&0x1)>>0) )
            , count, size+1
        );
        ++count;

        // f[^Af[^I
        if( count >= size+1 )
        {
          // f[^I
          if( (size+1)%2 == 0 )
          {
            // f[^̌̏ꍇ
            // 64rbgf[^̏32rbg̃f[^𖳎
            mode = MODE_IGNORE;
          }
          else
          {
            // f[^̌̏ꍇ
            // ̓wb_
            mode = MODE_HEADER;
          }
        }
        ++i;
      }
      else  // if( mode == MODE_IGNORE )
      {
        //////// 32rbg̃f[^𖳎
        GFL_PRINT("[%2d](0x%X) [IGNORE]\n", i, command[i]);

        // f[^I
        // ̓wb_
        mode = MODE_HEADER;
        ++i;
      }
    }
  }
  static void DumpCommandEasy(const nw::h3d::fnd::Command& command)
  {
    DumpCommandEasy(reinterpret_cast<const bit32*>(command.GetBeginAddress()), command.size());
  }
#endif


};



}  // namespace g3d
}  // namespace grp
}  // namespace gfl



#endif  // GFL_GRP_G3D_H3D_USE

#endif // __GFL_G3DH3DCOMMANDUTIL_H__
