//=============================================================================
/**
 * @brief ScriptMsgManager.h
 * @brief
 * @date    2012.08.24
 * @author  tamada
 */
//=============================================================================
#if !defined( __SCRIPTMSGMANAGER_H__)
#define __SCRIPTMSGMANAGER_H__

#include <gflib.h>

GFL_NAMESPACE_BEGIN(field);
GFL_NAMESPACE_BEGIN(script);

class ScriptMsg;
class FieldMap;
//-----------------------------------------------------------------------------
/**
 * @class ScriptMsgManager
 */
//-----------------------------------------------------------------------------
class ScriptMsgManager
{
  GFL_FORBID_COPY_AND_ASSIGN( ScriptMsgManager );

public:
  ScriptMsgManager( gfl::heap::HeapBase* p_heap, ScriptMoveModelController* p_smmc, u32 buf_max );
  ~ScriptMsgManager();

  void Initialize( FieldMap * p_fieldmap );
  bool IsInitialized( void );
  void Finalize( void );
  bool IsFinalized( void );
  void Update( void );

  bool RequestMsg( u16 msg_arc_id, u16 msg_dat_id, u16 obj_id, u16 win_type );

private:
    gfl::heap::HeapBase* m_heap;
    ScriptMoveModelController* m_smmc;
    u32 m_BufMax;

    ScriptMsg ** m_ScriptMsg;
    FieldMap * m_fieldMap;
};


GFL_NAMESPACE_END(script);
GFL_NAMESPACE_END(field);


#endif  // __SCRIPTMSGMANAGER_H__
