//=============================================================================
/**
 * @brief ScriptMsgManager.cpp
 * @brief
 * @date    2012.08.24
 * @author  tamada
 */
//=============================================================================
#include <gflib.h>
#include "ScriptMsgManager.h"

GFL_NAMESPACE_BEGIN(field);
GFL_NAMESPACE_BEGIN(script);

//=============================================================================
//=============================================================================
//-----------------------------------------------------------------------------
/**
 * @class ScriptMsg
 */
//-----------------------------------------------------------------------------
class ScriptMsg
{
private:
  gfl::str::StrBuf* m_MsgBuf;

  bool m_bUse;
  //ȉ͕\pp[^
  u16 m_msg_arc_id;
  u16 m_msg_dat_id;
  u16 m_obj_id;
  u16 m_win_type;
  s32 m_priority;

  static const u32 BUFFER_SIZE = 1024;  ///@todo TCY

public:

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
  ScriptMsg( gfl::heap::HeapBase* p_heap )
  {
    //m_MsgBuf = GFL_NEW( p_heap ) gfl::str::StrBuf( BUFFER_SIZE, p_heap );
    Clear();
  }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
  ~ScriptMsg()
  {
    //GFL_DELETE( m_MsgBuf );
  }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
  bool IsUse( void ) { return m_bUse; }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
  void Clear( void )
  {
    m_bUse        = false;
    m_msg_arc_id  = 0;
    m_msg_dat_id  = 0;
    m_obj_id      = 0;
    m_win_type    = 0;
    m_priority    = 0;
  }

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
  void SetRequest( u16 msg_arc_id, u16 msg_dat_id, u16 obj_id, u16 win_type )
  {
    m_bUse        = true;
    m_msg_arc_id  = msg_arc_id;
    m_msg_dat_id  = msg_dat_id;
    m_obj_id      = obj_id;
    m_win_type    = win_type;
    //m_priority    = 0;  @todo setting
  }

//-----------------------------------------------------------------------------
/**
 * @todo  샂fEMSG̏MsgWinmmodel::ManagerfieldmapoH
 */
//-----------------------------------------------------------------------------
  void Update( FieldMap* p_fieldmap )
  {
    if ( m_bUse )
    {
      // ɕ\NGXg镔Lq
      // 񓯊ǂݍ݂Kvȏꍇ͂Ŏ

      //@todo TalkMdlMsg_SeqƂقړȂB
      //@todo TalkMdlMsg_Seq̋@\ɎA̓bp[ɂH
     
      if ( 1 )
      {
        Clear(); //\I疢gpɂȂ
      }
    }
  }

};    // End of class ScriptMsg

//=============================================================================
//
//
//    class ScriptMsgManager
//
//
//=============================================================================
//-----------------------------------------------------------------------------
/**
 * @brief RXgN^
 */
//-----------------------------------------------------------------------------
ScriptMsgManager::ScriptMsgManager( gfl::heap::HeapBase* p_heap, ScriptMoveModelController* p_smmc, u32 buf_max ):
  m_heap(p_heap),
  m_smmc(p_smmc),
  m_BufMax(buf_max)
{
  m_ScriptMsg = GFL_NEW_ARRAY( p_heap ) ScriptMsg* [ buf_max ];
  for ( u32 i = 0; i < m_BufMax; ++ i )
  {
    m_ScriptMsg[i] = GFL_NEW( p_heap ) ScriptMsg( p_heap );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief fXgN^
 */
//-----------------------------------------------------------------------------
ScriptMsgManager::~ScriptMsgManager()
{
  for( u32 i = 0; i < m_BufMax; ++ i )
  {
    GFL_DELETE( m_ScriptMsg[i] );
  }
  GFL_DELETE_ARRAY( m_ScriptMsg );
}

//-----------------------------------------------------------------------------
/// N
//-----------------------------------------------------------------------------
void ScriptMsgManager::Initialize( FieldMap * p_fieldmap )
{
  m_fieldMap = p_fieldmap;
}

//-----------------------------------------------------------------------------
/// H
//-----------------------------------------------------------------------------
bool ScriptMsgManager::IsInitialized( void )
{
  return true;
}

//-----------------------------------------------------------------------------
/// IN
//-----------------------------------------------------------------------------
void ScriptMsgManager::Finalize( void )
{
  //ǂݍ݃LZȂǂȂH
  //
  m_fieldMap = NULL;
}
//-----------------------------------------------------------------------------
/// IH
//-----------------------------------------------------------------------------
bool ScriptMsgManager::IsFinalized( void )
{
  return true;
}

//-----------------------------------------------------------------------------
/**
 * @brief XV
 * @todo  DxtsƂȂ悤ɋ@\ǉKv
 */
//-----------------------------------------------------------------------------
void ScriptMsgManager::Update( void )
{
  for (u32 i=0; i < m_BufMax; ++i )
  {
    ScriptMsg * p_scrmsg = m_ScriptMsg[i];
    p_scrmsg->Update( m_fieldMap );
  }
}

//-----------------------------------------------------------------------------
/**
 * @brief NGXg𓊂
 * @todo  DxtsƂȂ悤ɋ@\ǉKv
 */
//-----------------------------------------------------------------------------
bool ScriptMsgManager::RequestMsg( u16 msg_arc_id, u16 msg_dat_id, u16 obj_id, u16 win_type )
{
  for (u32 i = 0; i < m_BufMax; ++i )
  {
    ScriptMsg * p_scrmsg = m_ScriptMsg[i];
    if ( p_scrmsg->IsUse() == false )
    {
      p_scrmsg->SetRequest( msg_arc_id, msg_dat_id, obj_id, win_type );
    }
  }
  return true;
}

GFL_NAMESPACE_END(script);
GFL_NAMESPACE_END(field);


