//==============================================================================
/**
 * @file	battle_match_proc_select_again.cpp
 * @brief	og}b`@TuvbN@ΐÂ܂
 * @author	ichiraku_katsuhiko
 * @data	2012/08/24, 18:03
 */
// =============================================================================

#include <message/msg_battle_match.h>

#include "battle_match_proc_select_again.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcSelectAgain::ProcSelectAgain( void ) : ProcBase()
{
	ICHI_PRINT("ProcSelectAgain::ProcSelectAgain\n");
}

// fXgN^
ProcSelectAgain::~ProcSelectAgain( void )
{
	ICHI_PRINT("ProcSelectAgain::~ProcSelectAgain\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectAgain::InitFunc( void )
{
	// qviewN
	m_view->RegistSelect1( this );

	// qview擾
	m_view_lower = m_view->GetSubViewSelect1();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_11 );
	m_view_lower->SetTextButton( battle_match_button_17, battle_match_button_14 );

	// AjJn
	m_view_lower->StartAnime( ANMID_LOWER_1_IN_LEFT );

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectAgain::UpdateFunc( void )
{

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectAgain::ExitFunc( void )
{
	// qview
	if( m_view->CancelSelect1() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief		{^ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectAgain::OnButtonAction( int button_no )
{
	// 1Ȃ̂łȊÕ{^͉Ȃ͂
	GFL_ASSERT_MSG( button_no<1, "Ⴄ{^Ă button_no->%d \n", button_no );

	switch( button_no ){
	// 傤񂷂
	case 0:
		SetSwitchType( SWITCH_SELECT_BUTTON_0 ); // Iސݒ
		SetFinish( NEXT_SELECT_POKE );
		break;
	}

	// AjĐ
	m_view_lower->StartAnime( ANMID_LOWER_1_OUT_LEFT );		// ɃtF[hAEg
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectAgain::OnReturnAction( void )
{
	m_view_lower->StartAnime( ANMID_LOWER_1_OUT_RIGHT );		// EɃtF[hAEg

	// Iސݒ
	SetSwitchType( SWITCH_RETURN );

	ICHI_PRINT("߂鉟\n");
	SetFinish( NEXT_SELECT_MATCH );
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

