//==============================================================================
/**
 * @file	battle_match_net.h
 * @brief	og}b`O@ʐM
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 17:20
 */
// =============================================================================

#if !defined( __BATTLE_MATCH_NET_H__ )
#define	__BATTLE_MATCH_NET_H__

#include <gflib.h>
#include <gflnet.h>
#include <net/XyNetInterface.h>
#include <netapp/automatch/WifiMatching.h>

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

class NetSystem : public xynet::XyNetInterface 
{
  GFL_FORBID_COPY_AND_ASSIGN( NetSystem ); // Rs[֎~
private:

	// V[PX`
	enum{
		SEQ_NONE,						///< Ȃ
		SEQ_MATCHING,				///< }b`O
		SEQ_CONNECT,				///< }b`O
		SEQ_DISCONNECT,			///< ؒf
		SEQ_DISCONNECT_WAIT,///< ؒf҂
	};

public:
  // RXgN^
  NetSystem( void );
  // fXgN^
  virtual ~NetSystem( void );

	// XV
  virtual void Update( void );

	// I
	//@override
	//@note gpȂ
  virtual bool Finalize( void ){ return true; };

	// Ił
	//@override
	//@note gpȂ
  virtual bool IsFinalized( void ){ return true; };

public:
	// ڑJn
	void Connect( void );

	// ڑł
  inline bool IsConnect( void ){ return m_isConnect; }

	// INGXgs
	inline void SetReqDisconnect( void ){ m_reqDisconnect = true; };

	// Ił
	inline bool IsEnd( void ){ return m_isEnd; };

  gflnet::p2p::NetGame* GetNetGame( void );

private:
  //=====================================
	// ʐM֌W̃o
  gfl::heap::HeapBase*			m_pSysHeap;			///< {HEAP
  gfl::heap::HeapBase*			m_pDevHeap;			///< foCXq[v

  netapp::WifiMatching*			m_pWifiMatching;///< WifiڑNX
	u32												m_pricipalId;		///< WiFi}b`OpvVpID
	u32												m_tiketId;			///< WiFi}b`Op`PbgID

  //=====================================
	// ֌W̃o
	int								m_seq;						///< V[PX
	bool							m_isConnect;			///< ڑĂ邩
	bool							m_isEnd;					///< IĂ邩
	bool							m_reqDisconnect;	///< INGXg

} ;

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

#endif	/* __BATTLE_MATCH_NET_H__ */

