//============================================================================================
/**
 * @file		app_pokelist_Touchbar.h
 * @brief		|PXg ^b`o[
 * @author	Hiroyuki Nakamura
 * @date		12.08.23
 *
 * namespace	app::pokelist::
 */
//============================================================================================
#if !defined( __APP_POKELIST_TOUCHBAR_H__ )
#define __APP_POKELIST_TOUCHBAR_H__

#include "app/ui/UITouchBarView.h"
#include "app/ui/UITouchBarListener.h"

namespace app {
namespace pokelist {

class TouchBar : public app::ui::UITouchBarView, public app::ui::UITouchBarListener {
public:
	enum {
		PRM_NONE = 0,
		PRM_HOLD,
		PRM_SELECT_EXIT,
		PRM_SELECT_RETURN,
		PRM_SELECT_POKECHANGE,
		PRM_SELECT_ITEMCHANGE,
	};

public:
	TouchBar(
		app::util::Heap * heap,
		gfl::grp::GraphicsSystem * grasys,
		gfl::grp::g2d::LytSys * lytsys,
		gfl::grp::g2d::LytWk * lytwk );

	~TouchBar();

	u32 GetParam(void);
	void SelectKeyButton( u32 prm );
	void SetVisible( u32 buttonID, bool flg );
	void SetActive( u32 buttonID, bool flg );


	virtual void Update(void);

	virtual bool OnSelectedButton( u32 buttonID );
//	virtual bool OnLongPressedButton( u32 buttonID );


private:
	u32	retParam;

};

}	// pokelist
}	// app

#endif	// __APP_POKELIST_TOUCHBAR_H__
