//============================================================================================
/**
 * @file		app_pokelist_Touchbar.cpp
 * @brief		|PXg ^b`o[
 * @author	Hiroyuki Nakamura
 * @date		12.08.23
 *
 * namespace	app::pokelist::
 */
//============================================================================================
#include "drawer/lower_pane.h"
#include "app_pokelist_Touchbar.h"

namespace app {
namespace pokelist {

static const app::ui::UITouchBarView::SETUP PokeListTouchBarSetup[] =
{
	{ app::ui::UITouchBarView::BUTTON_ID_POKECHANGE,	PANENAME_POKELIST_LOWER_PANE_POKE_CHANGE_POS },		// |Pւ{^
	{ app::ui::UITouchBarView::BUTTON_ID_ITEMCHANGE,	PANENAME_POKELIST_LOWER_PANE_ITEM_CHANGE_POS },		// ACeւ{^
	{ app::ui::UITouchBarView::BUTTON_ID_EXIT,				PANENAME_POKELIST_LOWER_PANE_EXIT_ICON_POS },			// ~{^
	{ app::ui::UITouchBarView::BUTTON_ID_RETURN,			PANENAME_POKELIST_LOWER_PANE_RETURN_ICON_POS },		// ߂{^
};


TouchBar::TouchBar(
		app::util::Heap * heap,
		gfl::grp::GraphicsSystem * grasys,
		gfl::grp::g2d::LytSys * lytsys,
		gfl::grp::g2d::LytWk * lytwk ) :
	app::ui::UITouchBarView( heap, grasys, lytsys, lytwk, PokeListTouchBarSetup, GFL_NELEMS(PokeListTouchBarSetup) ),
	retParam( PRM_NONE )
{
	app::ui::UITouchBarView::SetListener( this );
}

TouchBar::~TouchBar()
{
}

u32 TouchBar::GetParam(void)
{
	return retParam;
}

void TouchBar::Update(void)
{
	retParam = PRM_NONE;

	app::ui::UITouchBarView::Update();

	if( app::ui::UITouchBarView::IsButtonAnimation() == true ){
		if( retParam == PRM_NONE ){
			retParam = PRM_HOLD;
		}
	}
}

void TouchBar::SetVisible( u32 buttonID, bool flg )
{
	app::ui::UITouchBarView::SetVisible( buttonID, flg );
}

void TouchBar::SetActive( u32 buttonID, bool flg )
{
	app::ui::UITouchBarView::SetActive( buttonID, flg );
}


void TouchBar::SelectKeyButton( u32 prm )
{
	u32	buttonID;

	switch( prm ){
	case PRM_SELECT_EXIT:		// ~{^
		buttonID = app::ui::UITouchBarView::BUTTON_ID_EXIT;
		break;
	case PRM_SELECT_RETURN:	// ߂{^
		buttonID = app::ui::UITouchBarView::BUTTON_ID_RETURN;
		break;
	case PRM_SELECT_POKECHANGE:	// |P؂ւ
		buttonID = app::ui::UITouchBarView::BUTTON_ID_POKECHANGE;
		break;
	case PRM_SELECT_ITEMCHANGE:	// ACe؂ւ
		buttonID = app::ui::UITouchBarView::BUTTON_ID_ITEMCHANGE;
		break;
	default:
		GFL_ASSERT( 0 );
		return;
	}

	app::ui::UITouchBarView::StartSelectedAct( buttonID );
}



bool TouchBar::OnSelectedButton( u32 buttonID )
{
	switch( buttonID ){
	case app::ui::UITouchBarView::BUTTON_ID_EXIT:				// ~{^
		retParam = PRM_SELECT_EXIT;
		break;
	case app::ui::UITouchBarView::BUTTON_ID_RETURN:			// ߂{^
		retParam = PRM_SELECT_RETURN;
		break;
	case app::ui::UITouchBarView::BUTTON_ID_POKECHANGE:	// |P؂ւ
		retParam = PRM_SELECT_POKECHANGE;
		break;
	case app::ui::UITouchBarView::BUTTON_ID_ITEMCHANGE:	// ACe؂ւ
		retParam = PRM_SELECT_ITEMCHANGE;
		break;
	}
	return false;
}


}	// pokelist
}	// app
