//============================================================================================
/**
 * @file  wordsetloader.cpp
 * @brief wordsetł̎Oobt@ǂݍ݊Ǘ
 * @author  tamada
 * @date  2012.08.23
 */
//============================================================================================


#include <gflib.h>

#include "print/WordsetLoader.h"


//------------------------------------------------------------------
/**
 * @brief ǂݍݑΏۂGARCw
 * @note  include/print/WordsetLoader.henumƕт낦邱
 */
//------------------------------------------------------------------
static const u16 garc_id_table[ PRELOAD_NO_MAX ] = {
  GARC_message_itemname_DAT,
  GARC_message_wazaname_DAT,
  GARC_message_typename_DAT,
  GARC_message_tokusei_DAT,
  GARC_message_seikaku_DAT,
  GARC_message_place_name_DAT,
  GARC_message_trtype_DAT,
  GARC_message_trname_DAT,
  GARC_message_assist_power_DAT,
  GARC_message_kawaigari_goods_DAT,
};

//------------------------------------------------------------------
/**
 * @brief MSGobt@Ǘ\
 */
//------------------------------------------------------------------
struct WordSetLoader::Buffer
{
  void * mAddress;
  size_t mSize;
  u16     mGarcId;
  gfl::str::MsgData * mMsgData;
};

//------------------------------------------------------------------
//------------------------------------------------------------------
static inline u32 countBits( u32 bits )
{
u32 count = 0;
while ( bits != 0 )
{
  if (bits & 1) count ++;
  bits >>= 1;
}
return count;
}

//------------------------------------------------------------------
/**
 * @brief RXgN^
 * @param[in]   pHeap         gpq[v̎w
 * @param[in]   p_readman     gpFileReadManagerւ̃|C^
 * @param[in]   read_id_bits  Oǂݍ݂閼O̎w
 */
//------------------------------------------------------------------
WordSetLoader::WordSetLoader( gfl::heap::HeapBase *pHeap, gfl::fs::FileReadManager * p_readman, u32 read_id_bits ) :
  m_pFileReadManager( p_readman ),
  m_pHeap( pHeap ),
  m_ReadBits(read_id_bits),
  m_ReadCount(countBits(read_id_bits)),
  m_BufferArray( NULL ),
  m_bLoaded(false)
{
}

//------------------------------------------------------------------
/**
 * @brief fXgN^
 */
//------------------------------------------------------------------
WordSetLoader::~WordSetLoader()
{
  m_pFileReadManager->RemoveManageFile( ARCID_MESSAGE );
  for (u32 i = 0; i < m_ReadCount; ++i )
  {
    GflHeapFreeMemory( m_BufferArray[i].mAddress );
    GFL_DELETE( m_BufferArray[i].mMsgData );
  }
  if ( m_BufferArray )
  {
    GFL_DELETE_ARRAY( m_BufferArray );
  }
}

//------------------------------------------------------------------
/**
 * @brief   ǂݍ݊Jn
 */
//------------------------------------------------------------------
void WordSetLoader::StartLoad( void )
{
  m_pFileReadManager->AppendManageFile( m_pHeap, ARCID_MESSAGE );

  m_BufferArray = GFL_NEW_ARRAY(m_pHeap) Buffer[ m_ReadCount ];
  u32 count = 0;
  u32 temp_bits = m_ReadBits;
  for ( u32 bit_idx = 0; temp_bits != 0; ++ bit_idx, temp_bits >>= 1 )
  {
    GFL_ASSERT( bit_idx < GFL_NELEMS(garc_id_table) );
    if ( temp_bits & 1 )
    {
      u16 dat_id = garc_id_table[bit_idx];
      m_BufferArray[count].mGarcId = dat_id;
      m_pFileReadManager->AddReadRequest(
          &m_BufferArray[count].mAddress,
          &m_BufferArray[count].mSize,
          m_pHeap, 4, ARCID_MESSAGE, dat_id, false );
      ++ count;
    }
  }
  GFL_ASSERT( count == m_ReadCount );
}

//------------------------------------------------------------------
/**
 * @brief   ǂݍݑ҂
 * @return  bool  truêƂZbgAbv
 *
 * @note    Sf[^ǂݍݎɏ߂MsgData̐sĂ
 */
//------------------------------------------------------------------
bool WordSetLoader::WaitLoad( void )
{
  if ( m_bLoaded ) return true;

  bool ret = true;
  for (u32 i = 0; i< m_ReadCount; ++i )
  {
    if (m_pFileReadManager->IsReadFinished( &m_BufferArray[i].mAddress ) == false )
    {
      ret = false;
      break;
    }
  }
  if ( ret )
  {
    for (u32 i = 0; i < m_ReadCount; ++i )
    {
      m_BufferArray[i].mMsgData = GFL_NEW(m_pHeap) gfl::str::MsgData(
          m_BufferArray[i].mAddress, m_pHeap );
    }
    m_bLoaded = true;
  }
  return ret;
}

//------------------------------------------------------------------
/**
 * @brief wIDMsgData擾
 * @param[in]   dat_id
 * @return      MsgDataւ̃|C^A݂ȂꍇNULLԂ
 */
//------------------------------------------------------------------
gfl::str::MsgData * WordSetLoader::GetMsgData( u32 dat_id )
{
  for (u32 i = 0; i < m_ReadCount; ++ i )
  {
    if ( m_BufferArray[i].mGarcId == dat_id )
    {
      return m_BufferArray[i].mMsgData;
    }
  }
  return NULL;
}


























