//============================================================================================
/**
 * @file    WordsetLoader.h
 * @brief   wordsetł̎Oobt@ǂݍ݊Ǘ
 * @author  tamada
 * @date  2012.08.23
 *
 * 3DSł͓ǂݍ݂ƂȂ邽߁AOɖ̈ꗗMsgDataǂݍłKvB
 * WordSetɑ΂ēǂݍݏƓǂݍ݃f[^񋟂邽߂̃NX
 *
 * |P͏풓Ă邽ߎw肷Kv͂Ȃ
 */
//============================================================================================
#if !defined(__WORDSETLOADER_H__)
#define __WORDSETLOADER_H__

#include <gflib.h>
//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/// ǂݍ݊ǗIDiWordsetLoaderł̂ݎgpj
//------------------------------------------------------------------
enum {
  PRELOAD_NO_ITEMNAME = 0,
  PRELOAD_NO_WAZANAME,
  PRELOAD_NO_TYPENAME,
  PRELOAD_NO_TOKUSEI,
  PRELOAD_NO_SEIKAKU,
  PRELOAD_NO_PLACENAME,
  PRELOAD_NO_TRTYPE,
  PRELOAD_NO_TRNAME,
  PRELOAD_NO_ASSIST_POWER,
  PRELOAD_NO_KAWAIGARI_GOODS,

  PRELOAD_NO_MAX,
};

//------------------------------------------------------------------
/**
 * @brief ǂݍݎwprbg`
 * @note  src/print/WordSetLoader.cppgarc_id_tableƕт낦邱
 */
//------------------------------------------------------------------
enum {
  PRELOAD_ITEMNAME        = 1 << PRELOAD_NO_ITEMNAME,
  PRELOAD_WAZANAME        = 1 << PRELOAD_NO_WAZANAME,
  PRELOAD_TYPENAME        = 1 << PRELOAD_NO_TYPENAME,
  PRELOAD_TOKUSEI         = 1 << PRELOAD_NO_TOKUSEI,
  PRELOAD_SEIKAKU         = 1 << PRELOAD_NO_SEIKAKU,
  PRELOAD_PLACENAME       = 1 << PRELOAD_NO_PLACENAME,
  PRELOAD_TRTYPE          = 1 << PRELOAD_NO_TRTYPE,
  PRELOAD_TRNAME          = 1 << PRELOAD_NO_TRNAME,
  PRELOAD_ASSIST_POWER    = 1 << PRELOAD_NO_ASSIST_POWER,
  PRELOAD_KAWAIGARI_GOODS = 1 << PRELOAD_NO_KAWAIGARI_GOODS,
};

//============================================================================================
/**
 * @class WordSetLoader
 * @brief WordSetł̎Oǂݍ݊ǗNX
 */
//============================================================================================
class WordSetLoader
{
  struct Buffer;

  public:
      WordSetLoader( gfl::heap::HeapBase *pHeap, gfl::fs::FileReadManager * p_readman, u32 read_id_bits );

      ~WordSetLoader();

      void StartLoad( void );

      bool WaitLoad( void );

      gfl::str::MsgData * GetMsgData( u32 dat_id );


  private:
    gfl::fs::FileReadManager * m_pFileReadManager;
    gfl::heap::HeapBase* m_pHeap;
    u32 m_ReadBits;
    u32 m_ReadCount;
    Buffer * m_BufferArray;
    bool m_bLoaded;

};

#endif  // __WORDSETLOADER_H__
