#if PM_DEBUG

//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		TestOnoueMenu.cpp
 *  @brief  ^CgfobOu㏫Vvj[
 *	@author	Masayuki Onoue
 *	@date		2012.08.23
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include <gflib.h>
#include <gfl_Heap.h>
#include <gfl_Base.h>

#include "gamesystem/GameProc.h"
#include "gamesystem/GameProcManager.h"

#include "test/onoue/TestOnoueMenu.h"

#include <dll/DllProc.h>
#include <ro/gfl_RoManager.h>
#include "netapp/gts/gts.h"
#include "app/field_demo/FieldDemoApp.h"

// \̃bZ[WX^WI֘A
#include "message/debug_message.gaix"
#include "arc_def.h"
#include "message/debug/msg_d_test_menu_onoue.h"


namespace test {
namespace onoue {


Proc*     Proc::m_instance;


//-----------------------------------------------------------------------------
/**
 *      launcherN
 *
 *  *ǉ@
 *    1.bZ[WX^WI(ingame_text.msproj)debug/d_test_menu_onoue.mstxtɃ[U[xǉ
 *    2.sc_LauncherLabelMsgɒǉ[U[xo^
 *    3.SetUpUserProc֐Proco^Lq
 */
//-----------------------------------------------------------------------------

const skel::LauncherLabelMsg sc_LauncherLabelMsg[] = {

  // ̃x̏Ԃōڂ̕\܂܂
  LAUNCHERLABEL_DEMO,
  LAUNCHERLABEL_EXIT
};

//-----------------------------------------------------------------------------
/**
 *
 */
//-----------------------------------------------------------------------------
static const skel::LauncherShortcutTable sc_LauncherShortcut[]  =
{
  //BLŖ߂
  {
    gfl::ui::BUTTON_B,
    LAUNCHERLABEL_EXIT,
  },
};

// NZbgAbv
static const skel::LauncherSetUpMsg sc_LauncherSetUpMsg =
{
  ARCID_DEBUG_MESSAGE,                  
  GARC_debug_message_d_test_menu_onoue_DAT,  
  sc_LauncherLabelMsg,
  GFL_NELEMS(sc_LauncherLabelMsg),
  sc_LauncherShortcut,
  GFL_NELEMS(sc_LauncherShortcut)
};


static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap );
static void setFieldDemoParam( app::field_demo::APP_PARAM *prm, gfl::heap::HeapBase* heap );



//--------------------------------------------------------------------------------------------
/**
 * @brief    RXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::Proc(void)
{
  m_isFinish = false;
  m_instance = this;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    fXgN^
 */
//--------------------------------------------------------------------------------------------
Proc::~Proc(void)
{
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    Proc
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::InitFunc( gfl::proc::Manager * )
{
//  RcvFlag = false;
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    ProcI
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::EndFunc( gfl::proc::Manager * )
{
  return gfl::proc::RES_FINISH;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    ProcAbvf[g
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  gfl::proc::Result
 */
//--------------------------------------------------------------------------------------------
gfl::proc::Result Proc::UpdateFunc( gfl::proc::Manager * )
{
  if( m_isFinish ){
    return gfl::proc::RES_FINISH;
  }
  CreateMenu();

  return gfl::proc::RES_CONTINUE;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief    Proc`揈
 *
 * @param    proc_manager    gfl::proc::Manager
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void Proc::DrawFunc( gfl::proc::Manager * )
{
}


void Proc::CreateMenu(void)
{
  skel::LauncherProc* pLauncher = KUJIRA_PROC_CALL<gamesystem::GameProcManager, skel::LauncherProc>(mpGameProcManager);
  pLauncher->SetParamGM( &sc_LauncherSetUpMsg, SetUpUserProc );
}


void Proc::DeleteMenu(void)
{
}

static void setFieldDemoParam( app::field_demo::APP_PARAM *prm, gfl::heap::HeapBase* heap  )
{
  gamesystem::GameData *gd    = GFL_SINGLETON_INSTANCE( gamesystem::GameManager )->GetGameData();
  pml::PokeParty       *party = gd->GetPlayerParty();

  prm->pMyStatus     = gd->GetPlayerStatus();   // vC[Xe[^X
  prm->pXyNetManager = NULL;
  prm->DemoMode      = app::field_demo::MODE_EXCHANGE;

  // K|Pf[^Ă
  {
    pml::pokepara::PokemonParam* poke;

    // 莝2C₵
    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_PIKATYUU, 5, 0 );
    party->AddMember( *poke );
    GFL_DELETE poke;

    poke = GFL_NEW( heap ) pml::pokepara::PokemonParam( heap, MONSNO_PARUKIA, 5, 0 );
    party->AddMember( *poke );
    GFL_DELETE poke;

    // |PE炤ɂĂif̐ݒȂ̂CoreParam΂ǂłǂj
    prm->pMyPoke   = party->GetMemberPointer(0);
    prm->pOthersPoke = party->GetMemberPointer(1);

  }

  GFL_PRINT( "pMyStatus      =%8x\n", prm->pMyStatus      );

}


static skel::LauncherSelectRet SetUpUserProc( u32 selectNum, gamesystem::GameProcManager* p_procMan, gfl::heap::HeapBase* heap )
{
  Proc *mainProc = Proc::GetInstance();

  GFL_UNUSED( heap );

  switch( selectNum )
  {
    // I
    case LAUNCHERLABEL_EXIT:
      mainProc->SetFinish();
      return skel::LAUNCHER_RET_CHANGE_DEBUGMODE;

    // Cgf
    case LAUNCHERLABEL_DEMO:
      {
        static app::field_demo::APP_PARAM prm;
        setFieldDemoParam( &prm, heap );
        dll::CallFieldDemoProc( p_procMan, &prm );
      }
      return skel::LAUNCHER_RET_CALL_NORMAL;
  }

  return skel::LAUNCHER_RET_CALL_DEBUGMODE;
}



}  // onoue
}  // test

#endif // PM_DEBUG
