//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldDemoGraphic.cpp
 *	@brief  `֘A
 *	@author	Masayuki Onoue
 *	@date		2012.08.23
 *
 * namespace  app::field_demo::
 *
 * 5279-6982    Avpev[gt@C쐬ꂽƂp^O
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

//#include "arc/arc_def.h"
#include "FieldDemoGraphic.h"
#include "arc/arc_def.h"
#include "arc/demo_test.gaix"
#include "arc/demo_sequence.gaix"
#include "arc/pmav_gra.gaix"
#include "arc/kisekae_data.gaix"


namespace app {
namespace field_demo {

static const u32 FIELD_DEMO_MODEL_DATA_MAX = 4;   // ff[^o^


//--------------------------------------------------------------------------------------------
/**
 * @brief   RXgN^
 *
 * @param   heap    q[v
 */
//--------------------------------------------------------------------------------------------
GraphicWork::GraphicWork( app::util::Heap * heap, APP_PARAM *param )
{
  m_param   = param;
  m_playend = false;
  
  CreateGraphicsSystem( heap );

  Create2D( heap );
  Create3D( heap );
  
  m_pokecount = 0;
  m_pokecount += SetupSimpleParam( 0, m_param->pMyPoke );
  m_pokecount += SetupSimpleParam( 1, m_param->pOthersPoke );
  CreateSeqPlayer( heap );
}


//--------------------------------------------------------------------------------------------
/**
 * @brief   fXgN^
 */
//--------------------------------------------------------------------------------------------
GraphicWork::~GraphicWork()
{
  DeleteSeqPlayer();
  Delete3D();
  Delete2D();

  DeleteGraphicsSystem();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   Abvf[g
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
  static int d_anime=0;


//  pG2dUtil->Update2D();
  pG3dUtil->CalculateG3dScene();
  
  // V[PXvC[XV
  m_player->Update();

  pG3dUtil->SetCamera( app::util::G3DUtil::SETUP_CAMERA_UPPER, m_player->GetCamera());
  GFL_PRINT("%d %p\n", d_anime, m_player->GetCamera());

  // |PfAjXV
  m_poke_sys->UpdateSystem();
  m_poke_sys->UpdateModelAnime();
  m_poke_sys->UpdateModel();

  pG3dUtil->Update3D(false);

  GFL_PRINT("f %d\n", d_anime);
  d_anime++;

  // I҂
  if(m_player->IsPlaying()==false){
    m_playend = true;
    GFL_PRINT("Im gra\n");
  }
}
#if 0
//--------------------------------------------------------------------------------------------
/**
 * @brief   Abvf[g
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Update(void)
{
  // |PfXV
  m_poke_sys->UpdateSystem();
  m_poke_sys->UpdateModel();


  pG3dUtil->SetCamera( app::util::G3DUtil::SETUP_CAMERA_UPPER, m_player->GetCamera());

//  pG2dUtil->Update2D();
  pG3dUtil->Update3D();

  // V[PXvC[XV
  m_player->Update();


  // I҂
  if(m_player->IsPlaying()==false){
    m_playend = true;
  }
}

#endif
//--------------------------------------------------------------------------------------------
/**
 * @brief   `
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Draw(void)
{
  gfl::grp::g3d::Scene *scene = pG3dUtil->GetScene();

  // |Pf`
  m_poke_sys->DrawRareEffectOff();
  scene->StereoEdgeMapDraw( pGraSystem, pG3dUtil->GetUpperCamera() );
  scene->StereoDraw( pGraSystem, pG3dUtil->GetUpperCamera() );
  scene->StereoPostEffectDraw( pGraSystem, pG3dUtil->GetUpperCamera() );
  m_poke_sys->DrawRareEffectOn();


//  pG2dUtil->Draw2D( pGraSystem, 0 );
  pG3dUtil->Draw3D( pGraSystem );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   OtBbNVXe쐬
 *
 * @param   heap    q[v
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::CreateGraphicsSystem( app::util::Heap * heap )
{
  gamesystem::GameManager * gm = GFL_SINGLETON_INSTANCE( gamesystem::GameManager );
  pGraSystem = gm->GetGraphicsSystem();
  pGraSystem->InitializeApplicationMemory( heap->pDevHeapAllocator );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   OtBbNVXe폜
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::DeleteGraphicsSystem(void)
{
  pGraSystem->FinalizeApplicationMemory();
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   2D֘A쐬
 *
 * @param   heap    q[v
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create2D( app::util::Heap * heap )
{
  pG2dUtil = GFL_NEW( heap->pHeap ) app::util::G2DUtil( heap );
/*
  // \[Xf[^e[u
  static const app::util::G2DUtil::LYT_RES_DATA resTbl[] =
  {
  };
  // CAEgf[^
  static const app::util::G2DUtil::LYTWK_DATA layoutData[] =
  {
  };
*/
  pG2dUtil->CreateLayoutSystem( heap );
//  pG2dUtil->SetDefaultFont( const char * file );
  pG2dUtil->CreateLayoutEnv( heap );
//  pG2dUtil->CreateLayoutWork( GFL_NELEMS(layoutData), heap );
//  pG2dUtil->CreateLayoutResource( GFL_NELEMS(resTbl), heap );
//  pG2dUtil->LoadLayoutResource( 0, resTbl, GFL_NELEMS(resTbl), heap, true );
//  pG2dUtil->TransferLayoutTexture();
//  pG2dUtil->SetLayoutWork( layoutData, 0, GFL_NELEMS(layoutData) );
//  pG2dUtil->CreateMessageData( const wchar_t * arcFilePath, u32 datID, gfl::str::MsgData::LoadType loadType, Heap * heap );
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   2D֘A폜
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete2D(void)
{
//  pG2dUtil->DeleteMessageData();
//  pG2dUtil->DeleteLayoutResource();
//  pG2dUtil->DeleteLayoutWork2();
  pG2dUtil->DeleteLayoutEnv();
  pG2dUtil->DeleteLayoutSystem();

  GFL_DELETE  pG2dUtil;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief   3D֘A쐬
 *
 * @param   heap    q[v
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Create3D( app::util::Heap * heap )
{
  pG3dUtil = GFL_NEW( heap->pHeap ) app::util::G3DUtil();

  pG3dUtil->CreateG3dSystem( heap );
  pG3dUtil->CreateG3dScene( ARCID_KISEKAE_DATA, GARC_kisekae_data_env_BCENV, heap, false );

  // J
  const app::util::G3DUtil::CAMERA_CREATE_DATA dat[] =
  {
    {
      gfl::math::VEC3( 0.0f, 0.0f, 800.0f ),  // Jʒu
      gfl::math::VEC3( 0.0f, 0.0f, 0.0f ),   // _ʒu
      1.0f,
      1000.0f,
      gfl::grp::g3d::StereoCamera::FOVY_RADIAN_DEFAULT,
      0.0f,
      gfl::grp::g3d::StereoCamera::DEPTH_LEVEL_DEFAULT,
      gfl::grp::g3d::StereoCamera::DEPTH_RANGE_DEFAULT,
      gfl::grp::g3d::StereoCamera::REAL_SWITCH_DEFAULT
    },
  };
  pG3dUtil->CreateG3dCamera( heap, app::util::G3DUtil::SETUP_CAMERA_UPPER, &dat[0], NULL );
  m_default_camera = pG3dUtil->GetUpperCamera();

//  app::util::G3DUtil::LIGHT_CREATE_DATA light;
  // Cg̐
//  pG3dUtil->CreateG3dLight( heap, &light, 2 );

/*
  app::util::G3DUtil::SCENE_CREATE_DATA data;
  data.user_calc_group_num = 1;
  data.user_draw_group_num = SCENE_NUM + POKE_DRAWGROUP_NUM;
*/


  pG3dUtil->CreateG3dModelWork( heap, FIELD_DEMO_MODEL_DATA_MAX );

  pG3dUtil->CreateEdgeSystem( pGraSystem, app::util::G3DUtil::EDGE_SET_FLAG_UPPER, heap );
  pG3dUtil->SetupG3dScene();

  // |Pf`VXȅ
  m_poke_sys = GFL_NEW(heap->pHeap) poke_tool::PokeModelSystem();
  m_poke_sys->InitSystem( heap->pHeapAllocator,
                          heap->pDevHeapAllocator,
                          GFL_SINGLETON_INSTANCE(gamesystem::GameManager)->GetFileReadManager());
  

}

//--------------------------------------------------------------------------------------------
/**
 * @brief   3D֘A폜
 *
 * @param   none
 *
 * @return  none
 */
//--------------------------------------------------------------------------------------------
void GraphicWork::Delete3D(void)
{
  // IOɁAftHg̃Jɖ߂
  pG3dUtil->SetCamera( app::util::G3DUtil::SETUP_CAMERA_UPPER, m_default_camera);
  
  // |PfVXȅI
  m_poke_sys->ExitSystem();
  GFL_DELETE(m_poke_sys);
  
  pG3dUtil->DeleteG3dModelWork();

  pG3dUtil->DeleteEdgeSystem();
  
//  app::util::G3DUtilDeleteTrModelEnv( pG3dUtil );

//  pG3dUtil->DeleteG3dLight();
  pG3dUtil->DeleteG3dCamera();

  pG3dUtil->DeleteG3dScene();
  pG3dUtil->DeleteG3dSystem();

  GFL_DELETE  pG3dUtil;
}

//=============================================================================================
/**
 * @brief V[PXvC[
 *
 * @param   heap  app::util::heap
 */
//=============================================================================================
void GraphicWork::CreateSeqPlayer( app::util::Heap * heap )
{
  // V[PXvC[̍쐬
  {
    // ʂ̃_[^[Qbg擾
    gfl::grp::FrameBufferManager* frameBufferManager = pGraSystem->GetFrameBufferManager( );
    gfl::grp::RenderTarget* renderTarget = frameBufferManager->GetRenderTarget(
                                           pGraSystem->GetCurrentFrameBufferID( gfl::grp::DISPLAY_UPPER ) );
    
    static xy_system::sequence::Param param = {
      heap->pHeap,
      heap->pHeapAllocator,
      heap->pDevHeapAllocator,
      pG3dUtil->GetScene(),
      pG3dUtil->GetUpperCamera(),
      renderTarget,   // ʃ_[^[Qbg
      m_poke_sys,     // Ƀ|PfVXe
      m_simple_poke,  // |PSimpleParam̔z
      m_pokecount,    // Simpleparam̐
      0,//f`
      0,//fvZ
      0,//|Pf`
      0,//|PfvZ
      0,//p[eBN`
      0,//p[eBNvZ
      0,//XN[p[eBN`
      0,//XN[p[eBNvZ
      
      NULL // app::util::G2dUtil*
      /*StrBuf̔z*/
      /*StrBuf̔z̐*/
    };
    
    m_player = GFL_NEW(heap->pHeap) xy_system::sequence::Player(&param);

    m_player->LoadRequest(ARCID_DEMO_SEQ, GARC_demo_sequence_trade_demo01_BSEQ );
/*
 * 
 *     if(m_param->DemoMode==MODE_EXCHANGE){
 *       m_player->LoadRequest(ARCID_DEMO_SEQ, GARC_demo_sequence_trade_demo01_BSEQ );
 *     }else if(m_param->DemoMode==MODE_UPLOAD){
 *       m_player->LoadRequest(ARCID_DEMO_SEQ, GARC_demo_sequence_trade_demo00_BSEQ );
 *     }else if(m_param->DemoMode==MODE_DOWNLOAD){
 *       m_player->LoadRequest(ARCID_DEMO_SEQ, GARC_demo_sequence_trade_demo02_BSEQ );
 *     }else if(m_param->DemoMode==MODE_EXCHANGE_DOWNLOAD){
 *       m_player->LoadRequest(ARCID_DEMO_SEQ, GARC_demo_sequence_trade_demo03_BSEQ );
 *     }
 */
    GFL_PRINT("fV[PXf[^ǂݍ end\n");
    
    // A񓯊ǂݍ݂ɑΉĂȂAIɂ͑Ή邱ƂɂȂ邾낤̂ŁA
    // {͓ǂݍ݊mFƍs悤ɂĂ
    if(m_player->IsReady())
    {
      // hogehoge
    }
    m_player->Play();
    
  }  
}


//=============================================================================================
/**
 * @brief V[PXvC[
 *
 * @param   none    
 */
//=============================================================================================
void GraphicWork::DeleteSeqPlayer( void )
{
  m_player->UnLoad(true);
  GFL_DELETE(m_player);
}

//=============================================================================================
/**
 * @brief V[PvC[p̃|P𐶐
 *
 * @param   index   
 * @param   core    
 *
 * @retval  int   
 */
//=============================================================================================
int GraphicWork::SetupSimpleParam( int index, pml::pokepara::CoreParam *core )
{
  if(core!=NULL){
    m_simple_poke[index].monsNo = core->GetMonsNo();
    m_simple_poke[index].formNo = core->GetFormNo();
    m_simple_poke[index].sex    = core->GetSex();
    m_simple_poke[index].isRare = core->IsRare();
    m_simple_poke[index].isEgg  = core->IsEgg(pml::pokepara::CHECK_BOTH_EGG);
    m_simple_poke[index].perRand = 0;
    return 1;
  }

  return 0;
}

//=============================================================================================
/**
 * @brief V[PvC[Iʒm
 *
 * @retval  bool tru:I false:r
 */
//=============================================================================================
bool GraphicWork::isPlayEnd( void )
{
  return m_playend;
}

} // field_demo
} // app
