//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		FieldDemoApp.h
 *	@brief  tB[hfAv
 *	@author	Masayuki Onoue
 *	@date		2012.08.23
 *
 * namespace	app::field_demo::
 *
 * 5279-6982		Avpev[gt@C쐬ꂽƂp^O
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#if !defined( __FIELDDEMOAPP_H__ )
#define __FIELDDEMOAPP_H__

#include <gflib.h>
#include <gfl_Device.h>
#include "gamesystem/GameProc.h"
#include "system/sequence/Player.h"

/**
  * @namespace app::field_demo
  * @brief     tB[hf
  */
namespace app {
namespace field_demo {

/// f̃[h
enum DEMO_MODE{
  MODE_EXCHANGE=0,        ///< ʏ̌f
  MODE_UPLOAD,            ///< Abv[ĥ
  MODE_DOWNLOAD,          ///< _E[ĥ
  MODE_EXCHANGE_DOWNLOAD, ///< ă_E[h
  MODE_MAX,
};

/// Oݒp[^if[^EĨf[^Ȃǁj
struct APP_PARAM{
  DEMO_MODE                DemoMode;       ///< f̍Đ[h
  pml::pokepara::CoreParam *pMyPoke;       ///< ̃|P
  pml::pokepara::CoreParam *pOthersPoke;   ///< ̃|P
  savedata::MyStatus       *pMyStatus;     ///< vC[Xe[^X
  gfl::str::StrBuf         *pPartnerName;  ///< ̖O
  xynet::XyNetManager      *pXyNetManager; ///< lbg}l[W[NX̃|C^

  //=============================================================================================
  /**
   * @brief tB[hŌĂяof
   *
   * @param   mine		    õ|PCoreParam
   * @param   others		  󂯎̃|PCoreParam
   * @param   mystatus		  savedata::MyStatus
   * @param   partner_name	̖O
   */
  //=============================================================================================
  inline void InitDemoField( pml::pokepara::CoreParam *mine, pml::pokepara::CoreParam *others, 
                             savedata::MyStatus *mystatus, gfl::str::StrBuf *partner_name )
  {
    DemoMode     = MODE_EXCHANGE;
    pMyPoke      = mine;
    pOthersPoke  = others;
    pMyStatus    = mystatus;
    pPartnerName = partner_name;
    pXyNetManager= NULL;
  }

  //=============================================================================================
  /**
   * @brief ʐMŌĂяof(ʏŁj
   *
   * @param   mine		    õ|PCoreParam
   * @param   others		  󂯎̃|PCoreParam
   * @param   mystatus		  savedata::MyStatus
   * @param   partner_name	̖O
   */
  //=============================================================================================
  inline void InitDemoNetNormal( pml::pokepara::CoreParam *mine, pml::pokepara::CoreParam *others, 
                                 savedata::MyStatus *mystatus, gfl::str::StrBuf *partner_name,
                                 xynet::XyNetManager *net_manager )
  {
    DemoMode     = MODE_EXCHANGE;
    pMyPoke      = mine;
    pOthersPoke  = others;
    pMyStatus    = mystatus;
    pPartnerName = partner_name;
    pXyNetManager= net_manager;
  }

  //=============================================================================================
  /**
   * @brief ʐMŌĂяofiAbv[ĥݔŁj
   *
   * @param   mine		    õ|PCoreParam
   * @param   others		  󂯎̃|PCoreParam
   * @param   mystatus		  savedata::MyStatus
   * @param   partner_name	̖O
   */
  //=============================================================================================
  inline void InitDemoNetUpload( pml::pokepara::CoreParam *mine, pml::pokepara::CoreParam *others, 
                                 savedata::MyStatus *mystatus, gfl::str::StrBuf *partner_name,
                                 xynet::XyNetManager *net_manager )
  {
    DemoMode     = MODE_UPLOAD;
    pMyPoke      = mine;
    pOthersPoke  = others;
    pMyStatus    = mystatus;
    pPartnerName = partner_name;
    pXyNetManager= net_manager;
  }
};

class MainSystem;

class Proc : public gamesystem::GameProc {		// NX[gamesystem::GameProc]p
public:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		RXgN^
	 *
	 * @param		prm		Oݒp[^
	 */
	//--------------------------------------------------------------------------------------------
	Proc( APP_PARAM * prm );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		fXgN^
	 */
	//--------------------------------------------------------------------------------------------
	~Proc();

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result InitFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcI
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result EndFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		ProcAbvf[g
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	gfl::proc::Result
	 */
	//--------------------------------------------------------------------------------------------
	virtual gfl::proc::Result UpdateFunc( gfl::proc::Manager * proc_manager );

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		Proc`揈
	 *
	 * @param		proc_manager		gfl::proc::Manager
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	virtual void DrawFunc( gfl::proc::Manager * proc_manager );

  // Aṽt[[g30Ɏw
  virtual gamesystem::FrameMode GetFrameMode(void) const {
    return gamesystem::FRAMEMODE_30;
  }

private:
	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v쐬
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void CreateHeap(void);

	//--------------------------------------------------------------------------------------------
	/**
	 * @brief		VXeq[v폜
	 *
	 * @param		none
	 *
	 * @return	none
	 */
	//--------------------------------------------------------------------------------------------
	void DeleteHeap(void);

private:
	gfl::heap::HeapBase * pHeap;	///< VXeq[v
	MainSystem * pMain;           ///< NX
};


}	// field_demo
}	// app

#endif		// __FIELDDEMOAPP_H__

