//==============================================================================
/**
 * @file	battle_match_proc_select_rule.cpp
 * @brief	og}b`@TuvbN@[I
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 12:58
 */
// =============================================================================

#include <message/msg_battle_match.h>

#include "battle_match_proc_select_rule.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcSelectRule::ProcSelectRule( void ) : ProcBase()
{
	ICHI_PRINT("ProcSelectRule::ProcSelectRule\n");
}

// fXgN^
ProcSelectRule::~ProcSelectRule( void )
{
	ICHI_PRINT("ProcSelectRule::~ProcSelectRule\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectRule::InitFunc( void )
{
	// qviewN
	m_view->RegistSelect5( this );

	// qview擾
	m_view_lower = m_view->GetSubViewSelect5();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_04 );
	m_view_lower->SetTextBattleRule();

	// AjJn
	switch( GetSwitchType() ){
	case SWITCH_SELECT_BUTTON_0:	///< {^0=[t[]Iŗ
		m_view_lower->OffSpecialRule( false );
		m_view_lower->StartAnime( ANMID_LOWER_5_IN_LEFT );
		break;
	case SWITCH_SELECT_BUTTON_1:	///< {^1=[[eBO]Iŗ
		m_view_lower->OffSpecialRule( true );
		m_view_lower->StartAnime( ANMID_LOWER_5_IN_LEFT );
		break;
	case SWITCH_RETURN:				///< ߂ł
		m_view_lower->StartAnime( ANMID_LOWER_5_IN_RIGHT );
		break;
	default:
		GFL_ASSERT(0);
		break;
	}

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectRule::UpdateFunc( void )
{

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectRule::ExitFunc( void )
{
	// qview
	if( m_view->CancelSelect5() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief		{^ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectRule::OnButtonAction( int button_no )
{
	// 5Ȃ̂łȊÕ{^͉Ȃ͂
	GFL_ASSERT_MSG( button_no<5, "Ⴄ{^Ă button_no->%d \n", button_no );

	switch( button_no ){
	// VO
	case 0:
	// _u
	case 1:
	// gv
	case 2:
	// [e[V
	case 3:
	// XyV
	case 4:
		// @todo [eBOĂ
		SetSwitchType( SWITCH_SELECT_BUTTON_0 ); // Iސݒ
		SetFinish( NEXT_SELECT_POKE );
		break;
	}

	// AjĐ
	m_view_lower->StartAnime( ANMID_LOWER_5_OUT_LEFT );		// ɃtF[hAEg
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectRule::OnReturnAction( void )
{
	m_view_lower->StartAnime( ANMID_LOWER_5_OUT_RIGHT );		// EɃtF[hAEg

	// Iސݒ
	SetSwitchType( SWITCH_RETURN );

	ICHI_PRINT("߂鉟\n");
	SetFinish( NEXT_SELECT_MODE_RANDOM );
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

