//==============================================================================
/**
 * @file	battle_match_proc_select_poke.cpp
 * @brief	og}b`@TuvbN@莝/og{bNXI
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 15:57
 */
// =============================================================================

#include <message/msg_battle_match.h>

#include "battle_match_proc_select_poke.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc )

// RXgN^
ProcSelectPoke::ProcSelectPoke( void ) : ProcBase()
{
	ICHI_PRINT("ProcSelectPoke::ProcSelectPoke\n");
}

// fXgN^
ProcSelectPoke::~ProcSelectPoke( void )
{
	ICHI_PRINT("ProcSelectPoke::~ProcSelectPoke\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectPoke::InitFunc( void )
{
	// qviewN
	m_view->RegistSelect2( this );

	// qview擾
	m_view_lower = m_view->GetSubViewSelect2();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_06 );
	m_view_lower->SetTextButton( battle_match_button_15, battle_match_button_16, battle_match_button_14 );

	// AjJn
	switch( GetSwitchType() ){
	case SWITCH_SELECT_BUTTON_0:	///< {^1=[VO]ŗ
	case SWITCH_SELECT_BUTTON_1:	///< {^2=[_u]ŗ
	case SWITCH_SELECT_BUTTON_2:	///< {^3=[gv]ŗ
	case SWITCH_SELECT_BUTTON_3:	///< {^4=[[e[V]ŗ
	case SWITCH_SELECT_BUTTON_4:	///< {^5=[XyV]ŗ
		m_view_lower->StartAnime( ANMID_LOWER_2_IN_LEFT );
		break;
	case SWITCH_RETURN:				///< ߂ł
		m_view_lower->StartAnime( ANMID_LOWER_2_IN_RIGHT );
		break;
	default:
		GFL_ASSERT(0);
		break;
	}

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectPoke::UpdateFunc( void )
{

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectPoke::ExitFunc( void )
{
	// qview
	if( m_view->CancelSelect2() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief		{^ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectPoke::OnButtonAction( int button_no )
{
	// QȂ̂łȊÕ{^͉Ȃ͂
	GFL_ASSERT_MSG( button_no<2, "Ⴄ{^Ă button_no->%d \n", button_no );

	switch( button_no ){
	///< og{bNXI
	case 0:
		SetSwitchType( SWITCH_SELECT_BUTTON_0 ); // Iސݒ
		SetFinish( NEXT_CHALLENGE );
		break;
	///< ĂI
	case 1:
		SetSwitchType( SWITCH_SELECT_BUTTON_1 ); // Iސݒ
		SetFinish( NEXT_CHALLENGE );
		break;
	}

	// AjJn
	m_view_lower->StartAnime( ANMID_LOWER_2_OUT_LEFT );
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectPoke::OnReturnAction( void )
{
	m_view_lower->StartAnime( ANMID_LOWER_2_OUT_RIGHT );		// EɃtF[hAEg

	// Iސݒ
	SetSwitchType( SWITCH_RETURN );

	ICHI_PRINT("߂鉟\n");
	SetFinish( NEXT_SELECT_RULE );
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)
