//==============================================================================
/**
 * @file	battle_match_proc_select_mode_random.cpp
 * @brief	og}b`@TuvbN@_}b`[hI
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 12:06
 */
// =============================================================================

#include <message/msg_battle_match.h>

#include "battle_match_proc_select_mode_random.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcSelectModeRandom::ProcSelectModeRandom( void ) : ProcBase()
{
	ICHI_PRINT("ProcSelectModeRandom::ProcSelectModeRandom\n");
}

// fXgN^
ProcSelectModeRandom::~ProcSelectModeRandom( void )
{
	ICHI_PRINT("ProcSelectModeRandom::~ProcSelectModeRandom\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectModeRandom::InitFunc( void )
{
	// qviewN
	m_view->RegistSelect2( this );

	// qview擾
	m_view_lower = m_view->GetSubViewSelect2();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_03 );
	m_view_lower->SetTextButton( battle_match_button_07, battle_match_button_08, battle_match_button_14 );

	// AjJn
	switch( GetSwitchType() ){
	case SWITCH_SELECT_BUTTON_0:	///< {^0=[_}b`O]Iŗ
		m_view_lower->StartAnime( ANMID_LOWER_2_IN_LEFT );
		break;
	case SWITCH_RETURN:				///< ߂ł
		m_view_lower->StartAnime( ANMID_LOWER_2_IN_RIGHT );
		break;
	default:
		GFL_ASSERT(0);
		break;
	}

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectModeRandom::UpdateFunc( void )
{

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSelectModeRandom::ExitFunc( void )
{
	// qview
	if( m_view->CancelSelect2() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief		{^ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectModeRandom::OnButtonAction( int button_no )
{
	// 2Ȃ̂łȊÕ{^͉Ȃ͂
	GFL_ASSERT_MSG( button_no<2, "Ⴄ{^Ă button_no->%d \n", button_no );

	switch( button_no ){
	// t[
	case 0:
		SetSwitchType( SWITCH_SELECT_BUTTON_0 ); // Iސݒ
		SetFinish( NEXT_SELECT_RULE );
		break;
	// [eBO
	case 1:
		SetSwitchType( SWITCH_SELECT_BUTTON_1 ); // Iސݒ
		SetFinish( NEXT_SELECT_RULE );
		break;
	}

	// AjĐ
	m_view_lower->StartAnime( ANMID_LOWER_2_OUT_LEFT );		// ɃtF[hAEg
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void ProcSelectModeRandom::OnReturnAction( void )
{
	m_view_lower->StartAnime( ANMID_LOWER_2_OUT_RIGHT );		// EɃtF[hAEg

	// Iސݒ
	SetSwitchType( SWITCH_RETURN );

	ICHI_PRINT("߂鉟\n");
	SetFinish( NEXT_SELECT_MATCH );
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

