//==============================================================================
/**
 * @file	battle_match_proc_search.cpp
 * @brief	og}b`@TuvbN@ΐ푊茟
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 16:56
 */
// =============================================================================


#include <message/msg_battle_match.h>

#include "battle_match_proc_search.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcSearch::ProcSearch( void ) : ProcBase()
{
	ICHI_PRINT("ProcSearch::ProcSearch\n");
}

// fXgN^
ProcSearch::~ProcSearch( void )
{
	ICHI_PRINT("ProcSearch::~ProcSearch\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSearch::InitFunc( void )
{
	// qviewN
	m_view->RegistResult();

	// qview擾
	m_view_lower = m_view->GetSubViewResult();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_09 );

	// AjJn
	switch( GetSwitchType() ){
	case SWITCH_SELECT_BUTTON_0:	///< {^0=[킷]Iŗ
		m_view_lower->StartAnime( ANMID_LOWER_RESULT );
		break;
	case SWITCH_RETURN:				///< ߂ł
		break;
	default:
		GFL_ASSERT(0);
		break;
	}


	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSearch::UpdateFunc( void )
{
	enum{
		SEQ_MATCH_START,	// }b`OJn
		SEQ_MATCH_WAIT,		// }b`O҂
		SEQ_TRANS_DATA,		// f[^M
		
		SEQ_MATCH_CANCEL,	// }b`OLZ
		SEQ_MATCH_CANCEL_WAIT,// }b`OLZ҂
	};

	switch( m_seq ){
	case SEQ_MATCH_START:		// }b`OJn
		{
			// ݂̎Ԃۑ
			gfl::std::DateTime::GetNow( &m_connectStartingTime );

			m_net->Connect();

			GFL_PRINT("}b`OEEE\n");
			m_seq = SEQ_MATCH_WAIT;
		}
		break;

	case SEQ_MATCH_WAIT:		// }b`O҂
		{
			if( m_net->IsConnect() == true )
			{
				GFL_PRINT("}b`O\n");
				m_seq = SEQ_TRANS_DATA;
			}

			// 30bŃ^CAEg
			if( IsTimeout( 30000 ) )
			{
				m_seq = SEQ_MATCH_CANCEL;
				GFL_PRINT("}b`O^CAEg\n");
			}
		}
		break;

	case SEQ_TRANS_DATA:		// ݂̃f[^M
		{
			//@todo
			// ogO
			SetFinish( NEXT_BATTLE_BEGIN );
		}
		break;

	case SEQ_MATCH_CANCEL:
		{
			m_net->SetReqDisconnect();
			m_seq = SEQ_MATCH_CANCEL_WAIT;
		}
		break;

	case SEQ_MATCH_CANCEL_WAIT:
		{
			if( m_net->IsEnd() )
			{
				SetFinish( NEXT_SELECT_MATCH );
			}
		}
		break;
	}

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcSearch::ExitFunc( void )
{
	// qview
	if( m_view->CancelResult() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

