//==============================================================================
/**
 * @file	battle_match_proc_challenge.cpp
 * @brief	og}b`@TuvbN@I
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 16:29
 */
// =============================================================================

#include <message/msg_battle_match.h>

#include "battle_match_proc_challenge.h"


GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)
GFL_NAMESPACE_BEGIN(proc)

// RXgN^
ProcChallenge::ProcChallenge( void ) : ProcBase()
{
	ICHI_PRINT("ProcChallenge::ProcChallenge\n");
}

// fXgN^
ProcChallenge::~ProcChallenge( void )
{
	ICHI_PRINT("ProcChallenge::~ProcChallenge\n");
}

//--------------------------------------------------------------------------
/**
 * @brief			֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcChallenge::InitFunc( void )
{
	// qviewN
	m_view->RegistSelect1( this );

	// qview擾
	m_view_lower = m_view->GetSubViewSelect1();

	// ^Cg
	m_view_lower->SetTextTitle( battle_match_guide_07 );
	m_view_lower->SetTextButton( battle_match_button_17, battle_match_button_14 );

	// AjJn
	switch( GetSwitchType() ){
	case SWITCH_SELECT_BUTTON_0:	///< {^0=[og{bNX]Iŗ
	case SWITCH_SELECT_BUTTON_1:	///< {^1=[Ă]Iŗ
		m_view_lower->StartAnime( ANMID_LOWER_1_IN_LEFT );
		break;
	case SWITCH_RETURN:				///< ߂ł
		m_view_lower->StartAnime( ANMID_LOWER_1_IN_RIGHT );
		break;
	default:
		GFL_ASSERT(0);
		break;
	}

	return RESULT_FINISH;
}

//--------------------------------------------------------------------------
/**
 * @brief			XV֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂExitFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcChallenge::UpdateFunc( void )
{

	if( m_isEnd == true )
	{
		return RESULT_FINISH;
	}
	
	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief			I֐
 * @return		result
 * 
 * @note			RES_FINISHԂƂUpdateFuncɐi
 */
//--------------------------------------------------------------------------
RESULT ProcChallenge::ExitFunc( void )
{
	// qview
	if( m_view->CancelSelect1() == true )
	{
		return RESULT_FINISH;
	}

	return RESULT_CONTINUE;
}

//--------------------------------------------------------------------------
/**
 * @brief		{^ʒm
 */
//--------------------------------------------------------------------------
void ProcChallenge::OnButtonAction( int button_no )
{
	// 1Ȃ̂łȊÕ{^͉Ȃ͂
	GFL_ASSERT_MSG( button_no<1, "Ⴄ{^Ă button_no->%d \n", button_no );

	switch( button_no ){
	// 傤񂷂
	case 0:
		SetSwitchType( SWITCH_SELECT_BUTTON_0 ); // Iސݒ
		SetFinish( NEXT_SEARCH );
		break;
	}

	// AjĐ
	m_view_lower->StartAnime( ANMID_LOWER_1_OUT_LEFT );		// ɃtF[hAEg
}

//--------------------------------------------------------------------------
/**
 * @brief		^[ʒm
 */
//--------------------------------------------------------------------------
void ProcChallenge::OnReturnAction( void )
{
	m_view_lower->StartAnime( ANMID_LOWER_1_OUT_RIGHT );		// EɃtF[hAEg

	// Iސݒ
	SetSwitchType( SWITCH_RETURN );

	ICHI_PRINT("߂鉟\n");
	SetFinish( NEXT_SELECT_POKE );
}

GFL_NAMESPACE_END(proc)
GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)


