//==============================================================================
/**
 * @file	battle_match_net.cpp
 * @brief	og}b`O@ʐM
 * @author	ichiraku_katsuhiko
 * @data	2012/08/23, 17:36
 */
// =============================================================================

#include "battle_match_net.h"

GFL_NAMESPACE_BEGIN(netapp)
GFL_NAMESPACE_BEGIN(battle_match)

// RXgN^
NetSystem::NetSystem( void ) :
				m_pWifiMatching( NULL ),
				m_pricipalId(0), m_tiketId(0),
				m_seq(SEQ_NONE),
				m_isConnect(false), m_isEnd(false), m_reqDisconnect(false)
{
  m_pSysHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_NETWORK );
  m_pDevHeap = gfl::heap::Manager::GetHeapByHeapId( HEAPID_RESIDENT_DEVICE );
}

// fXgN^
NetSystem::~NetSystem( void )
{
	GFL_SAFE_DELETE( m_pWifiMatching );
}

//--------------------------------------------------------------------------
/**
 * @brief		XV
 */
//--------------------------------------------------------------------------
void NetSystem::Update( void )
{
	if( m_pWifiMatching == NULL )
	{
		return;
	}

	// }b`OXV
	m_pWifiMatching->Update();

	switch( m_seq ){
	case SEQ_NONE:						///< Ȃ
		/* nothing */
		break;
	case SEQ_MATCHING:				///< }b`O
		if( m_pWifiMatching->IsMatchMake() )
		{
			m_seq = SEQ_CONNECT;
			ICHI_PRINT("SEQ_CONNECT\n");
		}

		// rLZ
		if( m_reqDisconnect == true )
		{
			m_seq = SEQ_DISCONNECT;
			ICHI_PRINT("Update_Wifi 1\n");
		}
		break;
	case SEQ_CONNECT:				///< }b`O
		/*
		 * 󃋁[v
		 */
		m_isConnect = true;

		if( m_reqDisconnect == true )
		{
			m_seq = SEQ_DISCONNECT;
		}
		break;
	case SEQ_DISCONNECT:			///< ؒf
		m_pWifiMatching->Disconnect();
		m_seq = SEQ_DISCONNECT_WAIT;
		ICHI_PRINT("Update_Wifi 2\n");
		break;
	case SEQ_DISCONNECT_WAIT:///< ؒf҂
		if( m_pWifiMatching->IsFinished() )
		{
			m_isEnd = true;
			ICHI_PRINT("Update_Wifi 3\n");

			// }b`ONX폜
			GFL_SAFE_DELETE( m_pWifiMatching );
			m_seq = SEQ_NONE;
		}
		break;
	}
}

//--------------------------------------------------------------------------
/**
 * @brief		ڑ
 */
//--------------------------------------------------------------------------
void NetSystem::Connect( void )
{
	//@todo
	m_pricipalId = 12345;
	m_tiketId = 789123;
	
	// }b`ONX쐬
	m_pWifiMatching = GFL_NEW( m_pSysHeap ) netapp::WifiMatching();

	//------------------------------------------------------------
	//------------------------------------------------------------
	// }b`O쐬
	//------------------------------------------------------------
	ENUM_MATCHMAKE_GAMEMODE		gameMode;
	ENUM_MATCHMAKE_JOIN_NUM		joinNum;
	gflnet::nex::NexMatchMakingClient::NexMatchMakingRuleList list;
	gflnet::nex::NexMatchMakingRule rule1( 0, m_pricipalId, m_pricipalId, m_pricipalId );
	gflnet::nex::NexMatchMakingRule rule2( 1, m_tiketId, m_tiketId, m_tiketId );

	list.push_back( &rule1 );
	list.push_back( &rule2 );

	// @todo
	gameMode = MATCHMAKE_GAMEMODE_RNDFREE_S;
	joinNum	 = MATCHMAKE_JOIN_DEFAULT;
	//------------------------------------------------------------
	//------------------------------------------------------------

	m_pWifiMatching->Initialize( m_pSysHeap, m_pDevHeap,
														 &list, gameMode, joinNum,
														 netapp::WifiMatching::MATCH_AUTO, true );
	GFL_PRINT("WifiMathing: gameMode %d JoinNum %d \n", gameMode, joinNum );

	m_seq = SEQ_MATCHING;
}

//--------------------------------------------------------------------------
/**
 * @brief		NetGame擾
 * @param		NetGame
 */
//--------------------------------------------------------------------------
gflnet::p2p::NetGame* NetSystem::GetNetGame( void )
{
	GFL_ASSERT( m_pWifiMatching );
	return m_pWifiMatching->GetNetGame();
}

GFL_NAMESPACE_END(battle_match)
GFL_NAMESPACE_END(netapp)

