//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkBossUpdater.h
 *  @brief   lbg[NŃzObBOSSf[^XVRg[NX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#pragma once
#if !defined( __APP_HOLOGRAMMAIL_NETWORK_BOSS_UPDATER_H__)
#define __APP_HOLOGRAMMAIL_NETWORK_BOSS_UPDATER_H__

#include <gflib.h>
#include <gflnet.h>
#include <gamesystem/GameProc.h>
#include <app/util/app_util_heap.h>
#include "app/hologram_mail/network/app_hologrammail_NetworkParentViewListener.h"
#include "app/hologram_mail/network/app_hologrammail_NetworkMailListView.h"



GFL_NAMESPACE_BEGIN(savedata)
  class BossHistory;
GFL_NAMESPACE_END(savedata)

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
GFL_NAMESPACE_BEGIN(boss)

/**
*  @brief   lbg[NŃzObBOSSf[^WJRg[NX
*/
class NetworkBossUpdater : public app::hologrammail::NetworkParentViewListener, public gflnet::boss::BossEventListener
{
  GFL_FORBID_COPY_AND_ASSIGN(NetworkBossUpdater);
public:
  /**
   * @brief IR[h
   */
  typedef enum
  {
    E_RET_CONTINUE,     //!< p
    E_RET_CANCEL,       //!< LZ
    E_RET_LOADED,       //!< f[^ēǂݍ݂
  }RET_CODE;

  /**
   * @brief j[
   */
  typedef enum
  {
    E_MENU_WIRELESS,     //!< CXʐM
    E_MENU_WIFI,         //!< C^[lbgʐM
    E_MENU_BACK,         //!< ߂
    //
    E_MENU_MAX,
  }MenuNum;

public:
  //-----------------------------------------------------------------------
  // RXgN^EfXgN^
  //-----------------------------------------------------------------------
  /**
   *  @brief  RXgN^
   *  @param  param (OAllocĂ)
   */
  NetworkBossUpdater( app::util::Heap* heap, app::hologrammail::NetworkParentView* view, gflnet::boss::BossManager* bossMgr );
  /**
   *  @brief  fXgN^
   */
  virtual ~NetworkBossUpdater();

  //-----------------------------------------------------------------------
  //
  //-----------------------------------------------------------------------
  void Initialize( gamesystem::GameManager* gameMgr );
  void Finalize( void );


  RET_CODE Update( void );
  void Draw( void );


  //-----------------------------------------------------------------------
  // NetworkParentViewListener̎
  //-----------------------------------------------------------------------
public:
  /**
   * @brief Xg莞ɌĂ΂
   *        Xg͒~[hɈڍsA
   *        NetworkParentView::RestartListĂ΂ȂƍĊJȂB
   *
   * @param list_index  Xg̃CfbNX
   */
  virtual void OnSelectedList( u16 list_index );

  /**
   * @brief Yes{^ꂽɌĂ΂
   */
  virtual void OnSelectedYesButton( void );
  /**
   * @brief No{^ꂽɌĂ΂
   */
  virtual void OnSelectedNoButton( void );

  /**
   * @brief bZ[W\I
   */
  virtual void OnPrintMessageFinished( void );

public:
  // for BossManager
  virtual void OnBossNewArrivalData( const u32 serialId );
  virtual void OnBossNewArrivalDataEmpty( void );
  virtual bool OnBossReadData( const nn::boss::NsDataHeaderInfo* pHeader , const size_t bodySize , const u8* pBody );
  virtual void OnBossRecvFileList( const char* pTaskName , const nn::boss::NsaList::NsaInformation* pFileList , const u32 fileNum );
  virtual void OnBossRecvFileListFailed( const char* pTaskName , const nn::Result& result );
  virtual void OnBossError( const nn::Result& result );
  virtual void OnBossTaskError( const char* pTaskName , const u32 errorCode );

private:
  RET_CODE UpdateSequence( void );
  bool IsUpdatedToday( void );
  void StartMenu( void );
  void CreateListData( void );
  void DeleteListData( void );
private:
  /**
   * @brief V[PXf[^
   */
  typedef enum
  {
    SEQUENCE_ASK_UPDATING,      //!< BOSSXVmF
    SEQUENCE_MENU,              //!< j[
    SEQUENCE_UPDATE_WIFI,       //!< WIFIXV
    SEQUENCE_UPDATE_WIRELESS,   //!< WIRELESSXV
    SEQUENCE_ERROR,             //!< G[
    SEQUENCE_CANCEL,            //!< LZ
    SEQUENCE_END,               //!< I
  }Sequence;

private:
  gflnet::boss::BossManager*            m_bossMgr;        //!< BOSS}l[W
  //
  savedata::BossHistory*                m_bossHistory;    //!< Boss
  //
  app::hologrammail::NetworkParentView* m_parent_view;    //!< lbg[NyAgVIEW
  app::util::Heap*                      m_heap;           //!< q[v
  Sequence                              m_sequence;       //!< V[PX
  //
  u32                                   m_dummyCounter;
  //
  app::hologrammail::NetworkMailListView::ListData*  m_list_data;     //!< XgVIEW
};


GFL_NAMESPACE_END(boss)
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)



#endif    // __APP_HOLOGRAMMAIL_NETWORK_BOSS_UPDATER_H__


