//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *  @file    debug_app_hologrammail_NetworkBossUpdater.cpp
 *  @brief   lbg[NŃzObBOSSf[^XVRg[NX
 *  @author  suzuki_hisanao
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include <Gamesystem/GameProcManager.h>
#include <app/util/app_util_Common.h>
#include "app/hologram_mail/network/app_hologrammail_NetworkParentView.h"
#include "app_hologrammail_NetworkBossUpdater.h"
#include <savedata/sv_boss_history.h>

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(hologrammail)
GFL_NAMESPACE_BEGIN(boss)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief  RXgN^
 *  @param  param 
 */
NetworkBossUpdater::NetworkBossUpdater( app::util::Heap* heap, app::hologrammail::NetworkParentView* view, gflnet::boss::BossManager* bossMgr ) :
  m_bossMgr( bossMgr ),
  m_parent_view( view ),
  m_heap(heap)
{

}

/**
 *  @brief  fXgN^
 */
NetworkBossUpdater::~NetworkBossUpdater()
{
}



/**
 *  @brief  
 *
 *  @param gameMgr       Q[}l[W
 */
void NetworkBossUpdater::Initialize( gamesystem::GameManager* gameMgr )
{
  m_parent_view->SetVisibleList( false );
  m_parent_view->SetVisibleWindow( false );
  m_parent_view->SetVisibleTouchbar( false );

  //̂ɂāuLIVEv\肷H
  m_parent_view->SetVisibleLiveIcon( false );

  //ʃXg̐ݒs
  CreateListData();
  m_parent_view->SetupList( E_MENU_BACK, 0, m_list_data, E_MENU_MAX );

  //Xi̓o^
  m_parent_view->SetListener( this );

  m_bossHistory = gameMgr->GetGameData()->GetBossHistory();

  // bZ[WuXVmFv
  m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_ASK_UPDATING );
  m_sequence = SEQUENCE_ASK_UPDATING;
}

/**
 *  @brief  I
 */
void NetworkBossUpdater::Finalize( void )
{
  m_bossMgr->RemoveEventListener( this );

  //Xỉ
  m_parent_view->SetListener( NULL );

  DeleteListData();
}

/**
 *  @brief  PROCC
 */
NetworkBossUpdater::RET_CODE NetworkBossUpdater::Update( void )
{
  return this->UpdateSequence();
}

/**
 *  @brief  `
 */
void NetworkBossUpdater::Draw( void )
{
}




//-----------------------------------------------------------------------
// ParentViewListener̎
//-----------------------------------------------------------------------
/**
 * @brief Xg莞ɌĂ΂
 *        Xg͒~[hɈڍsA
 *        NetworkParentView::RestartListĂ΂ȂƍĊJȂB
 *
 * @param list_index  Xg̃CfbNX
 */
void NetworkBossUpdater::OnSelectedList( u16 list_index )
{
  switch( list_index )
  {
    case  E_MENU_WIRELESS:     // Wirelessڑ
      m_sequence = SEQUENCE_UPDATE_WIRELESS;
      m_parent_view->SetVisibleList( false );
      // bZ[WuCXʐMv
      m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_SEARCH_WIRELESS );
      break;

    case  E_MENU_WIFI:        // WIFIڑ
      m_sequence = SEQUENCE_UPDATE_WIFI;
      m_parent_view->SetVisibleList( false );
      // bZ[WuWIFIʐMv
      m_parent_view->StartMessageWithId( app::hologrammail::NetworkMailListView::MSG_BOSS_SEARCH_WIFI );
      break;

    case  E_MENU_BACK:        // ߂
      m_sequence = SEQUENCE_CANCEL;
      break;
  }
}

/**
 * @brief Yes{^ꂽɌĂ΂
 */
// @override
void NetworkBossUpdater::OnSelectedYesButton( void )
{
  StartMenu();
}

/**
 * @brief No{^ꂽɌĂ΂
 */
// @override
void NetworkBossUpdater::OnSelectedNoButton( void )
{
  m_sequence = SEQUENCE_CANCEL;
}

/**
 * @brief bZ[W\I
 */
// @override
void NetworkBossUpdater::OnPrintMessageFinished( void )
{
  if( SEQUENCE_ASK_UPDATING == m_sequence ){
    m_parent_view->StartYesNoMenu();
  }
  else if( SEQUENCE_ERROR == m_sequence ){
    m_sequence = SEQUENCE_CANCEL;
  }
}

//-----------------------------------------------------------------------
// PRIVATE
//-----------------------------------------------------------------------
/**
 * @brief V[PXXV
 */
NetworkBossUpdater::RET_CODE NetworkBossUpdater::UpdateSequence( void )
{
  switch( m_sequence )
  {
    case SEQUENCE_UPDATE_WIRELESS:
      break;

    case SEQUENCE_UPDATE_WIFI:
      break;

    case  SEQUENCE_MENU:
    case  SEQUENCE_ERROR:
    case  SEQUENCE_ASK_UPDATING:
      // I͑҂
      break;

    case SEQUENCE_CANCEL:
      m_parent_view->SetTimerIconVisible(false);
      return E_RET_CANCEL;

    case SEQUENCE_END:
      m_parent_view->SetTimerIconVisible(false);
      return E_RET_LOADED;

    default:
      GFL_ASSERT(0);
  }

  return E_RET_CONTINUE;
}


/**
 * @brief j[ʂ̊Jn
 */
void NetworkBossUpdater::StartMenu( void )
{
  m_parent_view->SetVisibleList( true );
  m_sequence = SEQUENCE_MENU;
}



/**
 * @brief Xgf[^
 */
void NetworkBossUpdater::CreateListData( void )
{
  m_list_data = GFL_NEW_ARRAY( m_heap->GetSystemHeap() ) app::hologrammail::NetworkMailListView::ListData[E_MENU_MAX];

  // j[ڗpeLXgID
  u32 msgId[E_MENU_MAX] = {
      msg_boss_menu_05, msg_boss_menu_06, msg_boss_menu_07
  };

  for( int i=0; i<E_MENU_MAX; ++i )
  {
    m_list_data[i].string = GFL_NEW(m_heap->GetSystemHeap()) gfl::str::StrBuf( 64, m_heap->GetSystemHeap() ); // Xgɕ\镶
    m_parent_view->GetString( m_list_data[i].string, msgId[i] );
  }
}


/**
 * @brief Xgf[^j
 */
void NetworkBossUpdater::DeleteListData( void )
{
  for( int i=0; i<E_MENU_MAX;++i )
  {
    GFL_SAFE_DELETE( m_list_data[i].string );
  }
  GFL_DELETE_ARRAY m_list_data;
}



/**
 * @brief  {͍XVς݂
 *
 * @return ɍXVς
 */
bool NetworkBossUpdater::IsUpdatedToday( void )
{
  return true;
}


//------------------------------------------------------------------
/**
* @brief Vf[^ʒmCxg
* @param[in] serialId     f[^̃VAID
*
*   Vf[^BOSSXg[WɓƂʒmCxgłB
*/
//------------------------------------------------------------------
void NetworkBossUpdater::OnBossNewArrivalData( const u32 serialId )
{
}


//------------------------------------------------------------------
/**
* @brief  VmFf[^̎ɔsCxg
*/
//------------------------------------------------------------------
void NetworkBossUpdater::OnBossNewArrivalDataEmpty( void )
{
}

//------------------------------------------------------------------
/**
* @brief f[^ǂݍ݊Cxg
*
* @param[in] pHeader    f[^wb_(NsDataHeaderInfo)
* @param[in] bodySize     {fBTCY
* @param[in] pBody      f[^{
* @return   true : lς݃tOONɂiȍ~̃Xi[ɂʒm܂j
*       false: lς݃tOONɂȂiȍ~̃Xi[ɂʒm܂j
*
*       struct NsDataHeaderInfo
*       {
*          s64 titleId;         //64rbg̃^CgID
*          bit32 flags;         //NSD̃tO
*            bit32 dataType;        //NSD̃f[^^Cv
*            s32 length;          //NSD̒
*            u32 serialId;        //NSD̃VAID
*            u32 version;         //NSD̃o[Wԍ
*         };
*
*/
//------------------------------------------------------------------
bool NetworkBossUpdater::OnBossReadData( const nn::boss::NsDataHeaderInfo* pHeader , const size_t bodySize , const u8* pBody )
{
  return false;
}

//------------------------------------------------------------------
/**
* @brief t@CXg_E[hCxg
*
* @param[in] pTaskName    ^XNi[U^XN_E[hJnɐݒ肵́j
* @param[in] pFileList      t@CXg(nn::boss::NsaList::NsaInformation)
* @param[in] fileNum        t@C
*
* @note pFileList͔zɂȂĂ܂B
*       pFileList[fileNum-1]܂ŃANZXł܂B
*
*     struct NsaInformation
*     {
*        char fileName[32];       //t@C(ő31)
*        u32 fileSize;      //t@CTCY(Pʂ̓oCg)
*          u32 updateEpochTime;   //t@C̍XV(unix epochł邽߁A1970-01-01 00:00:00̌oߕb)BNSǍJJnlp邽߁A_E[hHTTPX|XLast-ModifiedƈvlƂȂB
*          char attribute1[10];   //1(ő9̕)Bgp\ȕ́Al(0-9)AAt@xbg(a-z,A-Z)AA_[o[(_)݂̂łBT[oUINSAƂɔCӂ̒lݒłBNSAXg擾ɂɊ܂܂NSAw肷邽߂̌vfƂȂB
*          char attribute2[10];   //2(ő9̕)Bgp\ȕʒuẤAattribute1 Ɠl
*          char attribute3[10];   //3(ő9̕)Bgp\ȕʒuẤAattribute1 Ɠl
*          u8 caption[150];     //BUTF-8ōŒ50̕BT[oUINSAƂɔCӂ̒lݒłB
*   };
*/
//------------------------------------------------------------------
void NetworkBossUpdater::OnBossRecvFileList( const char* pTaskName , const nn::boss::NsaList::NsaInformation* pFileList , const u32 fileNum )
{
  // NO_USE
}

//------------------------------------------------------------------
/**
* @brief t@CXg_E[hsʒmCxg
*
* @param[in] pTaskName    ^XNi[U^XNo^ɐݒ肵́j
* @param[in] result     s
*/
//------------------------------------------------------------------
void NetworkBossUpdater::OnBossRecvFileListFailed( const char* pTaskName , const nn::Result& result )
{
  // NO_USE
}


//------------------------------------------------------------------
/**
* @brief G[ʒmCxg
*
* @param[in] result   s
*/
//------------------------------------------------------------------
void NetworkBossUpdater::OnBossError( const nn::Result& result )
{
  GFL_PRINT( "OnBossError(%u)\n", result.GetDescription() );
}

//------------------------------------------------------------------
/**
* @brief ^XNG[ʒmCxg
*
* @param[in] pTaskName    ^XNi[U^XNo^ɐݒ肵́j
* @param[in] errorCode    G[R[h(nn::boss::TaskResultCode)
*/
//------------------------------------------------------------------
void NetworkBossUpdater::OnBossTaskError( const char* pTaskName , const u32 errorCode )
{
  // NO_USE
}



GFL_NAMESPACE_END(boss)
GFL_NAMESPACE_END(hologrammail)
GFL_NAMESPACE_END(app)

