//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		app_zukan_search_result_Proc.cpp
 *	@brief
 *	@author	Toru=Nagihashi
 *	@date		2012.08.22
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "app_zukan_search_result_Proc.h"

GFL_NAMESPACE_BEGIN(app)
GFL_NAMESPACE_BEGIN(zukan)
GFL_NAMESPACE_BEGIN(search_result)

//-----------------------------------------------------------------------
// RXgN^EfXgN^
//-----------------------------------------------------------------------
/**
 *  @brief RXgN^
 *  @param heap q[v
 *  @param manager }l[W[
 */
Proc::Proc( app::util::Heap *heap, ProcManager *manager ) :
  IProc( heap, manager ),
  m_is_end( false )
{
  m_view  = GFL_NEW(heap->GetSystemHeap()) list::ParentView( heap, this->GetGraphics(), this->GetDataManager() );
  m_view->SetListener( this );
  
  //}ӌʃ[h͐}Ӑ؂ւ{^ȂȂ
  m_view->InvisibleChangeZukanModeButton();
}

/**
 *  @brief fXgN^
 */
Proc::~Proc()
{
  GFL_SAFE_DELETE( m_view );
}

//-----------------------------------------------------------------------
// IProc
//-----------------------------------------------------------------------
/**
 *	@brief  PROC
 *	@param	manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::InitFunc(gfl::proc::Manager * manager)
{
  return gfl::proc::RES_FINISH;
}
/**
 *	@brief  PROCj
 *	@param	manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::EndFunc(gfl::proc::Manager * manager)
{
  return gfl::proc::RES_FINISH;
}
/**
 *	@brief  PROCC
 *	@param	manager vZX}l[W[
 *	@return Result IR[h
 */
gfl::proc::Result Proc::UpdateFunc(gfl::proc::Manager * manager)
{

  m_view->UpdateTree();
  
  if( m_is_end )
  {
    return gfl::proc::RES_FINISH;
  }
  else
  {
    return gfl::proc::RES_CONTINUE;
  }
}
/**
 *	@brief  PROC`
 *	@param	manager vZX}l[W[
 *	@return Result IR[h
 */
void Proc::DrawFunc(gfl::proc::Manager * manager)
{
  m_view->DrawTree();
}

bool Proc::OnTouchbarSelected( u32 buttonID )
{
  switch( buttonID )
  {
  case app::ui::UITouchBarView::BUTTON_ID_RETURN:
    m_is_end  = true;
    
    {
      SearchParameters param;
      *this->GetDataManager()->GetSearchParameters()  = param;
      this->GetDataManager()->GetListData()->StartSearch( param );
    }

    this->ChangeNextProc( ProcManager::PROC_ID_list );
    return false;
  case app::ui::UITouchBarView::BUTTON_ID_EXIT:
    m_is_end = true;
    this->TerminateAllProc();
    return false;
  case app::ui::UITouchBarView::BUTTON_ID_SEARCH:
    m_is_end  = true;
    
    this->GetGraphics()->DeletePokeModel();
    this->ChangeNextProc( ProcManager::PROC_ID_search );
    return false;
  }
  return true;
}
GFL_NAMESPACE_END(search_result)
GFL_NAMESPACE_END(zukan)
GFL_NAMESPACE_END(app)
