//============================================================================
/**
 *
 *	@file		FieldUniqueSequenceC02.h
 *	@brief  C02pFj[NV[PX
 *
 */
//============================================================================
#ifndef __FIELD_UNIQUE_SEQUENCE_C02_H__
#define __FIELD_UNIQUE_SEQUENCE_C02_H__
#pragma once

// gflib
#include <gflib.h>

#include "trainer/trid_def.h"

// field
#include "field/Fieldmap.h"
#include "field/FieldUniqueSequence.h"

namespace field {

//=============================================================================
/** 
*   C02pLj[NV[PX
*/ 
//=============================================================================
class FieldUniqueSequenceC02 : public FieldUniqueSequence
{
  GFL_FORBID_COPY_AND_ASSIGN(FieldUniqueSequenceC02);
 
public:
  
  //-------------------------------------
  ///	M~bN[N
  //=====================================
  typedef struct {
    int wall_idx;
  } C02_GIMMICK_WORK;

private:
  enum{
    SETUP_INIT_SEQ,
    SETUP_END_SEQ,
  };
  // Of[^
  Fieldmap* mp_fieldmap;  ///< tB[h}bv
  
  // [N
  void* mp_work_buffer;   ///< M~bN[Nobt@[

  f32 m_vol;

  s32 m_setup_seq;        ///< ZbgAbvV[PX

public:
  //----------------------------------------------------------------------------
  /**
   *  @brief   RXgN^
   *
   *  @param   pFieldmap  tB[h}bv(̃NXŕێ܂)
   */
  //-----------------------------------------------------------------------------
  FieldUniqueSequenceC02(Fieldmap* pFieldmap);

  //----------------------------------------------------------------------------
  /**
   *  @brief   fXgN^
   */
  //-----------------------------------------------------------------------------
  virtual ~FieldUniqueSequenceC02();

  //----------------------------------------------------------------------------
  /**
   *  @brief   SETUP̍ŌɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual b32 SetupLast(void);
 
  //----------------------------------------------------------------------------
  /**
   *  @brief   READY̍Ō1񂾂Ă΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void ReadyLastOnce(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   UPDATE̍ŏɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void UpdateFirst(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   UPDATE̍ŌɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void UpdateLast(void) 
  {
    return;
  }

  //----------------------------------------------------------------------------
  /**
   *  @brief   CALCULATĚɌĂ΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void CalculateAfter(void);

  //----------------------------------------------------------------------------
  /**
   *  @brief   FREE̍ŏ1񂾂Ă΂֐
   */
  //-----------------------------------------------------------------------------
  virtual void FreeFirstOnce(void);

};

} // namespace field

#endif		// __FIELD_UNIQUE_SEQUENCE_C02_H__

