//============================================================================
/**
 *
 *	@file		FieldUniqueSequenceC02.cpp
 *	@brief  C02pFj[NV[PX
 *
 */
//============================================================================


// gflib
#include <gflib.h>

// field
#include "field/Fieldmap.h"
#include "field/FieldGimmickWorkAccessor.h"
#include "field/FieldUniqueSequenceC02.h"

// arc
#include "arc/arc_def.h"                   // ARCID_*

#include "sound/sound.h"

namespace field {

//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 *
 *	@param	*pFieldmap tB[h}bv|C^
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceC02::FieldUniqueSequenceC02(Fieldmap* pFieldmap)
  : FieldUniqueSequence(pFieldmap),
  mp_work_buffer(NULL),
  m_vol(0),
  m_setup_seq(SETUP_INIT_SEQ)
{
  mp_fieldmap = pFieldmap;
}

//----------------------------------------------------------------------------
/**
 *	@brief@fXgN^
 */
//-----------------------------------------------------------------------------
FieldUniqueSequenceC02::~FieldUniqueSequenceC02()
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  ZbgAbv
 *
 *	@param	none
 *
 *	@retval TRUEŏI
 */
//-----------------------------------------------------------------------------
b32 FieldUniqueSequenceC02::SetupLast(void)
{
  
  // q[v擾
  gfl::heap::HeapBase*     heap_memory      = mp_fieldmap->GetHeapField();
  gfl::heap::HeapBase*     device_memory    = mp_fieldmap->GetDeviceHeapField();
  gfl::heap::NwAllocator*  device_allocator = mp_fieldmap->GetDeviceHeapFieldAllocator();

  {
    C02_GIMMICK_WORK gym_work;
    /// M~bN[N̏
    gamesystem::GameData* p_gdata = m_pFieldmap->GetGameManager()->GetGameData();

    // ATC̏ԂmFď
    b32 is_assigned = GimmickWorkAccessor::IsAssigned( p_gdata, GIMMICK_ID_C02 );
    // ATCs
    GimmickWorkAccessor::SecondAssign( p_gdata, GIMMICK_ID_C02 );
    // obt@[ۑ
    mp_work_buffer = GimmickWorkAccessor::GetWork( p_gdata );

    // ATCĂȂԂ̏ꍇ̓f[^
    if( is_assigned == FALSE )
    {
      gfl::std::MemClear( &gym_work, sizeof( C02_GIMMICK_WORK ) );
      BufferAccessorType<C02_GIMMICK_WORK>::SetValue(mp_work_buffer,0,gym_work);
    }
    else //ATCĂꍇ͕ǃf[^̃Zbg
    {
      gym_work = BufferAccessorType<C02_GIMMICK_WORK>::GetValue(mp_work_buffer,0 );
    }
        
  }

  //SE
  m_vol = 1.0f;//xy_snd::GetPlayerVolume( SEQ_SE_FLD_041 ); @todo

  //xy_snd::SetPlayerVolume( SEQ_SE_FLD_041, 0 );
  
  xy_snd::PlaySE( SEQ_SE_FLD_041 );
  xy_snd::ChangeSEVolume( SEQ_SE_FLD_041, 0 );

  m_setup_seq = SETUP_END_SEQ;

  return 1;
}

void FieldUniqueSequenceC02::ReadyLastOnce(void)
{
}

void FieldUniqueSequenceC02::UpdateFirst(void)
{  
  // ZbgAbvIĂs
  if( m_setup_seq != SETUP_END_SEQ )
  {
    return;
  }

  // vC[݂ȂƂsȂ
  PlayerGrid* p_player = mp_fieldmap->GetFieldPlayer();
  if( p_player == NULL ){
    return;
  }

  //䗦vZ
  f32 vol;
  s32 len;
  s32 x;
  s32 z;

  p_player->GetGrid()->GetPlanePos( &x, &z );

  len = z - 4;
  if ( len <= 0 ) len = 0;
  else if ( len > 19 ) len = 19; //@todo

  len = 19 - len; //@todo

  vol = m_vol * f32(len) / 19.0f ; //@todo

  xy_snd::ChangeSEVolume( SEQ_SE_FLD_041, vol );
}

//----------------------------------------------------------------------------
/**
 *  @brief   CALCULATĚɌĂ΂֐
 *
 *	@param	none
 *
 *	@retval
 */
//-----------------------------------------------------------------------------
void FieldUniqueSequenceC02::CalculateAfter(void)
{
}

void FieldUniqueSequenceC02::FreeFirstOnce(void)
{
  xy_snd::StopSE( SEQ_SE_FLD_041 );
}

} // namespace field

